# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityGroupArgs', 'SecurityGroup']

@pulumi.input_type
class SecurityGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecurityGroup resource.
        :param pulumi.Input[str] description: Specifies the description of the iec security group. description must be
               0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
               new iec security group resource.
        :param pulumi.Input[str] name: Specifies the name for the security group. This parameter can contain a maximum
               of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
               group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the iec security group. description must be
        0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
        new iec security group resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name for the security group. This parameter can contain a maximum
        of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
        group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SecurityGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_group_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGroupSecurityGroupRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering SecurityGroup resources.
        :param pulumi.Input[str] description: Specifies the description of the iec security group. description must be
               0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
               new iec security group resource.
        :param pulumi.Input[str] name: Specifies the name for the security group. This parameter can contain a maximum
               of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
               group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityGroupSecurityGroupRuleArgs']]] security_group_rules: An Array of one or more security group rules. The security_group_rules object structure is
               documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_rules is not None:
            pulumi.set(__self__, "security_group_rules", security_group_rules)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the iec security group. description must be
        0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
        new iec security group resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name for the security group. This parameter can contain a maximum
        of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
        group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityGroupRules")
    def security_group_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGroupSecurityGroupRuleArgs']]]]:
        """
        An Array of one or more security group rules. The security_group_rules object structure is
        documented below.
        """
        return pulumi.get(self, "security_group_rules")

    @security_group_rules.setter
    def security_group_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityGroupSecurityGroupRuleArgs']]]]):
        pulumi.set(self, "security_group_rules", value)


class SecurityGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a IEC security group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_secgroup_name = config.require_object("iecSecgroupName")
        secgroup_test = huaweicloud.iec.SecurityGroup("secgroupTest")
        ```

        ## Import

        IEC Security Groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/securityGroup:SecurityGroup secgroup_test 2a02d1d3-437c-11eb-b721-fa163e8ac569
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the iec security group. description must be
               0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
               new iec security group resource.
        :param pulumi.Input[str] name: Specifies the name for the security group. This parameter can contain a maximum
               of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
               group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a IEC security group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_secgroup_name = config.require_object("iecSecgroupName")
        secgroup_test = huaweicloud.iec.SecurityGroup("secgroupTest")
        ```

        ## Import

        IEC Security Groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/securityGroup:SecurityGroup secgroup_test 2a02d1d3-437c-11eb-b721-fa163e8ac569
        ```

        :param str resource_name: The name of the resource.
        :param SecurityGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupArgs.__new__(SecurityGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["security_group_rules"] = None
        super(SecurityGroup, __self__).__init__(
            'huaweicloud:Iec/securityGroup:SecurityGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            security_group_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityGroupSecurityGroupRuleArgs']]]]] = None) -> 'SecurityGroup':
        """
        Get an existing SecurityGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the iec security group. description must be
               0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
               new iec security group resource.
        :param pulumi.Input[str] name: Specifies the name for the security group. This parameter can contain a maximum
               of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
               group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecurityGroupSecurityGroupRuleArgs']]]] security_group_rules: An Array of one or more security group rules. The security_group_rules object structure is
               documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupState.__new__(_SecurityGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["security_group_rules"] = security_group_rules
        return SecurityGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the iec security group. description must be
        0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
        new iec security group resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name for the security group. This parameter can contain a maximum
        of 64 characters, which may consist of letters, digits, dot (.), underscores (_), and hyphens (-). The iec security
        group allowed to have the same name. Changing this parameter will creates a new iec security group resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityGroupRules")
    def security_group_rules(self) -> pulumi.Output[Sequence['outputs.SecurityGroupSecurityGroupRule']]:
        """
        An Array of one or more security group rules. The security_group_rules object structure is
        documented below.
        """
        return pulumi.get(self, "security_group_rules")

