# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkAclRuleArgs', 'NetworkAclRule']

@pulumi.input_type
class NetworkAclRuleArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[str],
                 network_acl_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_address: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkAclRule resource.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are *ingress* or *egress*
               . Changing this parameter creates a new iec network ACL rule resource.
        :param pulumi.Input[str] network_acl_id: Specifies a unique id for the iec network ACL.
        :param pulumi.Input[str] action: Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
               or *deny*.
        :param pulumi.Input[str] description: Specifies the description for the iec network ACL rule.
        :param pulumi.Input[str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        :param pulumi.Input[bool] enabled: Specifies the Enabled status for the iec network ACL rule. The default value is true.
        :param pulumi.Input[int] ip_version: The version of elastic IP address. IEC services only support IPv4(4) now.
        :param pulumi.Input[str] protocol: Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
               , *udp*, *icmp* and *any*.
        :param pulumi.Input[str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example:
               xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "network_acl_id", network_acl_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        Specifies the direction of the rule, valid values are *ingress* or *egress*
        . Changing this parameter creates a new iec network ACL rule resource.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> pulumi.Input[str]:
        """
        Specifies a unique id for the iec network ACL.
        """
        return pulumi.get(self, "network_acl_id")

    @network_acl_id.setter
    def network_acl_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_acl_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
        or *deny*.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description for the iec network ACL rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_ip_address", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the Enabled status for the iec network ACL rule. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of elastic IP address. IEC services only support IPv4(4) now.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
        , *udp*, *icmp* and *any*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example:
        xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip_address", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class _NetworkAclRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_address: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 network_acl_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkAclRule resources.
        :param pulumi.Input[str] action: Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
               or *deny*.
        :param pulumi.Input[str] description: Specifies the description for the iec network ACL rule.
        :param pulumi.Input[str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are *ingress* or *egress*
               . Changing this parameter creates a new iec network ACL rule resource.
        :param pulumi.Input[bool] enabled: Specifies the Enabled status for the iec network ACL rule. The default value is true.
        :param pulumi.Input[int] ip_version: The version of elastic IP address. IEC services only support IPv4(4) now.
        :param pulumi.Input[str] network_acl_id: Specifies a unique id for the iec network ACL.
        :param pulumi.Input[str] protocol: Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
               , *udp*, *icmp* and *any*.
        :param pulumi.Input[str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example:
               xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if network_acl_id is not None:
            pulumi.set(__self__, "network_acl_id", network_acl_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
        or *deny*.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description for the iec network ACL rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_ip_address", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the direction of the rule, valid values are *ingress* or *egress*
        . Changing this parameter creates a new iec network ACL rule resource.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the Enabled status for the iec network ACL rule. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of elastic IP address. IEC services only support IPv4(4) now.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique id for the iec network ACL.
        """
        return pulumi.get(self, "network_acl_id")

    @network_acl_id.setter
    def network_acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_acl_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
        , *udp*, *icmp* and *any*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example:
        xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip_address", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port", value)


class NetworkAclRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_address: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 network_acl_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a network ACL rule resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        acl_test = huaweicloud.iec.NetworkAcl("aclTest")
        rule_test = huaweicloud.iec.NetworkAclRule("ruleTest",
            network_acl_id=acl_test.id,
            direction="ingress",
            protocol="tcp",
            action="allow",
            source_ip_address="152.16.30.0/24",
            destination_ip_address="192.168.128.0/18",
            destination_port="445",
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
               or *deny*.
        :param pulumi.Input[str] description: Specifies the description for the iec network ACL rule.
        :param pulumi.Input[str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are *ingress* or *egress*
               . Changing this parameter creates a new iec network ACL rule resource.
        :param pulumi.Input[bool] enabled: Specifies the Enabled status for the iec network ACL rule. The default value is true.
        :param pulumi.Input[int] ip_version: The version of elastic IP address. IEC services only support IPv4(4) now.
        :param pulumi.Input[str] network_acl_id: Specifies a unique id for the iec network ACL.
        :param pulumi.Input[str] protocol: Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
               , *udp*, *icmp* and *any*.
        :param pulumi.Input[str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example:
               xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network ACL rule resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        acl_test = huaweicloud.iec.NetworkAcl("aclTest")
        rule_test = huaweicloud.iec.NetworkAclRule("ruleTest",
            network_acl_id=acl_test.id,
            direction="ingress",
            protocol="tcp",
            action="allow",
            source_ip_address="152.16.30.0/24",
            destination_ip_address="192.168.128.0/18",
            destination_port="445",
            enabled=True)
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_ip_address: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 network_acl_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_ip_address: Optional[pulumi.Input[str]] = None,
                 source_port: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclRuleArgs.__new__(NetworkAclRuleArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_ip_address"] = destination_ip_address
            __props__.__dict__["destination_port"] = destination_port
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip_version"] = ip_version
            if network_acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_acl_id'")
            __props__.__dict__["network_acl_id"] = network_acl_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["source_ip_address"] = source_ip_address
            __props__.__dict__["source_port"] = source_port
            __props__.__dict__["policy_id"] = None
        super(NetworkAclRule, __self__).__init__(
            'huaweicloud:Iec/networkAclRule:NetworkAclRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            destination_ip_address: Optional[pulumi.Input[str]] = None,
            destination_port: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            ip_version: Optional[pulumi.Input[int]] = None,
            network_acl_id: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            source_ip_address: Optional[pulumi.Input[str]] = None,
            source_port: Optional[pulumi.Input[str]] = None) -> 'NetworkAclRule':
        """
        Get an existing NetworkAclRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
               or *deny*.
        :param pulumi.Input[str] description: Specifies the description for the iec network ACL rule.
        :param pulumi.Input[str] destination_ip_address: Specifies the destination IP address to which the traffic is allowed.
               The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] destination_port: Specifies the destination port number or port number range. The value ranges
               from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are *ingress* or *egress*
               . Changing this parameter creates a new iec network ACL rule resource.
        :param pulumi.Input[bool] enabled: Specifies the Enabled status for the iec network ACL rule. The default value is true.
        :param pulumi.Input[int] ip_version: The version of elastic IP address. IEC services only support IPv4(4) now.
        :param pulumi.Input[str] network_acl_id: Specifies a unique id for the iec network ACL.
        :param pulumi.Input[str] protocol: Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
               , *udp*, *icmp* and *any*.
        :param pulumi.Input[str] source_ip_address: Specifies the source IP address that the traffic is allowed from. The default
               value is *0.0.0.0/0*. For example:
               xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        :param pulumi.Input[str] source_port: Specifies the source port number or port number range. The value ranges from 1 to
               65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclRuleState.__new__(_NetworkAclRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_ip_address"] = destination_ip_address
        __props__.__dict__["destination_port"] = destination_port
        __props__.__dict__["direction"] = direction
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["network_acl_id"] = network_acl_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source_ip_address"] = source_ip_address
        __props__.__dict__["source_port"] = source_port
        return NetworkAclRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the action in the iec network ACL rule. Currently, the value can be *allow*
        or *deny*.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description for the iec network ACL rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the destination IP address to which the traffic is allowed.
        The default value is *0.0.0.0/0*. For example: xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "destination_ip_address")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the destination port number or port number range. The value ranges
        from 1 to 65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        """
        Specifies the direction of the rule, valid values are *ingress* or *egress*
        . Changing this parameter creates a new iec network ACL rule resource.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies the Enabled status for the iec network ACL rule. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[int]]:
        """
        The version of elastic IP address. IEC services only support IPv4(4) now.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> pulumi.Output[str]:
        """
        Specifies a unique id for the iec network ACL.
        """
        return pulumi.get(self, "network_acl_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the protocol supported by the iec network ACL rule. Valid values are: *tcp*
        , *udp*, *icmp* and *any*.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the source IP address that the traffic is allowed from. The default
        value is *0.0.0.0/0*. For example:
        xxx.xxx.xxx.xxx (IP address), xxx.xxx.xxx.0/24 (CIDR block).
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the source port number or port number range. The value ranges from 1 to
        65535. For a port number range, enter two port numbers connected by a hyphen (-). For example, 1-100.
        """
        return pulumi.get(self, "source_port")

