# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KeypairArgs', 'Keypair']

@pulumi.input_type
class KeypairArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Keypair resource.
        :param pulumi.Input[str] name: Specifies a unique name for the keypair. This parameter can contain a maximum of
               64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
               a new keypair resource.
        :param pulumi.Input[str] public_key: Specifies a pregenerated OpenSSH-formatted public key. Changing this
               parameter creates a new keypair resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name for the keypair. This parameter can contain a maximum of
        64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
        a new keypair resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a pregenerated OpenSSH-formatted public key. Changing this
        parameter creates a new keypair resource.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _KeypairState:
    def __init__(__self__, *,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Keypair resources.
        :param pulumi.Input[str] fingerprint: The finger of iec keypair. The value contains a encoding type(SHA256) and a string of 43 characters.
        :param pulumi.Input[str] name: Specifies a unique name for the keypair. This parameter can contain a maximum of
               64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
               a new keypair resource.
        :param pulumi.Input[str] public_key: Specifies a pregenerated OpenSSH-formatted public key. Changing this
               parameter creates a new keypair resource.
        """
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The finger of iec keypair. The value contains a encoding type(SHA256) and a string of 43 characters.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a unique name for the keypair. This parameter can contain a maximum of
        64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
        a new keypair resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a pregenerated OpenSSH-formatted public key. Changing this
        parameter creates a new keypair resource.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Keypair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a keypair resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_keypair = huaweicloud.iec.Keypair("testKeypair")
        ```

        ## Import

        Keypairs can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/keypair:Keypair test_keypair iec-keypair-demo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies a unique name for the keypair. This parameter can contain a maximum of
               64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
               a new keypair resource.
        :param pulumi.Input[str] public_key: Specifies a pregenerated OpenSSH-formatted public key. Changing this
               parameter creates a new keypair resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KeypairArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a keypair resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_keypair = huaweicloud.iec.Keypair("testKeypair")
        ```

        ## Import

        Keypairs can be imported using the `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/keypair:Keypair test_keypair iec-keypair-demo
        ```

        :param str resource_name: The name of the resource.
        :param KeypairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeypairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeypairArgs.__new__(KeypairArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["region"] = region
            __props__.__dict__["fingerprint"] = None
        super(Keypair, __self__).__init__(
            'huaweicloud:Iec/keypair:Keypair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Keypair':
        """
        Get an existing Keypair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fingerprint: The finger of iec keypair. The value contains a encoding type(SHA256) and a string of 43 characters.
        :param pulumi.Input[str] name: Specifies a unique name for the keypair. This parameter can contain a maximum of
               64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
               a new keypair resource.
        :param pulumi.Input[str] public_key: Specifies a pregenerated OpenSSH-formatted public key. Changing this
               parameter creates a new keypair resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeypairState.__new__(_KeypairState)

        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["region"] = region
        return Keypair(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        The finger of iec keypair. The value contains a encoding type(SHA256) and a string of 43 characters.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies a unique name for the keypair. This parameter can contain a maximum of
        64 characters, which may consist of letters, digits, underscores (_), and hyphens (-). Changing this parameter creates
        a new keypair resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        Specifies a pregenerated OpenSSH-formatted public key. Changing this
        parameter creates a new keypair resource.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        return pulumi.get(self, "region")

