# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetwork_aclResult',
    'AwaitableGetNetwork_aclResult',
    'get_network_acl',
    'get_network_acl_output',
]

@pulumi.output_type
class GetNetwork_aclResult:
    """
    A collection of values returned by getNetwork_acl.
    """
    def __init__(__self__, description=None, id=None, inbound_rules=None, name=None, networks=None, outbound_rules=None, status=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_rules and not isinstance(inbound_rules, list):
            raise TypeError("Expected argument 'inbound_rules' to be a list")
        pulumi.set(__self__, "inbound_rules", inbound_rules)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if outbound_rules and not isinstance(outbound_rules, list):
            raise TypeError("Expected argument 'outbound_rules' to be a list")
        pulumi.set(__self__, "outbound_rules", outbound_rules)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the IEC network ACL.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> Sequence[str]:
        return pulumi.get(self, "inbound_rules")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetNetwork_aclNetworkResult']:
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Sequence[str]:
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the IEC network ACL.
        """
        return pulumi.get(self, "status")


class AwaitableGetNetwork_aclResult(GetNetwork_aclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetwork_aclResult(
            description=self.description,
            id=self.id,
            inbound_rules=self.inbound_rules,
            name=self.name,
            networks=self.networks,
            outbound_rules=self.outbound_rules,
            status=self.status)


def get_network_acl(id: Optional[str] = None,
                    name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetwork_aclResult:
    """
    Use this data source to get the details of a specific IEC network ACL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    acl_name = config.require_object("aclName")
    firewall = huaweicloud.Iec.get_network_acl(name=acl_name)
    ```


    :param str id: Specifies the ID of the IEC network ACL to retrieve.
    :param str name: Specifies the name if the IEC network ACL with a maximum of 64 characters.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getNetwork_acl:getNetwork_acl', __args__, opts=opts, typ=GetNetwork_aclResult).value

    return AwaitableGetNetwork_aclResult(
        description=__ret__.description,
        id=__ret__.id,
        inbound_rules=__ret__.inbound_rules,
        name=__ret__.name,
        networks=__ret__.networks,
        outbound_rules=__ret__.outbound_rules,
        status=__ret__.status)


@_utilities.lift_output_func(get_network_acl)
def get_network_acl_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetwork_aclResult]:
    """
    Use this data source to get the details of a specific IEC network ACL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    acl_name = config.require_object("aclName")
    firewall = huaweicloud.Iec.get_network_acl(name=acl_name)
    ```


    :param str id: Specifies the ID of the IEC network ACL to retrieve.
    :param str name: Specifies the name if the IEC network ACL with a maximum of 64 characters.
    """
    ...
