# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetImagesResult',
    'AwaitableGetImagesResult',
    'get_images',
    'get_images_output',
]

@pulumi.output_type
class GetImagesResult:
    """
    A collection of values returned by getImages.
    """
    def __init__(__self__, id=None, images=None, name=None, os_type=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetImagesImageResult']:
        """
        An array of one or more image. The images object structure is documented below.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the iec images.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        The os_type of the iec images.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetImagesResult(GetImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagesResult(
            id=self.id,
            images=self.images,
            name=self.name,
            os_type=self.os_type,
            region=self.region)


def get_images(name: Optional[str] = None,
               os_type: Optional[str] = None,
               region: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagesResult:
    """
    Use this data source to get the available of HuaweiCloud IEC images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    iec_image = huaweicloud.Iec.get_images(os_type="Linux")
    ```


    :param str name: Specifies the image Name, which can be queried with a regular expression.
    :param str os_type: Specifies the os type of the iec image.
           "Linux", "Windows" and "Other" are supported.
    :param str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['osType'] = os_type
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getImages:getImages', __args__, opts=opts, typ=GetImagesResult).value

    return AwaitableGetImagesResult(
        id=__ret__.id,
        images=__ret__.images,
        name=__ret__.name,
        os_type=__ret__.os_type,
        region=__ret__.region)


@_utilities.lift_output_func(get_images)
def get_images_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                      os_type: Optional[pulumi.Input[Optional[str]]] = None,
                      region: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImagesResult]:
    """
    Use this data source to get the available of HuaweiCloud IEC images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    iec_image = huaweicloud.Iec.get_images(os_type="Linux")
    ```


    :param str name: Specifies the image Name, which can be queried with a regular expression.
    :param str os_type: Specifies the os type of the iec image.
           "Linux", "Windows" and "Other" are supported.
    :param str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    """
    ...
