# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEipsResult',
    'AwaitableGetEipsResult',
    'get_eips',
    'get_eips_output',
]

@pulumi.output_type
class GetEipsResult:
    """
    A collection of values returned by getEips.
    """
    def __init__(__self__, eips=None, id=None, port_id=None, site_id=None, site_info=None):
        if eips and not isinstance(eips, list):
            raise TypeError("Expected argument 'eips' to be a list")
        pulumi.set(__self__, "eips", eips)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if port_id and not isinstance(port_id, str):
            raise TypeError("Expected argument 'port_id' to be a str")
        pulumi.set(__self__, "port_id", port_id)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if site_info and not isinstance(site_info, str):
            raise TypeError("Expected argument 'site_info' to be a str")
        pulumi.set(__self__, "site_info", site_info)

    @property
    @pulumi.getter
    def eips(self) -> Sequence['outputs.GetEipsEipResult']:
        """
        A list of all the EIPs found. The object is documented below.
        """
        return pulumi.get(self, "eips")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[str]:
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> str:
        """
        The located information of the iec site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")


class AwaitableGetEipsResult(GetEipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipsResult(
            eips=self.eips,
            id=self.id,
            port_id=self.port_id,
            site_id=self.site_id,
            site_info=self.site_info)


def get_eips(port_id: Optional[str] = None,
             site_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipsResult:
    """
    Use this data source to get a list of EIPs belong to a specific IEC site.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    sites_test = huaweicloud.Iec.get_sites()
    site = huaweicloud.Iec.get_eips(site_id=sites_test.sites[0].id)
    ```


    :param str port_id: Specifies the ID of the port.
    :param str site_id: Specifies the ID of the IEC site.
    """
    __args__ = dict()
    __args__['portId'] = port_id
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getEips:getEips', __args__, opts=opts, typ=GetEipsResult).value

    return AwaitableGetEipsResult(
        eips=__ret__.eips,
        id=__ret__.id,
        port_id=__ret__.port_id,
        site_id=__ret__.site_id,
        site_info=__ret__.site_info)


@_utilities.lift_output_func(get_eips)
def get_eips_output(port_id: Optional[pulumi.Input[Optional[str]]] = None,
                    site_id: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEipsResult]:
    """
    Use this data source to get a list of EIPs belong to a specific IEC site.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    sites_test = huaweicloud.Iec.get_sites()
    site = huaweicloud.Iec.get_eips(site_id=sites_test.sites[0].id)
    ```


    :param str port_id: Specifies the ID of the port.
    :param str site_id: Specifies the ID of the IEC site.
    """
    ...
