# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBandwidthsResult',
    'AwaitableGetBandwidthsResult',
    'get_bandwidths',
    'get_bandwidths_output',
]

@pulumi.output_type
class GetBandwidthsResult:
    """
    A collection of values returned by getBandwidths.
    """
    def __init__(__self__, bandwidths=None, id=None, site_id=None, site_info=None):
        if bandwidths and not isinstance(bandwidths, list):
            raise TypeError("Expected argument 'bandwidths' to be a list")
        pulumi.set(__self__, "bandwidths", bandwidths)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)
        if site_info and not isinstance(site_info, str):
            raise TypeError("Expected argument 'site_info' to be a str")
        pulumi.set(__self__, "site_info", site_info)

    @property
    @pulumi.getter
    def bandwidths(self) -> Sequence['outputs.GetBandwidthsBandwidthResult']:
        """
        A list of all the bandwidths found. The object is documented below.
        """
        return pulumi.get(self, "bandwidths")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> str:
        """
        The located information of the iec site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")


class AwaitableGetBandwidthsResult(GetBandwidthsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBandwidthsResult(
            bandwidths=self.bandwidths,
            id=self.id,
            site_id=self.site_id,
            site_info=self.site_info)


def get_bandwidths(site_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBandwidthsResult:
    """
    Use this data source to get a list of bandwidths belong to a specific IEC site.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    sites_test = huaweicloud.Iec.get_sites()
    demo = huaweicloud.Iec.get_bandwidths(site_id=sites_test.sites[0].id)
    ```


    :param str site_id: Specifies the ID of the IEC site.
    """
    __args__ = dict()
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getBandwidths:getBandwidths', __args__, opts=opts, typ=GetBandwidthsResult).value

    return AwaitableGetBandwidthsResult(
        bandwidths=__ret__.bandwidths,
        id=__ret__.id,
        site_id=__ret__.site_id,
        site_info=__ret__.site_info)


@_utilities.lift_output_func(get_bandwidths)
def get_bandwidths_output(site_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBandwidthsResult]:
    """
    Use this data source to get a list of bandwidths belong to a specific IEC site.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    sites_test = huaweicloud.Iec.get_sites()
    demo = huaweicloud.Iec.get_bandwidths(site_id=sites_test.sites[0].id)
    ```


    :param str site_id: Specifies the ID of the IEC site.
    """
    ...
