# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, enabled=None, id=None, name=None, users=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates the whether the IAM user is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Indicates the IAM user name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        The details of the queried IAM users. The structure is documented below.
        """
        return pulumi.get(self, "users")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            users=self.users)


def get_users(enabled: Optional[bool] = None,
              name: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    Use this data source to query the IAM user list within HuaweiCloud.

    > You *must* have IAM read privileges to use this data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    all = huaweicloud.Iam.get_users()
    one = huaweicloud.Iam.get_users(name="user_name")
    ```


    :param bool enabled: Specifies the status of the IAM user, the default value is **true**.
    :param str name: Specifies the IAM user name.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iam/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        enabled=__ret__.enabled,
        id=__ret__.id,
        name=__ret__.name,
        users=__ret__.users)


@_utilities.lift_output_func(get_users)
def get_users_output(enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsersResult]:
    """
    Use this data source to query the IAM user list within HuaweiCloud.

    > You *must* have IAM read privileges to use this data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    all = huaweicloud.Iam.get_users()
    one = huaweicloud.Iam.get_users(name="user_name")
    ```


    :param bool enabled: Specifies the status of the IAM user, the default value is **true**.
    :param str name: Specifies the IAM user name.
    """
    ...
