# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpengaussInstanceArgs', 'OpengaussInstance']

@pulumi.input_type
class OpengaussInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 flavor: pulumi.Input[str],
                 ha: pulumi.Input['OpengaussInstanceHaArgs'],
                 password: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 volume: pulumi.Input['OpengaussInstanceVolumeArgs'],
                 vpc_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 coordinator_num: Optional[pulumi.Input[int]] = None,
                 datastore: Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 sharding_num: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OpengaussInstance resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone information, can be three same or
               different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please reference the API docs for valid
               options. Changing this parameter will create a new resource.
        :param pulumi.Input['OpengaussInstanceHaArgs'] ha: Specifies the HA information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the database password. The value must be `8` to `32` characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of VPC subnet to which the instance belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input['OpengaussInstanceVolumeArgs'] volume: Specifies the volume storage information.
               The object structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the subnet belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input['OpengaussInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy.
               The object structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of opengauss instance.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] configuration_id: Specifies the parameter template ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] coordinator_num: Specifies the coordinator number. Values: 1~9. The default value is 3.
               The value must not be greater than twice value of `sharding_num`.
               This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input['OpengaussInstanceDatastoreArgs'] datastore: Specifies the datastore information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: Specifies whether to import the instance with the given configuration instead of
               creation. If specified, try to import the instance instead of creation if the instance already existed.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name.
               The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] period: Specifies the charging period of opengauss instance.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of opengauss instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] port: Specifies the port information. Defaults to `8,000`.
               The valid values are as follows:
               + `2,378` to `2,380`
        :param pulumi.Input[str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] replica_num: The replica number. The valid values are **2** and **3**, defaults to **3**.
               Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
               This parameter is valid only when the HA mode is set to **centralization_standard**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID to which the instance belongs.
               If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
               includes the `100` ports starting with the database port.
               (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        :param pulumi.Input[int] sharding_num: Specifies the sharding number. The valid value is range form `1` to `9`.
               The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to **UTC+08:00**.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "ha", ha)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "volume", volume)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if coordinator_num is not None:
            pulumi.set(__self__, "coordinator_num", coordinator_num)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_num is not None:
            pulumi.set(__self__, "replica_num", replica_num)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if sharding_num is not None:
            pulumi.set(__self__, "sharding_num", sharding_num)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone information, can be three same or
        different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications. Please reference the API docs for valid
        options. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def ha(self) -> pulumi.Input['OpengaussInstanceHaArgs']:
        """
        Specifies the HA information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha")

    @ha.setter
    def ha(self, value: pulumi.Input['OpengaussInstanceHaArgs']):
        pulumi.set(self, "ha", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the database password. The value must be `8` to `32` characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of VPC subnet to which the instance belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['OpengaussInstanceVolumeArgs']:
        """
        Specifies the volume storage information.
        The object structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['OpengaussInstanceVolumeArgs']):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID to which the subnet belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of opengauss instance.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter template ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="coordinatorNum")
    def coordinator_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the coordinator number. Values: 1~9. The default value is 3.
        The value must not be greater than twice value of `sharding_num`.
        This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "coordinator_num")

    @coordinator_num.setter
    def coordinator_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "coordinator_num", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']]:
        """
        Specifies the datastore information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to import the instance with the given configuration instead of
        creation. If specified, try to import the instance instead of creation if the instance already existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name.
        The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of opengauss instance.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of opengauss instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the port information. Defaults to `8,000`.
        The valid values are as follows:
        + `2,378` to `2,380`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaNum")
    def replica_num(self) -> Optional[pulumi.Input[int]]:
        """
        The replica number. The valid values are **2** and **3**, defaults to **3**.
        Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
        This parameter is valid only when the HA mode is set to **centralization_standard**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "replica_num")

    @replica_num.setter
    def replica_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_num", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID to which the instance belongs.
        If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
        includes the `100` ports starting with the database port.
        (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="shardingNum")
    def sharding_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the sharding number. The valid value is range form `1` to `9`.
        The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "sharding_num")

    @sharding_num.setter
    def sharding_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sharding_num", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone. Defaults to **UTC+08:00**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _OpengaussInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 coordinator_num: Optional[pulumi.Input[int]] = None,
                 datastore: Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 ha: Optional[pulumi.Input['OpengaussInstanceHaArgs']] = None,
                 maintenance_window: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['OpengaussInstanceNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 sharding_num: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 switch_strategy: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input['OpengaussInstanceVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OpengaussInstance resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone information, can be three same or
               different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        :param pulumi.Input['OpengaussInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy.
               The object structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of opengauss instance.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] configuration_id: Specifies the parameter template ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] coordinator_num: Specifies the coordinator number. Values: 1~9. The default value is 3.
               The value must not be greater than twice value of `sharding_num`.
               This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input['OpengaussInstanceDatastoreArgs'] datastore: Specifies the datastore information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Indicates the connection endpoints list of the DB instance. Example: [127.0.0.1:8000].
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please reference the API docs for valid
               options. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: Specifies whether to import the instance with the given configuration instead of
               creation. If specified, try to import the instance instead of creation if the instance already existed.
        :param pulumi.Input['OpengaussInstanceHaArgs'] ha: Specifies the HA information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] maintenance_window: Indicates the maintenance window.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name.
               The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input['OpengaussInstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be `8` to `32` characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of opengauss instance.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of opengauss instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] port: Specifies the port information. Defaults to `8,000`.
               The valid values are as follows:
               + `2,378` to `2,380`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address of the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address of the DB instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] replica_num: The replica number. The valid values are **2** and **3**, defaults to **3**.
               Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
               This parameter is valid only when the HA mode is set to **centralization_standard**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID to which the instance belongs.
               If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
               includes the `100` ports starting with the database port.
               (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        :param pulumi.Input[int] sharding_num: Specifies the sharding number. The valid value is range form `1` to `9`.
               The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of VPC subnet to which the instance belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] switch_strategy: Indicates the switch strategy.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to **UTC+08:00**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies the volume type. Only **ULTRAHIGH** is supported now.
               Changing this parameter will create a new resource.
        :param pulumi.Input['OpengaussInstanceVolumeArgs'] volume: Specifies the volume storage information.
               The object structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the subnet belongs.
               Changing this parameter will create a new resource.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if coordinator_num is not None:
            pulumi.set(__self__, "coordinator_num", coordinator_num)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if ha is not None:
            pulumi.set(__self__, "ha", ha)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_num is not None:
            pulumi.set(__self__, "replica_num", replica_num)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if sharding_num is not None:
            pulumi.set(__self__, "sharding_num", sharding_num)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if switch_strategy is not None:
            pulumi.set(__self__, "switch_strategy", switch_strategy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone information, can be three same or
        different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['OpengaussInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of opengauss instance.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameter template ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="coordinatorNum")
    def coordinator_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the coordinator number. Values: 1~9. The default value is 3.
        The value must not be greater than twice value of `sharding_num`.
        This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "coordinator_num")

    @coordinator_num.setter
    def coordinator_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "coordinator_num", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']]:
        """
        Specifies the datastore information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['OpengaussInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the connection endpoints list of the DB instance. Example: [127.0.0.1:8000].
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance specifications. Please reference the API docs for valid
        options. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to import the instance with the given configuration instead of
        creation. If specified, try to import the instance instead of creation if the instance already existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter
    def ha(self) -> Optional[pulumi.Input['OpengaussInstanceHaArgs']]:
        """
        Specifies the HA information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha")

    @ha.setter
    def ha(self, value: Optional[pulumi.Input['OpengaussInstanceHaArgs']]):
        pulumi.set(self, "ha", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name.
        The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpengaussInstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpengaussInstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database password. The value must be `8` to `32` characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of opengauss instance.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of opengauss instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the port information. Defaults to `8,000`.
        The valid values are as follows:
        + `2,378` to `2,380`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the public IP address of the DB instance.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaNum")
    def replica_num(self) -> Optional[pulumi.Input[int]]:
        """
        The replica number. The valid values are **2** and **3**, defaults to **3**.
        Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
        This parameter is valid only when the HA mode is set to **centralization_standard**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "replica_num")

    @replica_num.setter
    def replica_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_num", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID to which the instance belongs.
        If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
        includes the `100` ports starting with the database port.
        (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="shardingNum")
    def sharding_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the sharding number. The valid value is range form `1` to `9`.
        The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "sharding_num")

    @sharding_num.setter
    def sharding_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sharding_num", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of VPC subnet to which the instance belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the switch strategy.
        """
        return pulumi.get(self, "switch_strategy")

    @switch_strategy.setter
    def switch_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_strategy", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone. Defaults to **UTC+08:00**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume type. Only **ULTRAHIGH** is supported now.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['OpengaussInstanceVolumeArgs']]:
        """
        Specifies the volume storage information.
        The object structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['OpengaussInstanceVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID to which the subnet belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class OpengaussInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 coordinator_num: Optional[pulumi.Input[int]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceDatastoreArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 ha: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceHaArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 sharding_num: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceVolumeArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        GaussDB OpenGauss instance management within HuaweiCoud.

        ## Example Usage

        ## Import

        OpenGaussDB instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDBforOpenGauss/opengaussInstance:OpengaussInstance test ee678f40-ce8e-4d0c-8221-38dead426f06
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone information, can be three same or
               different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy.
               The object structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of opengauss instance.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] configuration_id: Specifies the parameter template ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] coordinator_num: Specifies the coordinator number. Values: 1~9. The default value is 3.
               The value must not be greater than twice value of `sharding_num`.
               This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceDatastoreArgs']] datastore: Specifies the datastore information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please reference the API docs for valid
               options. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: Specifies whether to import the instance with the given configuration instead of
               creation. If specified, try to import the instance instead of creation if the instance already existed.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceHaArgs']] ha: Specifies the HA information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name.
               The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[str] password: Specifies the database password. The value must be `8` to `32` characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of opengauss instance.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of opengauss instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] port: Specifies the port information. Defaults to `8,000`.
               The valid values are as follows:
               + `2,378` to `2,380`
        :param pulumi.Input[str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] replica_num: The replica number. The valid values are **2** and **3**, defaults to **3**.
               Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
               This parameter is valid only when the HA mode is set to **centralization_standard**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID to which the instance belongs.
               If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
               includes the `100` ports starting with the database port.
               (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        :param pulumi.Input[int] sharding_num: Specifies the sharding number. The valid value is range form `1` to `9`.
               The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of VPC subnet to which the instance belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to **UTC+08:00**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceVolumeArgs']] volume: Specifies the volume storage information.
               The object structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the subnet belongs.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpengaussInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        GaussDB OpenGauss instance management within HuaweiCoud.

        ## Example Usage

        ## Import

        OpenGaussDB instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDBforOpenGauss/opengaussInstance:OpengaussInstance test ee678f40-ce8e-4d0c-8221-38dead426f06
        ```

        :param str resource_name: The name of the resource.
        :param OpengaussInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpengaussInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 coordinator_num: Optional[pulumi.Input[int]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceDatastoreArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 ha: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceHaArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 sharding_num: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceVolumeArgs']]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpengaussInstanceArgs.__new__(OpengaussInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["configuration_id"] = configuration_id
            __props__.__dict__["coordinator_num"] = coordinator_num
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["force_import"] = force_import
            if ha is None and not opts.urn:
                raise TypeError("Missing required property 'ha'")
            __props__.__dict__["ha"] = ha
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_num"] = replica_num
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["sharding_num"] = sharding_num
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["time_zone"] = time_zone
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["db_user_name"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["maintenance_window"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_ips"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["switch_strategy"] = None
            __props__.__dict__["type"] = None
        super(OpengaussInstance, __self__).__init__(
            'huaweicloud:GaussDBforOpenGauss/opengaussInstance:OpengaussInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            coordinator_num: Optional[pulumi.Input[int]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceDatastoreArgs']]] = None,
            db_user_name: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            force_import: Optional[pulumi.Input[bool]] = None,
            ha: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceHaArgs']]] = None,
            maintenance_window: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpengaussInstanceNodeArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replica_num: Optional[pulumi.Input[int]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            sharding_num: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            switch_strategy: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            volume: Optional[pulumi.Input[pulumi.InputType['OpengaussInstanceVolumeArgs']]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'OpengaussInstance':
        """
        Get an existing OpengaussInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Defaults to **false**.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone information, can be three same or
               different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy.
               The object structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of opengauss instance.
               The valid values are as follows:
               + **prePaid**: the yearly/monthly billing mode.
               + **postPaid**: the pay-per-use billing mode.
        :param pulumi.Input[str] configuration_id: Specifies the parameter template ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] coordinator_num: Specifies the coordinator number. Values: 1~9. The default value is 3.
               The value must not be greater than twice value of `sharding_num`.
               This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceDatastoreArgs']] datastore: Specifies the datastore information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: Indicates the connection endpoints list of the DB instance. Example: [127.0.0.1:8000].
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please reference the API docs for valid
               options. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: Specifies whether to import the instance with the given configuration instead of
               creation. If specified, try to import the instance instead of creation if the instance already existed.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceHaArgs']] ha: Specifies the HA information.
               The object structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] maintenance_window: Indicates the maintenance window.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name.
               The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OpengaussInstanceNodeArgs']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be `8` to `32` characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of opengauss instance.
               If `period_unit` is set to **month**, the value ranges from 1 to 9.
               If `period_unit` is set to **year**, the value ranges from 1 to 5.
               This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of opengauss instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] port: Specifies the port information. Defaults to `8,000`.
               The valid values are as follows:
               + `2,378` to `2,380`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address of the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address of the DB instance.
        :param pulumi.Input[str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] replica_num: The replica number. The valid values are **2** and **3**, defaults to **3**.
               Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
               This parameter is valid only when the HA mode is set to **centralization_standard**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID to which the instance belongs.
               If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
               includes the `100` ports starting with the database port.
               (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        :param pulumi.Input[int] sharding_num: Specifies the sharding number. The valid value is range form `1` to `9`.
               The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of VPC subnet to which the instance belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] switch_strategy: Indicates the switch strategy.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to **UTC+08:00**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies the volume type. Only **ULTRAHIGH** is supported now.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['OpengaussInstanceVolumeArgs']] volume: Specifies the volume storage information.
               The object structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the subnet belongs.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpengaussInstanceState.__new__(_OpengaussInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["coordinator_num"] = coordinator_num
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["force_import"] = force_import
        __props__.__dict__["ha"] = ha
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_num"] = replica_num
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["sharding_num"] = sharding_num
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["switch_strategy"] = switch_strategy
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return OpengaussInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Defaults to **false**.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone information, can be three same or
        different az like **cn-north-4a,cn-north-4a,cn-north-4a**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.OpengaussInstanceBackupStrategy']:
        """
        Specifies the advanced backup policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of opengauss instance.
        The valid values are as follows:
        + **prePaid**: the yearly/monthly billing mode.
        + **postPaid**: the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the parameter template ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="coordinatorNum")
    def coordinator_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the coordinator number. Values: 1~9. The default value is 3.
        The value must not be greater than twice value of `sharding_num`.
        This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "coordinator_num")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.OpengaussInstanceDatastore']:
        """
        Specifies the datastore information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[str]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the connection endpoints list of the DB instance. Example: [127.0.0.1:8000].
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the enterprise project ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the instance specifications. Please reference the API docs for valid
        options. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to import the instance with the given configuration instead of
        creation. If specified, try to import the instance instead of creation if the instance already existed.
        """
        return pulumi.get(self, "force_import")

    @property
    @pulumi.getter
    def ha(self) -> pulumi.Output['outputs.OpengaussInstanceHa']:
        """
        Specifies the HA information.
        The object structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ha")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[str]:
        """
        Indicates the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name.
        The value must be `4` to `64` characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.OpengaussInstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the database password. The value must be `8` to `32` characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as **~!@#%^*-_=+?**. You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of opengauss instance.
        If `period_unit` is set to **month**, the value ranges from 1 to 9.
        If `period_unit` is set to **year**, the value ranges from 1 to 5.
        This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of opengauss instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        Specifies the port information. Defaults to `8,000`.
        The valid values are as follows:
        + `2,378` to `2,380`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the public IP address of the DB instance.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaNum")
    def replica_num(self) -> pulumi.Output[Optional[int]]:
        """
        The replica number. The valid values are **2** and **3**, defaults to **3**.
        Double replicas are only available for specific users and supports only instance versions are v1.3.0 or later.
        This parameter is valid only when the HA mode is set to **centralization_standard**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "replica_num")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the security group ID to which the instance belongs.
        If the `port` parameter is specified, please ensure that the TCP ports in the inbound rule of security group
        includes the `100` ports starting with the database port.
        (For example, if the database port is `8,000`, the TCP port must include the range from `8,000` to `8,100`.)
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="shardingNum")
    def sharding_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the sharding number. The valid value is range form `1` to `9`.
        The default value is 3. This parameter is valid only when the HA mode is set to **enterprise**.
        """
        return pulumi.get(self, "sharding_num")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of VPC subnet to which the instance belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> pulumi.Output[str]:
        """
        Indicates the switch strategy.
        """
        return pulumi.get(self, "switch_strategy")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time zone. Defaults to **UTC+08:00**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the volume type. Only **ULTRAHIGH** is supported now.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.OpengaussInstanceVolume']:
        """
        Specifies the volume storage information.
        The object structure is documented below.
        """
        return pulumi.get(self, "volume")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID to which the subnet belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

