# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MongoInstanceArgs', 'MongoInstance']

@pulumi.input_type
class MongoInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 flavor: pulumi.Input[str],
                 password: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 volume_size: pulumi.Input[int],
                 vpc_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input['MongoInstanceDatastoreArgs']] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[int]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MongoInstance resource.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the database password. The value must be **8** to **32** characters in
               length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
               advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create
               a new resource.
        :param pulumi.Input[int] volume_size: Specifies the storage space in GB. The value must be a multiple of **10**. For a
               GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
               instance performance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Changing this will do nothing.
        :param pulumi.Input['MongoInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are **prePaid**
               and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the Parameter Template ID.
        :param pulumi.Input['MongoInstanceDatastoreArgs'] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id, Only valid for users who
               have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] node_num: Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
               value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               will do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will do nothing.
        :param pulumi.Input[str] region: The region in which to create the mongo instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new mongo instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet doesn't
               enable network ACL.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
               parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if dedicated_resource_id is not None:
            pulumi.set(__self__, "dedicated_resource_id", dedicated_resource_id)
        if dedicated_resource_name is not None:
            pulumi.set(__self__, "dedicated_resource_name", dedicated_resource_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the database password. The value must be **8** to **32** characters in
        length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
        advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> pulumi.Input[int]:
        """
        Specifies the storage space in GB. The value must be a multiple of **10**. For a
        GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
        instance performance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid values are **prePaid**
        and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Parameter Template ID.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['MongoInstanceDatastoreArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['MongoInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @dedicated_resource_id.setter
    def dedicated_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_id", value)

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource name. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @dedicated_resource_name.setter
    def dedicated_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id, Only valid for users who
        have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The
        value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_num", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
        value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        will do nothing.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the mongo instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new mongo instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Required if the selected subnet doesn't
        enable network ACL.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MongoInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input['MongoInstanceDatastoreArgs']] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['MongoInstanceNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MongoInstance resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Changing this will do nothing.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input['MongoInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are **prePaid**
               and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the Parameter Template ID.
        :param pulumi.Input['MongoInstanceDatastoreArgs'] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id, Only valid for users who
               have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] mode: Indicates the instance type.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] node_num: Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MongoInstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be **8** to **32** characters in
               length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
               advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
               value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               will do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will do nothing.
        :param pulumi.Input[int] port: Indicates the database port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the IP address list of the db.
        :param pulumi.Input[str] region: The region in which to create the mongo instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new mongo instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet doesn't
               enable network ACL.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create
               a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the instance.
        :param pulumi.Input[int] volume_size: Specifies the storage space in GB. The value must be a multiple of **10**. For a
               GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
               instance performance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if dedicated_resource_id is not None:
            pulumi.set(__self__, "dedicated_resource_id", dedicated_resource_id)
        if dedicated_resource_name is not None:
            pulumi.set(__self__, "dedicated_resource_name", dedicated_resource_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['MongoInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid values are **prePaid**
        and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Parameter Template ID.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['MongoInstanceDatastoreArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['MongoInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @dedicated_resource_id.setter
    def dedicated_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_id", value)

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource name. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @dedicated_resource_name.setter
    def dedicated_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id, Only valid for users who
        have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the instance type.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The
        value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_num", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoInstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoInstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database password. The value must be **8** to **32** characters in
        length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
        advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
        value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        will do nothing.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the IP address list of the db.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the mongo instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new mongo instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Required if the selected subnet doesn't
        enable network ACL.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the storage space in GB. The value must be a multiple of **10**. For a
        GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
        instance performance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class MongoInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['MongoInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['MongoInstanceDatastoreArgs']]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        GaussDB for mongo instance management within HuaweiCoud.

        ## Example Usage
        ### create a gaussdb for mongo instance with tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_d_bfor_no_sql.MongoInstance("instance1",
            password=var["password"],
            flavor="geminidb.mongodb.repset.xlarge.4",
            volume_size=100,
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            availability_zone=var["availability_zone"],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### create a gaussdb mongo instance with backup strategy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_d_bfor_no_sql.MongoInstance("instance1",
            password=var["password"],
            flavor="geminidb.mongodb.repset.xlarge.4",
            volume_size=100,
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            availability_zone=var["availability_zone"],
            backup_strategy=huaweicloud.gauss_d_bfor_no_sql.MongoInstanceBackupStrategyArgs(
                start_time="03:00-04:00",
                keep_days=14,
            ))
        ```

        ## Import

        GaussDB mongo instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDBforNoSQL/mongoInstance:MongoInstance instance_1 2e045d8b-b226-4aa2-91b9-7e76357655c06
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Changing this will do nothing.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[pulumi.InputType['MongoInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are **prePaid**
               and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the Parameter Template ID.
        :param pulumi.Input[pulumi.InputType['MongoInstanceDatastoreArgs']] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id, Only valid for users who
               have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] node_num: Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the database password. The value must be **8** to **32** characters in
               length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
               advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
               value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               will do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will do nothing.
        :param pulumi.Input[str] region: The region in which to create the mongo instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new mongo instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet doesn't
               enable network ACL.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create
               a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the instance.
        :param pulumi.Input[int] volume_size: Specifies the storage space in GB. The value must be a multiple of **10**. For a
               GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
               instance performance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        GaussDB for mongo instance management within HuaweiCoud.

        ## Example Usage
        ### create a gaussdb for mongo instance with tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_d_bfor_no_sql.MongoInstance("instance1",
            password=var["password"],
            flavor="geminidb.mongodb.repset.xlarge.4",
            volume_size=100,
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            availability_zone=var["availability_zone"],
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### create a gaussdb mongo instance with backup strategy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_d_bfor_no_sql.MongoInstance("instance1",
            password=var["password"],
            flavor="geminidb.mongodb.repset.xlarge.4",
            volume_size=100,
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            availability_zone=var["availability_zone"],
            backup_strategy=huaweicloud.gauss_d_bfor_no_sql.MongoInstanceBackupStrategyArgs(
                start_time="03:00-04:00",
                keep_days=14,
            ))
        ```

        ## Import

        GaussDB mongo instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDBforNoSQL/mongoInstance:MongoInstance instance_1 2e045d8b-b226-4aa2-91b9-7e76357655c06
        ```

        :param str resource_name: The name of the resource.
        :param MongoInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['MongoInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['MongoInstanceDatastoreArgs']]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_num: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoInstanceArgs.__new__(MongoInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["configuration_id"] = configuration_id
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["dedicated_resource_id"] = dedicated_resource_id
            __props__.__dict__["dedicated_resource_name"] = dedicated_resource_name
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["force_import"] = force_import
            __props__.__dict__["name"] = name
            __props__.__dict__["node_num"] = node_num
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl"] = ssl
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if volume_size is None and not opts.urn:
                raise TypeError("Missing required property 'volume_size'")
            __props__.__dict__["volume_size"] = volume_size
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["db_user_name"] = None
            __props__.__dict__["mode"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["status"] = None
        super(MongoInstance, __self__).__init__(
            'huaweicloud:GaussDBforNoSQL/mongoInstance:MongoInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['MongoInstanceBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['MongoInstanceDatastoreArgs']]] = None,
            db_user_name: Optional[pulumi.Input[str]] = None,
            dedicated_resource_id: Optional[pulumi.Input[str]] = None,
            dedicated_resource_name: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            force_import: Optional[pulumi.Input[bool]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_num: Optional[pulumi.Input[int]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MongoInstanceNodeArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            ssl: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            volume_size: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'MongoInstance':
        """
        Get an existing MongoInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are **true** and **false**. Changing this will do nothing.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[pulumi.InputType['MongoInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are **prePaid**
               and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the Parameter Template ID.
        :param pulumi.Input[pulumi.InputType['MongoInstanceDatastoreArgs']] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id, Only valid for users who
               have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] mode: Indicates the instance type.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] node_num: Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MongoInstanceNodeArgs']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be **8** to **32** characters in
               length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
               advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
               value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               will do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this will do nothing.
        :param pulumi.Input[int] port: Indicates the database port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the IP address list of the db.
        :param pulumi.Input[str] region: The region in which to create the mongo instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new mongo instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet doesn't
               enable network ACL.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create
               a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the instance.
        :param pulumi.Input[int] volume_size: Specifies the storage space in GB. The value must be a multiple of **10**. For a
               GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
               instance performance specifications. For details,
               see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoInstanceState.__new__(_MongoInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["dedicated_resource_id"] = dedicated_resource_id
        __props__.__dict__["dedicated_resource_name"] = dedicated_resource_name
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["force_import"] = force_import
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["node_num"] = node_num
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volume_size"] = volume_size
        __props__.__dict__["vpc_id"] = vpc_id
        return MongoInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are **true** and **false**. Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.MongoInstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging mode of the instance. Valid values are **prePaid**
        and **postPaid**, defaults to **postPaid**. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[str]:
        """
        Specifies the Parameter Template ID.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.MongoInstanceDatastore']:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[str]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> pulumi.Output[str]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> pulumi.Output[str]:
        """
        Specifies the dedicated resource name. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the enterprise project id, Only valid for users who
        have enabled the enterprise multi-project service. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the instance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> pulumi.Output[Optional[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        Indicates the instance type.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The
        value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of nodes, only **3** is supported now. Defaults to **3**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_num")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.MongoInstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the database password. The value must be **8** to **32** characters in
        length, including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are
        advised to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to **month** , the value ranges from **1** to **9**. If `period_unit` is set to **year**, the
        value ranges from **1** to **3**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        will do nothing.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the IP address list of the db.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the mongo instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new mongo instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the security group ID. Required if the selected subnet doesn't
        enable network ACL.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def ssl(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to **false**. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> pulumi.Output[int]:
        """
        Specifies the storage space in GB. The value must be a multiple of **10**. For a
        GaussDB mongo DB instance, the minimum storage space is **100** GB, and the maximum storage space is related to the
        instance performance specifications. For details,
        see [DB Instance Specifications](https://support.huaweicloud.com/intl/en-us/mongoug-nosql/nosql_05_0029.html)
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

