# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlInstanceArgs', 'MysqlInstance']

@pulumi.input_type
class MysqlInstanceArgs:
    def __init__(__self__, *,
                 flavor: pulumi.Input[str],
                 password: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 audit_log_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone_mode: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input['MysqlInstanceDatastoreArgs']] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 master_availability_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 proxy_flavor: Optional[pulumi.Input[str]] = None,
                 proxy_node_num: Optional[pulumi.Input[int]] = None,
                 read_replicas: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 table_name_case_sensitivity: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a MysqlInstance resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please use
               `gaussdb_mysql_flavors` data source to fetch the available flavors.
        :param pulumi.Input[str] password: Specifies the database password. The value must be 8 to 32 characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
               enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] audit_log_enabled: Specifies whether audit log is enabled. The default value is `false`.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are "true" and "false". Changing this will do nothing.
        :param pulumi.Input[str] availability_zone_mode: Specifies the availability zone mode: "single" or "multi".
               Defaults to "single". Changing this parameter will create a new resource.
        :param pulumi.Input['MysqlInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the configuration ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] configuration_name: Specifies the configuration name. Changing this parameter will create
               a new resource.
        :param pulumi.Input['MysqlInstanceDatastoreArgs'] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id. Required if EPS enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] master_availability_zone: Specifies the availability zone where the master node
               resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
               ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
               do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this will do nothing.
        :param pulumi.Input[str] proxy_flavor: Specifies the flavor of the proxy.
        :param pulumi.Input[int] proxy_node_num: Specifies the node count of the proxy.
        :param pulumi.Input[int] read_replicas: Specifies the count of read replicas. Defaults to 1.
        :param pulumi.Input[str] region: The region in which to create the GaussDB mysql instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet
               doesn't enable network ACL. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] table_name_case_sensitivity: Whether the kernel table name is case sensitive. The value can
               be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
               creation.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
               will create a new resource.
        :param pulumi.Input[int] volume_size: Specifies the volume size of the instance. The new storage space must be greater than
               the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if audit_log_enabled is not None:
            pulumi.set(__self__, "audit_log_enabled", audit_log_enabled)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone_mode is not None:
            pulumi.set(__self__, "availability_zone_mode", availability_zone_mode)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if dedicated_resource_id is not None:
            pulumi.set(__self__, "dedicated_resource_id", dedicated_resource_id)
        if dedicated_resource_name is not None:
            pulumi.set(__self__, "dedicated_resource_name", dedicated_resource_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if master_availability_zone is not None:
            pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if proxy_flavor is not None:
            pulumi.set(__self__, "proxy_flavor", proxy_flavor)
        if proxy_node_num is not None:
            pulumi.set(__self__, "proxy_node_num", proxy_node_num)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if table_name_case_sensitivity is not None:
            pulumi.set(__self__, "table_name_case_sensitivity", table_name_case_sensitivity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the instance specifications. Please use
        `gaussdb_mysql_flavors` data source to fetch the available flavors.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the database password. The value must be 8 to 32 characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
        enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether audit log is enabled. The default value is `false`.
        """
        return pulumi.get(self, "audit_log_enabled")

    @audit_log_enabled.setter
    def audit_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_log_enabled", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are "true" and "false". Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone mode: "single" or "multi".
        Defaults to "single". Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone_mode")

    @availability_zone_mode.setter
    def availability_zone_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_mode", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the configuration ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the configuration name. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['MysqlInstanceDatastoreArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['MysqlInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @dedicated_resource_id.setter
    def dedicated_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_id", value)

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource name. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @dedicated_resource_name.setter
    def dedicated_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id. Required if EPS enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone where the master node
        resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "master_availability_zone")

    @master_availability_zone.setter
    def master_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_availability_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
        ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
        do nothing.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="proxyFlavor")
    def proxy_flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor of the proxy.
        """
        return pulumi.get(self, "proxy_flavor")

    @proxy_flavor.setter
    def proxy_flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_flavor", value)

    @property
    @pulumi.getter(name="proxyNodeNum")
    def proxy_node_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the node count of the proxy.
        """
        return pulumi.get(self, "proxy_node_num")

    @proxy_node_num.setter
    def proxy_node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "proxy_node_num", value)

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the count of read replicas. Defaults to 1.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_replicas", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the GaussDB mysql instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Required if the selected subnet
        doesn't enable network ACL. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="tableNameCaseSensitivity")
    def table_name_case_sensitivity(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the kernel table name is case sensitive. The value can
        be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
        creation.
        """
        return pulumi.get(self, "table_name_case_sensitivity")

    @table_name_case_sensitivity.setter
    def table_name_case_sensitivity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "table_name_case_sensitivity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the volume size of the instance. The new storage space must be greater than
        the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)


@pulumi.input_type
class _MysqlInstanceState:
    def __init__(__self__, *,
                 audit_log_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone_mode: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input['MysqlInstanceDatastoreArgs']] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 master_availability_zone: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlInstanceNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_write_ip: Optional[pulumi.Input[str]] = None,
                 proxy_address: Optional[pulumi.Input[str]] = None,
                 proxy_flavor: Optional[pulumi.Input[str]] = None,
                 proxy_node_num: Optional[pulumi.Input[int]] = None,
                 proxy_port: Optional[pulumi.Input[int]] = None,
                 read_replicas: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 table_name_case_sensitivity: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MysqlInstance resources.
        :param pulumi.Input[bool] audit_log_enabled: Specifies whether audit log is enabled. The default value is `false`.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are "true" and "false". Changing this will do nothing.
        :param pulumi.Input[str] availability_zone_mode: Specifies the availability zone mode: "single" or "multi".
               Defaults to "single". Changing this parameter will create a new resource.
        :param pulumi.Input['MysqlInstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the configuration ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] configuration_name: Specifies the configuration name. Changing this parameter will create
               a new resource.
        :param pulumi.Input['MysqlInstanceDatastoreArgs'] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id. Required if EPS enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please use
               `gaussdb_mysql_flavors` data source to fetch the available flavors.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] master_availability_zone: Specifies the availability zone where the master node
               resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] mode: Indicates the instance mode.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input['MysqlInstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be 8 to 32 characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
               enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
               ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
               do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this will do nothing.
        :param pulumi.Input[int] port: Indicates the database port.
        :param pulumi.Input[str] private_write_ip: Indicates the private IP address of the DB instance.
        :param pulumi.Input[str] proxy_address: Indicates the address of the proxy.
        :param pulumi.Input[str] proxy_flavor: Specifies the flavor of the proxy.
        :param pulumi.Input[int] proxy_node_num: Specifies the node count of the proxy.
        :param pulumi.Input[int] proxy_port: Indicates the port of the proxy.
        :param pulumi.Input[int] read_replicas: Specifies the count of read replicas. Defaults to 1.
        :param pulumi.Input[str] region: The region in which to create the GaussDB mysql instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet
               doesn't enable network ACL. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[bool] table_name_case_sensitivity: Whether the kernel table name is case sensitive. The value can
               be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
               creation.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
               will create a new resource.
        :param pulumi.Input[int] volume_size: Specifies the volume size of the instance. The new storage space must be greater than
               the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        if audit_log_enabled is not None:
            pulumi.set(__self__, "audit_log_enabled", audit_log_enabled)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone_mode is not None:
            pulumi.set(__self__, "availability_zone_mode", availability_zone_mode)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if dedicated_resource_id is not None:
            pulumi.set(__self__, "dedicated_resource_id", dedicated_resource_id)
        if dedicated_resource_name is not None:
            pulumi.set(__self__, "dedicated_resource_name", dedicated_resource_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if force_import is not None:
            pulumi.set(__self__, "force_import", force_import)
        if master_availability_zone is not None:
            pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_write_ip is not None:
            pulumi.set(__self__, "private_write_ip", private_write_ip)
        if proxy_address is not None:
            pulumi.set(__self__, "proxy_address", proxy_address)
        if proxy_flavor is not None:
            pulumi.set(__self__, "proxy_flavor", proxy_flavor)
        if proxy_node_num is not None:
            pulumi.set(__self__, "proxy_node_num", proxy_node_num)
        if proxy_port is not None:
            pulumi.set(__self__, "proxy_port", proxy_port)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if table_name_case_sensitivity is not None:
            pulumi.set(__self__, "table_name_case_sensitivity", table_name_case_sensitivity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether audit log is enabled. The default value is `false`.
        """
        return pulumi.get(self, "audit_log_enabled")

    @audit_log_enabled.setter
    def audit_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "audit_log_enabled", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are "true" and "false". Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone mode: "single" or "multi".
        Defaults to "single". Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone_mode")

    @availability_zone_mode.setter
    def availability_zone_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone_mode", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['MysqlInstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the configuration ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the configuration name. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['MysqlInstanceDatastoreArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['MysqlInstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @dedicated_resource_id.setter
    def dedicated_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_id", value)

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dedicated resource name. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @dedicated_resource_name.setter
    def dedicated_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_resource_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id. Required if EPS enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance specifications. Please use
        `gaussdb_mysql_flavors` data source to fetch the available flavors.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> Optional[pulumi.Input[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @force_import.setter
    def force_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_import", value)

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone where the master node
        resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "master_availability_zone")

    @master_availability_zone.setter
    def master_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_availability_zone", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the instance mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlInstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlInstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database password. The value must be 8 to 32 characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
        enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
        ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
        do nothing.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateWriteIp")
    def private_write_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_write_ip")

    @private_write_ip.setter
    def private_write_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_write_ip", value)

    @property
    @pulumi.getter(name="proxyAddress")
    def proxy_address(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the address of the proxy.
        """
        return pulumi.get(self, "proxy_address")

    @proxy_address.setter
    def proxy_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_address", value)

    @property
    @pulumi.getter(name="proxyFlavor")
    def proxy_flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor of the proxy.
        """
        return pulumi.get(self, "proxy_flavor")

    @proxy_flavor.setter
    def proxy_flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proxy_flavor", value)

    @property
    @pulumi.getter(name="proxyNodeNum")
    def proxy_node_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the node count of the proxy.
        """
        return pulumi.get(self, "proxy_node_num")

    @proxy_node_num.setter
    def proxy_node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "proxy_node_num", value)

    @property
    @pulumi.getter(name="proxyPort")
    def proxy_port(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the port of the proxy.
        """
        return pulumi.get(self, "proxy_port")

    @proxy_port.setter
    def proxy_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "proxy_port", value)

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the count of read replicas. Defaults to 1.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_replicas", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the GaussDB mysql instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Required if the selected subnet
        doesn't enable network ACL. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tableNameCaseSensitivity")
    def table_name_case_sensitivity(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the kernel table name is case sensitive. The value can
        be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
        creation.
        """
        return pulumi.get(self, "table_name_case_sensitivity")

    @table_name_case_sensitivity.setter
    def table_name_case_sensitivity(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "table_name_case_sensitivity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the volume size of the instance. The new storage space must be greater than
        the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "volume_size", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class MysqlInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone_mode: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceDatastoreArgs']]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 master_availability_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 proxy_flavor: Optional[pulumi.Input[str]] = None,
                 proxy_node_num: Optional[pulumi.Input[int]] = None,
                 read_replicas: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 table_name_case_sensitivity: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        GaussDB mysql instance management within HuaweiCoud.

        ## Example Usage
        ### create a basic instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_db.MysqlInstance("instance1",
            password=var["password"],
            flavor="gaussdb.mysql.4xlarge.x86.4",
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"])
        ```
        ### create a gaussdb mysql instance with backup strategy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_db.MysqlInstance("instance1",
            password=var["password"],
            flavor="gaussdb.mysql.4xlarge.x86.4",
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            backup_strategy=huaweicloud.gauss_db.MysqlInstanceBackupStrategyArgs(
                start_time="03:00-04:00",
                keep_days=7,
            ))
        ```

        ## Import

        GaussDB instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDB/mysqlInstance:MysqlInstance instance_1 ee678f40-ce8e-4d0c-8221-38dead426f06
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] audit_log_enabled: Specifies whether audit log is enabled. The default value is `false`.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are "true" and "false". Changing this will do nothing.
        :param pulumi.Input[str] availability_zone_mode: Specifies the availability zone mode: "single" or "multi".
               Defaults to "single". Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['MysqlInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the configuration ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] configuration_name: Specifies the configuration name. Changing this parameter will create
               a new resource.
        :param pulumi.Input[pulumi.InputType['MysqlInstanceDatastoreArgs']] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id. Required if EPS enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please use
               `gaussdb_mysql_flavors` data source to fetch the available flavors.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] master_availability_zone: Specifies the availability zone where the master node
               resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param pulumi.Input[str] password: Specifies the database password. The value must be 8 to 32 characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
               enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
               ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
               do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this will do nothing.
        :param pulumi.Input[str] proxy_flavor: Specifies the flavor of the proxy.
        :param pulumi.Input[int] proxy_node_num: Specifies the node count of the proxy.
        :param pulumi.Input[int] read_replicas: Specifies the count of read replicas. Defaults to 1.
        :param pulumi.Input[str] region: The region in which to create the GaussDB mysql instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet
               doesn't enable network ACL. Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[bool] table_name_case_sensitivity: Whether the kernel table name is case sensitive. The value can
               be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
               creation.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
               will create a new resource.
        :param pulumi.Input[int] volume_size: Specifies the volume size of the instance. The new storage space must be greater than
               the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        GaussDB mysql instance management within HuaweiCoud.

        ## Example Usage
        ### create a basic instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_db.MysqlInstance("instance1",
            password=var["password"],
            flavor="gaussdb.mysql.4xlarge.x86.4",
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"])
        ```
        ### create a gaussdb mysql instance with backup strategy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance1 = huaweicloud.gauss_db.MysqlInstance("instance1",
            password=var["password"],
            flavor="gaussdb.mysql.4xlarge.x86.4",
            vpc_id=var["vpc_id"],
            subnet_id=var["subnet_id"],
            security_group_id=var["secgroup_id"],
            backup_strategy=huaweicloud.gauss_db.MysqlInstanceBackupStrategyArgs(
                start_time="03:00-04:00",
                keep_days=7,
            ))
        ```

        ## Import

        GaussDB instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:GaussDB/mysqlInstance:MysqlInstance instance_1 ee678f40-ce8e-4d0c-8221-38dead426f06
        ```

        :param str resource_name: The name of the resource.
        :param MysqlInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_enabled: Optional[pulumi.Input[bool]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone_mode: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceDatastoreArgs']]] = None,
                 dedicated_resource_id: Optional[pulumi.Input[str]] = None,
                 dedicated_resource_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 force_import: Optional[pulumi.Input[bool]] = None,
                 master_availability_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 proxy_flavor: Optional[pulumi.Input[str]] = None,
                 proxy_node_num: Optional[pulumi.Input[int]] = None,
                 read_replicas: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 table_name_case_sensitivity: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 volume_size: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlInstanceArgs.__new__(MysqlInstanceArgs)

            __props__.__dict__["audit_log_enabled"] = audit_log_enabled
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zone_mode"] = availability_zone_mode
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["configuration_id"] = configuration_id
            __props__.__dict__["configuration_name"] = configuration_name
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["dedicated_resource_id"] = dedicated_resource_id
            __props__.__dict__["dedicated_resource_name"] = dedicated_resource_name
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["force_import"] = force_import
            __props__.__dict__["master_availability_zone"] = master_availability_zone
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["proxy_flavor"] = proxy_flavor
            __props__.__dict__["proxy_node_num"] = proxy_node_num
            __props__.__dict__["read_replicas"] = read_replicas
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["table_name_case_sensitivity"] = table_name_case_sensitivity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["volume_size"] = volume_size
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["db_user_name"] = None
            __props__.__dict__["mode"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["private_write_ip"] = None
            __props__.__dict__["proxy_address"] = None
            __props__.__dict__["proxy_port"] = None
            __props__.__dict__["status"] = None
        super(MysqlInstance, __self__).__init__(
            'huaweicloud:GaussDB/mysqlInstance:MysqlInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_log_enabled: Optional[pulumi.Input[bool]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone_mode: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            configuration_name: Optional[pulumi.Input[str]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['MysqlInstanceDatastoreArgs']]] = None,
            db_user_name: Optional[pulumi.Input[str]] = None,
            dedicated_resource_id: Optional[pulumi.Input[str]] = None,
            dedicated_resource_name: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            force_import: Optional[pulumi.Input[bool]] = None,
            master_availability_zone: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlInstanceNodeArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_write_ip: Optional[pulumi.Input[str]] = None,
            proxy_address: Optional[pulumi.Input[str]] = None,
            proxy_flavor: Optional[pulumi.Input[str]] = None,
            proxy_node_num: Optional[pulumi.Input[int]] = None,
            proxy_port: Optional[pulumi.Input[int]] = None,
            read_replicas: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            table_name_case_sensitivity: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            volume_size: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'MysqlInstance':
        """
        Get an existing MysqlInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] audit_log_enabled: Specifies whether audit log is enabled. The default value is `false`.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are "true" and "false". Changing this will do nothing.
        :param pulumi.Input[str] availability_zone_mode: Specifies the availability zone mode: "single" or "multi".
               Defaults to "single". Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['MysqlInstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        :param pulumi.Input[str] configuration_id: Specifies the configuration ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[str] configuration_name: Specifies the configuration name. Changing this parameter will create
               a new resource.
        :param pulumi.Input[pulumi.InputType['MysqlInstanceDatastoreArgs']] datastore: Specifies the database information. Structure is documented below. Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] db_user_name: Indicates the default username.
        :param pulumi.Input[str] dedicated_resource_id: Specifies the dedicated resource ID. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] dedicated_resource_name: Specifies the dedicated resource name. Changing this parameter
               will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id. Required if EPS enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the instance specifications. Please use
               `gaussdb_mysql_flavors` data source to fetch the available flavors.
        :param pulumi.Input[bool] force_import: If specified, try to import the instance instead of creating if the name already
               existed.
        :param pulumi.Input[str] master_availability_zone: Specifies the availability zone where the master node
               resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] mode: Indicates the instance mode.
        :param pulumi.Input[str] name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MysqlInstanceNodeArgs']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the database password. The value must be 8 to 32 characters in length,
               including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
               enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
               ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
               do nothing.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this will do nothing.
        :param pulumi.Input[int] port: Indicates the database port.
        :param pulumi.Input[str] private_write_ip: Indicates the private IP address of the DB instance.
        :param pulumi.Input[str] proxy_address: Indicates the address of the proxy.
        :param pulumi.Input[str] proxy_flavor: Specifies the flavor of the proxy.
        :param pulumi.Input[int] proxy_node_num: Specifies the node count of the proxy.
        :param pulumi.Input[int] proxy_port: Indicates the port of the proxy.
        :param pulumi.Input[int] read_replicas: Specifies the count of read replicas. Defaults to 1.
        :param pulumi.Input[str] region: The region in which to create the GaussDB mysql instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Required if the selected subnet
               doesn't enable network ACL. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[bool] table_name_case_sensitivity: Whether the kernel table name is case sensitive. The value can
               be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
               creation.
        :param pulumi.Input[str] time_zone: Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
               will create a new resource.
        :param pulumi.Input[int] volume_size: Specifies the volume size of the instance. The new storage space must be greater than
               the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlInstanceState.__new__(_MysqlInstanceState)

        __props__.__dict__["audit_log_enabled"] = audit_log_enabled
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone_mode"] = availability_zone_mode
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["configuration_name"] = configuration_name
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["dedicated_resource_id"] = dedicated_resource_id
        __props__.__dict__["dedicated_resource_name"] = dedicated_resource_name
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["force_import"] = force_import
        __props__.__dict__["master_availability_zone"] = master_availability_zone
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["private_write_ip"] = private_write_ip
        __props__.__dict__["proxy_address"] = proxy_address
        __props__.__dict__["proxy_flavor"] = proxy_flavor
        __props__.__dict__["proxy_node_num"] = proxy_node_num
        __props__.__dict__["proxy_port"] = proxy_port
        __props__.__dict__["read_replicas"] = read_replicas
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["table_name_case_sensitivity"] = table_name_case_sensitivity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["volume_size"] = volume_size
        __props__.__dict__["vpc_id"] = vpc_id
        return MysqlInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether audit log is enabled. The default value is `false`.
        """
        return pulumi.get(self, "audit_log_enabled")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are "true" and "false". Changing this will do nothing.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the availability zone mode: "single" or "multi".
        Defaults to "single". Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone_mode")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.MysqlInstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this will do nothing.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[str]:
        """
        Specifies the configuration ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Output[str]:
        """
        Specifies the configuration name. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "configuration_name")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.MysqlInstanceDatastore']:
        """
        Specifies the database information. Structure is documented below. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[str]:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="dedicatedResourceId")
    def dedicated_resource_id(self) -> pulumi.Output[str]:
        """
        Specifies the dedicated resource ID. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_id")

    @property
    @pulumi.getter(name="dedicatedResourceName")
    def dedicated_resource_name(self) -> pulumi.Output[str]:
        """
        Specifies the dedicated resource name. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "dedicated_resource_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the enterprise project id. Required if EPS enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the instance specifications. Please use
        `gaussdb_mysql_flavors` data source to fetch the available flavors.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="forceImport")
    def force_import(self) -> pulumi.Output[Optional[bool]]:
        """
        If specified, try to import the instance instead of creating if the name already
        existed.
        """
        return pulumi.get(self, "force_import")

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone where the master node
        resides. The parameter is required in multi availability zone mode. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "master_availability_zone")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        Indicates the instance mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.MysqlInstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the database password. The value must be 8 to 32 characters in length,
        including uppercase and lowercase letters, digits, and special characters, such as ~!@#%^*-_=+? You are advised to
        enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month* , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value
        ranges from 1 to 3. This parameter is mandatory if `charging_mode` is set to *prePaid*. Changing this will
        do nothing.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this will do nothing.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateWriteIp")
    def private_write_ip(self) -> pulumi.Output[str]:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_write_ip")

    @property
    @pulumi.getter(name="proxyAddress")
    def proxy_address(self) -> pulumi.Output[str]:
        """
        Indicates the address of the proxy.
        """
        return pulumi.get(self, "proxy_address")

    @property
    @pulumi.getter(name="proxyFlavor")
    def proxy_flavor(self) -> pulumi.Output[str]:
        """
        Specifies the flavor of the proxy.
        """
        return pulumi.get(self, "proxy_flavor")

    @property
    @pulumi.getter(name="proxyNodeNum")
    def proxy_node_num(self) -> pulumi.Output[int]:
        """
        Specifies the node count of the proxy.
        """
        return pulumi.get(self, "proxy_node_num")

    @property
    @pulumi.getter(name="proxyPort")
    def proxy_port(self) -> pulumi.Output[int]:
        """
        Indicates the port of the proxy.
        """
        return pulumi.get(self, "proxy_port")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the count of read replicas. Defaults to 1.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the GaussDB mysql instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the security group ID. Required if the selected subnet
        doesn't enable network ACL. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="tableNameCaseSensitivity")
    def table_name_case_sensitivity(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the kernel table name is case sensitive. The value can
        be `true` (case sensitive) and `false` (case insensitive). Defaults to `false`. This parameter only works during
        creation.
        """
        return pulumi.get(self, "table_name_case_sensitivity")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the time zone. Defaults to "UTC+08:00". Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> pulumi.Output[int]:
        """
        Specifies the volume size of the instance. The new storage space must be greater than
        the current storage and must be a multiple of 10 GB. Only valid when in prePaid mode.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

