# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 volume_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[str] volume_id: The id of the snapshot's source disk. Changing the parameter creates a new
               snapshot.
        :param pulumi.Input[str] description: The description of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[bool] force: Specifies the flag for forcibly creating a snapshot. Default to false.
        :param pulumi.Input[str] name: The name of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] region: The region in which to create the evs snapshot resource. If omitted, the
               provider-level region will be used. Changing this creates a new EVS snapshot resource.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Input[str]:
        """
        The id of the snapshot's source disk. Changing the parameter creates a new
        snapshot.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the flag for forcibly creating a snapshot. Default to false.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the evs snapshot resource. If omitted, the
        provider-level region will be used. Changing this creates a new EVS snapshot resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[str] description: The description of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[bool] force: Specifies the flag for forcibly creating a snapshot. Default to false.
        :param pulumi.Input[str] name: The name of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] region: The region in which to create the evs snapshot resource. If omitted, the
               provider-level region will be used. Changing this creates a new EVS snapshot resource.
        :param pulumi.Input[int] size: The size of the snapshot in GB.
        :param pulumi.Input[str] status: The status of the snapshot.
        :param pulumi.Input[str] volume_id: The id of the snapshot's source disk. Changing the parameter creates a new
               snapshot.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the flag for forcibly creating a snapshot. Default to false.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the evs snapshot resource. If omitted, the
        provider-level region will be used. Changing this creates a new EVS snapshot resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the snapshot in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the snapshot's source disk. Changing the parameter creates a new
        snapshot.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)


class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an EVS snapshot resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myvolume = huaweicloud.evs.Volume("myvolume",
            description="my volume",
            volume_type="SATA",
            size=20,
            availability_zone="cn-north-4a",
            tags={
                "foo": "bar",
                "key": "value",
            })
        snapshot1 = huaweicloud.evs.Snapshot("snapshot1",
            description="Daily backup",
            volume_id=myvolume.id)
        ```

        ## Import

        EVS snapshot can be imported using the `snapshot id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Evs/snapshot:Snapshot huaweicloud_evs_snapshot.snapshot_1 3a11b255-3bb6-46f3-91e4-3338baa92dd6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[bool] force: Specifies the flag for forcibly creating a snapshot. Default to false.
        :param pulumi.Input[str] name: The name of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] region: The region in which to create the evs snapshot resource. If omitted, the
               provider-level region will be used. Changing this creates a new EVS snapshot resource.
        :param pulumi.Input[str] volume_id: The id of the snapshot's source disk. Changing the parameter creates a new
               snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an EVS snapshot resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myvolume = huaweicloud.evs.Volume("myvolume",
            description="my volume",
            volume_type="SATA",
            size=20,
            availability_zone="cn-north-4a",
            tags={
                "foo": "bar",
                "key": "value",
            })
        snapshot1 = huaweicloud.evs.Snapshot("snapshot1",
            description="Daily backup",
            volume_id=myvolume.id)
        ```

        ## Import

        EVS snapshot can be imported using the `snapshot id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Evs/snapshot:Snapshot huaweicloud_evs_snapshot.snapshot_1 3a11b255-3bb6-46f3-91e4-3338baa92dd6
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["force"] = force
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'volume_id'")
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
        super(Snapshot, __self__).__init__(
            'huaweicloud:Evs/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            force: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            volume_id: Optional[pulumi.Input[str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[bool] force: Specifies the flag for forcibly creating a snapshot. Default to false.
        :param pulumi.Input[str] name: The name of the snapshot. The value can contain a maximum of 255 bytes.
        :param pulumi.Input[str] region: The region in which to create the evs snapshot resource. If omitted, the
               provider-level region will be used. Changing this creates a new EVS snapshot resource.
        :param pulumi.Input[int] size: The size of the snapshot in GB.
        :param pulumi.Input[str] status: The status of the snapshot.
        :param pulumi.Input[str] volume_id: The id of the snapshot's source disk. Changing the parameter creates a new
               snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["description"] = description
        __props__.__dict__["force"] = force
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["volume_id"] = volume_id
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies the flag for forcibly creating a snapshot. Default to false.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the snapshot. The value can contain a maximum of 255 bytes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the evs snapshot resource. If omitted, the
        provider-level region will be used. Changing this creates a new EVS snapshot resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of the snapshot in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[str]:
        """
        The id of the snapshot's source disk. Changing the parameter creates a new
        snapshot.
        """
        return pulumi.get(self, "volume_id")

