# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_disable_on_destroy: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[str] description: Specifies the description of the enterprise project.
        :param pulumi.Input[bool] enable: Specifies whether to enable the enterprise project. Default to *true*.
        :param pulumi.Input[str] name: Specifies the name of the enterprise project.
               This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        :param pulumi.Input[bool] skip_disable_on_destroy: Specifies whether to skip disable the enterprise project on destroy.
               Default to *false*.
        :param pulumi.Input[str] type: Specifies the type of the enterprise project.
               The valid values are *poc* and *prod*, default to *prod*.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_disable_on_destroy is not None:
            pulumi.set(__self__, "skip_disable_on_destroy", skip_disable_on_destroy)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the enterprise project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the enterprise project. Default to *true*.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the enterprise project.
        This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipDisableOnDestroy")
    def skip_disable_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to skip disable the enterprise project on destroy.
        Default to *false*.
        """
        return pulumi.get(self, "skip_disable_on_destroy")

    @skip_disable_on_destroy.setter
    def skip_disable_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_disable_on_destroy", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the enterprise project.
        The valid values are *poc* and *prod*, default to *prod*.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_disable_on_destroy: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[str] created_at: Indicates the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        :param pulumi.Input[str] description: Specifies the description of the enterprise project.
        :param pulumi.Input[bool] enable: Specifies whether to enable the enterprise project. Default to *true*.
        :param pulumi.Input[str] name: Specifies the name of the enterprise project.
               This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        :param pulumi.Input[bool] skip_disable_on_destroy: Specifies whether to skip disable the enterprise project on destroy.
               Default to *false*.
        :param pulumi.Input[int] status: Indicates the status of an enterprise project.
               + 1 indicates Enabled.
               + 2 indicates Disabled.
        :param pulumi.Input[str] type: Specifies the type of the enterprise project.
               The valid values are *poc* and *prod*, default to *prod*.
        :param pulumi.Input[str] updated_at: Indicates the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if skip_disable_on_destroy is not None:
            pulumi.set(__self__, "skip_disable_on_destroy", skip_disable_on_destroy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the enterprise project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the enterprise project. Default to *true*.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the enterprise project.
        This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="skipDisableOnDestroy")
    def skip_disable_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to skip disable the enterprise project on destroy.
        Default to *false*.
        """
        return pulumi.get(self, "skip_disable_on_destroy")

    @skip_disable_on_destroy.setter
    def skip_disable_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_disable_on_destroy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the status of an enterprise project.
        + 1 indicates Enabled.
        + 2 indicates Disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the enterprise project.
        The valid values are *poc* and *prod*, default to *prod*.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_disable_on_destroy: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to manage an enterprise project within HuaweiCloud.

        > **NOTE:** Deleting enterprise projects is not support. If you destroy a resource of enterprise project,
          the project is only disabled and removed from the state, but it remains in the cloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.eps.Project("test", description="example project")
        ```

        ## Import

        Enterprise projects can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Eps/project:Project test 88f889c7-270e-4e77-8230-bf7db08d9b0e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the enterprise project.
        :param pulumi.Input[bool] enable: Specifies whether to enable the enterprise project. Default to *true*.
        :param pulumi.Input[str] name: Specifies the name of the enterprise project.
               This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        :param pulumi.Input[bool] skip_disable_on_destroy: Specifies whether to skip disable the enterprise project on destroy.
               Default to *false*.
        :param pulumi.Input[str] type: Specifies the type of the enterprise project.
               The valid values are *poc* and *prod*, default to *prod*.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to manage an enterprise project within HuaweiCloud.

        > **NOTE:** Deleting enterprise projects is not support. If you destroy a resource of enterprise project,
          the project is only disabled and removed from the state, but it remains in the cloud

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.eps.Project("test", description="example project")
        ```

        ## Import

        Enterprise projects can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Eps/project:Project test 88f889c7-270e-4e77-8230-bf7db08d9b0e
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 skip_disable_on_destroy: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enable"] = enable
            __props__.__dict__["name"] = name
            __props__.__dict__["skip_disable_on_destroy"] = skip_disable_on_destroy
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Project, __self__).__init__(
            'huaweicloud:Eps/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            skip_disable_on_destroy: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Indicates the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        :param pulumi.Input[str] description: Specifies the description of the enterprise project.
        :param pulumi.Input[bool] enable: Specifies whether to enable the enterprise project. Default to *true*.
        :param pulumi.Input[str] name: Specifies the name of the enterprise project.
               This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
               The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        :param pulumi.Input[bool] skip_disable_on_destroy: Specifies whether to skip disable the enterprise project on destroy.
               Default to *false*.
        :param pulumi.Input[int] status: Indicates the status of an enterprise project.
               + 1 indicates Enabled.
               + 2 indicates Disabled.
        :param pulumi.Input[str] type: Specifies the type of the enterprise project.
               The valid values are *poc* and *prod*, default to *prod*.
        :param pulumi.Input[str] updated_at: Indicates the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enable"] = enable
        __props__.__dict__["name"] = name
        __props__.__dict__["skip_disable_on_destroy"] = skip_disable_on_destroy
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Indicates the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the enterprise project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the enterprise project. Default to *true*.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the enterprise project.
        This parameter can contain 1 to 64 characters. Only letters, digits, underscores (_), and hyphens (-) are allowed.
        The name must be unique in the domain and cannot include any form of the word "default" ("deFaulT", for instance).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skipDisableOnDestroy")
    def skip_disable_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to skip disable the enterprise project on destroy.
        Default to *false*.
        """
        return pulumi.get(self, "skip_disable_on_destroy")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        Indicates the status of an enterprise project.
        + 1 indicates Enabled.
        + 2 indicates Disabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of the enterprise project.
        The valid values are *poc* and *prod*, default to *prod*.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Indicates the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        return pulumi.get(self, "updated_at")

