# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 protocol_port: pulumi.Input[int],
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Input[int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol_port", value)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_limit", value)

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pool_id", value)

    @property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if connection_limit is not None:
            pulumi.set(__self__, "connection_limit", connection_limit)
        if default_pool_id is not None:
            pulumi.set(__self__, "default_pool_id", default_pool_id)
        if default_tls_container_ref is not None:
            pulumi.set(__self__, "default_tls_container_ref", default_tls_container_ref)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http2_enable is not None:
            pulumi.set(__self__, "http2_enable", http2_enable)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_port is not None:
            pulumi.set(__self__, "protocol_port", protocol_port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sni_container_refs is not None:
            pulumi.set(__self__, "sni_container_refs", sni_container_refs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @connection_limit.setter
    def connection_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_limit", value)

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @default_pool_id.setter
    def default_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_pool_id", value)

    @property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @default_tls_container_ref.setter
    def default_tls_container_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_tls_container_ref", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @http2_enable.setter
    def http2_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http2_enable", value)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protocol_port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @sni_container_refs.setter
    def sni_container_refs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sni_container_refs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an ELB listener resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        listener1 = huaweicloud.elb.Listener("listener1",
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2",
            protocol="HTTP",
            protocol_port=8080,
            tags={
                "key": "value",
            })
        ```

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
         $ pulumi import huaweicloud:Elb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB listener resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        listener1 = huaweicloud.elb.Listener("listener1",
            loadbalancer_id="d9415786-5f1a-428b-b35f-2f1523e146d2",
            protocol="HTTP",
            protocol_port=8080,
            tags={
                "key": "value",
            })
        ```

        ## Import

        ELB listener can be imported using the listener ID, e.g.

        ```sh
         $ pulumi import huaweicloud:Elb/listener:Listener listener_1 5c20fdad-7288-11eb-b817-0255ac10158b
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 connection_limit: Optional[pulumi.Input[int]] = None,
                 default_pool_id: Optional[pulumi.Input[str]] = None,
                 default_tls_container_ref: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 http2_enable: Optional[pulumi.Input[bool]] = None,
                 loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 protocol_port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["connection_limit"] = connection_limit
            __props__.__dict__["default_pool_id"] = default_pool_id
            __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
            __props__.__dict__["description"] = description
            __props__.__dict__["http2_enable"] = http2_enable
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if protocol_port is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_port'")
            __props__.__dict__["protocol_port"] = protocol_port
            __props__.__dict__["region"] = region
            __props__.__dict__["sni_container_refs"] = sni_container_refs
            __props__.__dict__["tags"] = tags
            if tenant_id is not None and not opts.urn:
                warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
                pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
            __props__.__dict__["tenant_id"] = tenant_id
        super(Listener, __self__).__init__(
            'huaweicloud:Elb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            connection_limit: Optional[pulumi.Input[int]] = None,
            default_pool_id: Optional[pulumi.Input[str]] = None,
            default_tls_container_ref: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            http2_enable: Optional[pulumi.Input[bool]] = None,
            loadbalancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            protocol_port: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            sni_container_refs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the listener. A valid value is true (UP) or false (
               DOWN).
        :param pulumi.Input[int] connection_limit: The maximum number of connections allowed for the listener. The value ranges from
               -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
               number of connections.
        :param pulumi.Input[str] default_pool_id: The ID of the default pool with which the listener is associated.
               Changing this creates a new listener.
        :param pulumi.Input[str] default_tls_container_ref: Specifies the ID of the server certificate used by the listener. This
               parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] description: Human-readable description for the listener.
        :param pulumi.Input[bool] http2_enable: Specifies whether to use HTTP/2. The default value is false. This parameter is valid
               only when the protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[str] loadbalancer_id: The load balancer on which to provision this listener. Changing this
               creates a new listener.
        :param pulumi.Input[str] name: Human-readable name for the listener. Does not have to be unique.
        :param pulumi.Input[str] protocol: The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
               creates a new listener.
        :param pulumi.Input[int] protocol_port: The port on which to listen for client traffic. Changing this creates a
               new listener.
        :param pulumi.Input[str] region: The region in which to create the listener resource. If omitted, the
               provider-level region will be used. Changing this creates a new listener.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sni_container_refs: Lists the IDs of SNI certificates (server certificates with a domain name)
               used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the listener.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["connection_limit"] = connection_limit
        __props__.__dict__["default_pool_id"] = default_pool_id
        __props__.__dict__["default_tls_container_ref"] = default_tls_container_ref
        __props__.__dict__["description"] = description
        __props__.__dict__["http2_enable"] = http2_enable
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_port"] = protocol_port
        __props__.__dict__["region"] = region
        __props__.__dict__["sni_container_refs"] = sni_container_refs
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the listener. A valid value is true (UP) or false (
        DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="connectionLimit")
    def connection_limit(self) -> pulumi.Output[int]:
        """
        The maximum number of connections allowed for the listener. The value ranges from
        -1 to 2,147,483,647. This parameter is reserved and has been not used. Only the administrator can specify the maximum
        number of connections.
        """
        return pulumi.get(self, "connection_limit")

    @property
    @pulumi.getter(name="defaultPoolId")
    def default_pool_id(self) -> pulumi.Output[str]:
        """
        The ID of the default pool with which the listener is associated.
        Changing this creates a new listener.
        """
        return pulumi.get(self, "default_pool_id")

    @property
    @pulumi.getter(name="defaultTlsContainerRef")
    def default_tls_container_ref(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the server certificate used by the listener. This
        parameter is mandatory when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "default_tls_container_ref")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use HTTP/2. The default value is false. This parameter is valid
        only when the protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "http2_enable")

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[str]:
        """
        The load balancer on which to provision this listener. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the listener. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol can either be TCP, UDP, HTTP or TERMINATED_HTTPS. Changing this
        creates a new listener.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Output[int]:
        """
        The port on which to listen for client traffic. Changing this creates a
        new listener.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the listener resource. If omitted, the
        provider-level region will be used. Changing this creates a new listener.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sniContainerRefs")
    def sni_container_refs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Lists the IDs of SNI certificates (server certificates with a domain name)
        used by the listener. This parameter is valid when protocol is set to *TERMINATED_HTTPS*.
        """
        return pulumi.get(self, "sni_container_refs")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the listener.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

