# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, id=None, listeners=None, name=None, protocol=None, protocol_port=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_port and not isinstance(protocol_port, str):
            raise TypeError("Expected argument 'protocol_port' to be a str")
        pulumi.set(__self__, "protocol_port", protocol_port)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        """
        Listener list.
        The object structure is documented below.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The listener name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The listener protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> Optional[str]:
        """
        The front-end listening port of the listener.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            id=self.id,
            listeners=self.listeners,
            name=self.name,
            protocol=self.protocol,
            protocol_port=self.protocol_port,
            region=self.region)


def get_listeners(name: Optional[str] = None,
                  protocol: Optional[str] = None,
                  protocol_port: Optional[str] = None,
                  region: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    Use this data source to query the list of ELB listeners.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    protocol = config.require_object("protocol")
    test = huaweicloud.Elb.get_listeners(protocol=protocol)
    ```


    :param str name: The listener name.
    :param str protocol: The listener protocol.  
           The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
    :param str protocol_port: The front-end listening port of the listener.  
           The valid value is range from `1` to `65535`.
    :param str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['protocol'] = protocol
    __args__['protocolPort'] = protocol_port
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Elb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        id=__ret__.id,
        listeners=__ret__.listeners,
        name=__ret__.name,
        protocol=__ret__.protocol,
        protocol_port=__ret__.protocol_port,
        region=__ret__.region)


@_utilities.lift_output_func(get_listeners)
def get_listeners_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                         protocol: Optional[pulumi.Input[Optional[str]]] = None,
                         protocol_port: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListenersResult]:
    """
    Use this data source to query the list of ELB listeners.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    protocol = config.require_object("protocol")
    test = huaweicloud.Elb.get_listeners(protocol=protocol)
    ```


    :param str name: The listener name.
    :param str protocol: The listener protocol.  
           The valid values are **TCP**, **UDP**, **HTTP** and **TERMINATED_HTTPS**.
    :param str protocol_port: The front-end listening port of the listener.  
           The valid value is range from `1` to `65535`.
    :param str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    ...
