# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterEndpoint',
    'ClusterPublicEndpoint',
    'ClusterPublicIp',
    'GetFlaovrsFlavorResult',
]

@pulumi.output_type
class ClusterEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectInfo":
            suggest = "connect_info"
        elif key == "jdbcUrl":
            suggest = "jdbc_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_info: Optional[str] = None,
                 jdbc_url: Optional[str] = None):
        """
        :param str connect_info: (Optional, String) Private network connection information.
        :param str jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        if connect_info is not None:
            pulumi.set(__self__, "connect_info", connect_info)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)

    @property
    @pulumi.getter(name="connectInfo")
    def connect_info(self) -> Optional[str]:
        """
        (Optional, String) Private network connection information.
        """
        return pulumi.get(self, "connect_info")

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[str]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")


@pulumi.output_type
class ClusterPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jdbcUrl":
            suggest = "jdbc_url"
        elif key == "publicConnectInfo":
            suggest = "public_connect_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jdbc_url: Optional[str] = None,
                 public_connect_info: Optional[str] = None):
        """
        :param str jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        :param str public_connect_info: (Optional, String)
               Public network connection information.
        """
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if public_connect_info is not None:
            pulumi.set(__self__, "public_connect_info", public_connect_info)

    @property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[str]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")

    @property
    @pulumi.getter(name="publicConnectInfo")
    def public_connect_info(self) -> Optional[str]:
        """
        (Optional, String)
        Public network connection information.
        """
        return pulumi.get(self, "public_connect_info")


@pulumi.output_type
class ClusterPublicIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eipId":
            suggest = "eip_id"
        elif key == "publicBindType":
            suggest = "public_bind_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPublicIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPublicIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPublicIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip_id: Optional[str] = None,
                 public_bind_type: Optional[str] = None):
        """
        :param str eip_id: EIP ID.
        :param str public_bind_type: Binding type of an EIP. The value can be either of the following:
               auto_assign not_use bind_existing The default value is not_use.
        """
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if public_bind_type is not None:
            pulumi.set(__self__, "public_bind_type", public_bind_type)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[str]:
        """
        EIP ID.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="publicBindType")
    def public_bind_type(self) -> Optional[str]:
        """
        Binding type of an EIP. The value can be either of the following:
        auto_assign not_use bind_existing The default value is not_use.
        """
        return pulumi.get(self, "public_bind_type")


@pulumi.output_type
class GetFlaovrsFlavorResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 flavor_id: str,
                 memory: int,
                 size: int,
                 vcpus: int,
                 volumetype: str):
        """
        :param str availability_zone: Specifies the availability zone name.
        :param str flavor_id: The name of the dws node flavor. It is referenced by `node_type` in `_dws.get_flaovrs`.
        :param int memory: Specifies the ram of the dws node flavor in GB.
        :param int size: Indicates the Disk size in GB.
        :param int vcpus: Specifies the vcpus of the dws node flavor.
        :param str volumetype: Indicates Disk type.
               + **LOCAL_DISK**: common I/O disk
               + **SSD**: ultra-high I/O disk
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "volumetype", volumetype)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Specifies the availability zone name.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> str:
        """
        The name of the dws node flavor. It is referenced by `node_type` in `_dws.get_flaovrs`.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Specifies the ram of the dws node flavor in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Indicates the Disk size in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        Specifies the vcpus of the dws node flavor.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def volumetype(self) -> str:
        """
        Indicates Disk type.
        + **LOCAL_DISK**: common I/O disk
        + **SSD**: ultra-high I/O disk
        """
        return pulumi.get(self, "volumetype")


