# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KafkaTopicArgs', 'KafkaTopic']

@pulumi.input_type
class KafkaTopicArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 partitions: pulumi.Input[int],
                 aging_time: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 sync_flushing: Optional[pulumi.Input[bool]] = None,
                 sync_replication: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a KafkaTopic resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[bool] sync_replication: Whether or not to enable synchronous replication.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "partitions", partitions)
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sync_flushing is not None:
            pulumi.set(__self__, "sync_flushing", sync_flushing)
        if sync_replication is not None:
            pulumi.set(__self__, "sync_replication", sync_replication)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[int]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aging_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @sync_flushing.setter
    def sync_flushing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_flushing", value)

    @property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

    @sync_replication.setter
    def sync_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_replication", value)


@pulumi.input_type
class _KafkaTopicState:
    def __init__(__self__, *,
                 aging_time: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 sync_flushing: Optional[pulumi.Input[bool]] = None,
                 sync_replication: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering KafkaTopic resources.
        :param pulumi.Input[int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[bool] sync_replication: Whether or not to enable synchronous replication.
        """
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sync_flushing is not None:
            pulumi.set(__self__, "sync_flushing", sync_flushing)
        if sync_replication is not None:
            pulumi.set(__self__, "sync_replication", sync_replication)

    @property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aging_time", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @sync_flushing.setter
    def sync_flushing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_flushing", value)

    @property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

    @sync_replication.setter
    def sync_replication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sync_replication", value)


class KafkaTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aging_time: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 sync_flushing: Optional[pulumi.Input[bool]] = None,
                 sync_replication: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Manages a DMS kafka topic resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        topic = huaweicloud.dms.KafkaTopic("topic",
            instance_id=kafka_instance_id,
            partitions=20)
        ```

        ## Import

        DMS kafka topics can be imported using the kafka instance ID and topic name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaTopic:KafkaTopic topic c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[bool] sync_replication: Whether or not to enable synchronous replication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS kafka topic resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        topic = huaweicloud.dms.KafkaTopic("topic",
            instance_id=kafka_instance_id,
            partitions=20)
        ```

        ## Import

        DMS kafka topics can be imported using the kafka instance ID and topic name separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaTopic:KafkaTopic topic c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param KafkaTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aging_time: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 sync_flushing: Optional[pulumi.Input[bool]] = None,
                 sync_replication: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaTopicArgs.__new__(KafkaTopicArgs)

            __props__.__dict__["aging_time"] = aging_time
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            __props__.__dict__["region"] = region
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["sync_flushing"] = sync_flushing
            __props__.__dict__["sync_replication"] = sync_replication
        super(KafkaTopic, __self__).__init__(
            'huaweicloud:Dms/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aging_time: Optional[pulumi.Input[int]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partitions: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            sync_flushing: Optional[pulumi.Input[bool]] = None,
            sync_replication: Optional[pulumi.Input[bool]] = None) -> 'KafkaTopic':
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[bool] sync_replication: Whether or not to enable synchronous replication.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaTopicState.__new__(_KafkaTopicState)

        __props__.__dict__["aging_time"] = aging_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["sync_flushing"] = sync_flushing
        __props__.__dict__["sync_replication"] = sync_replication
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> pulumi.Output[int]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[int]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[int]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> pulumi.Output[bool]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

