# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaInstanceArgs', 'KafkaInstance']

@pulumi.input_type
class KafkaInstanceArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[str],
                 manager_password: pulumi.Input[str],
                 manager_user: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 storage_spec_code: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 broker_num: Optional[pulumi.Input[int]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dumping: Optional[pulumi.Input[bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a KafkaInstance resource.
        :param pulumi.Input[str] engine_version: Specifies the version of the kafka engine. Valid values are **1.1.0**
               and **2.3.0**. Changing this creates a new instance resource.
        :param pulumi.Input[str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        :param pulumi.Input[str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               If the instance is created with `flavor_id`, the valid values are as follows:
               + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
               + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        :param pulumi.Input[str] bandwidth: The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
               Unit: MB.
        :param pulumi.Input[int] broker_num: Specifies the broker numbers. Changing this creates a new instance resource.
               If the instance is created with `flavor_id`, this parameter is required.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]] cross_vpc_accesses: Specifies the access information of cross-VPC.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the DMS kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[bool] dumping: Specifies whether to enable dumping. Changing this creates a new instance
               resource.
        :param pulumi.Input[bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the kafka instance.
        :param pulumi.Input[str] flavor_id: Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
               e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] name: Specifies the name of the DMS kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] password: Specifies the password of the DMS kafka instance. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        :param pulumi.Input[str] region: The region in which to create the DMS kafka instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[int] storage_space: Specifies the message storage capacity, the unit is GB.
               The storage spaces corresponding to the product IDs are as follows:
               + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
               + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
               + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
               + **c6.12u12g.cluster**: `3,600` to `90,000` GB
               + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS kafka instance.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "manager_password", manager_password)
        pulumi.set(__self__, "manager_user", manager_user)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth is not None:
            warnings.warn("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""", DeprecationWarning)
            pulumi.log.warn("""bandwidth is deprecated: The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if cross_vpc_accesses is not None:
            pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dumping is not None:
            pulumi.set(__self__, "dumping", dumping)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_ids is not None:
            pulumi.set(__self__, "public_ip_ids", public_ip_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        Specifies the version of the kafka engine. Valid values are **1.1.0**
        and **2.3.0**. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="managerPassword")
    def manager_password(self) -> pulumi.Input[str]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "manager_password")

    @manager_password.setter
    def manager_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_password", value)

    @property
    @pulumi.getter(name="managerUser")
    def manager_user(self) -> pulumi.Input[str]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @manager_user.setter
    def manager_user(self, value: pulumi.Input[str]):
        pulumi.set(self, "manager_user", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Input[str]:
        """
        Specifies the storage I/O specification.
        If the instance is created with `flavor_id`, the valid values are as follows:
        + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
        + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_spec_code", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
        Unit: MB.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the broker numbers. Changing this creates a new instance resource.
        If the instance is created with `flavor_id`, this parameter is required.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "broker_num", value)

    @property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]:
        """
        Specifies the access information of cross-VPC.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @cross_vpc_accesses.setter
    def cross_vpc_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]):
        pulumi.set(self, "cross_vpc_accesses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the DMS kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dumping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable dumping. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "dumping")

    @dumping.setter
    def dumping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dumping", value)

    @property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_topic", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID of the kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
        e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the DMS kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the DMS kafka instance. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        """
        return pulumi.get(self, "public_ip_ids")

    @public_ip_ids.setter
    def public_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ip_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the message storage capacity, the unit is GB.
        The storage spaces corresponding to the product IDs are as follows:
        + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
        + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
        + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
        + **c6.12u12g.cluster**: `3,600` to `90,000` GB
        + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DMS kafka instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KafkaInstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 broker_num: Optional[pulumi.Input[int]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dumping: Optional[pulumi.Input[bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[bool]] = None,
                 enable_public_ip: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 manager_password: Optional[pulumi.Input[str]] = None,
                 manager_user: Optional[pulumi.Input[str]] = None,
                 manegement_connect_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 partition_num: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_spec_code: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 used_storage_space: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaInstance resources.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        :param pulumi.Input[str] bandwidth: The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
               Unit: MB.
        :param pulumi.Input[int] broker_num: Specifies the broker numbers. Changing this creates a new instance resource.
               If the instance is created with `flavor_id`, this parameter is required.
        :param pulumi.Input[str] connect_address: Indicates the IP address of the DMS kafka instance.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]] cross_vpc_accesses: Specifies the access information of cross-VPC.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the DMS kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[bool] dumping: Specifies whether to enable dumping. Changing this creates a new instance
               resource.
        :param pulumi.Input[bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        :param pulumi.Input[bool] enable_public_ip: Indicates whether public access to the DMS kafka instance is enabled.
        :param pulumi.Input[str] engine: Indicates the message engine.
        :param pulumi.Input[str] engine_version: Specifies the version of the kafka engine. Valid values are **1.1.0**
               and **2.3.0**. Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the kafka instance.
        :param pulumi.Input[str] flavor_id: Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
               e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        :param pulumi.Input[str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[str] manegement_connect_address: Indicates the connection address of the Kafka Manager of a Kafka instance.
        :param pulumi.Input[str] name: Specifies the name of the DMS kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[int] partition_num: Indicates the maximum number of topics in the DMS kafka instance.
        :param pulumi.Input[str] password: Specifies the password of the DMS kafka instance. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[int] port: The port number.
        :param pulumi.Input[str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        :param pulumi.Input[str] region: The region in which to create the DMS kafka instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[str] status: Indicates the status of the DMS kafka instance.
        :param pulumi.Input[int] storage_space: Specifies the message storage capacity, the unit is GB.
               The storage spaces corresponding to the product IDs are as follows:
               + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
               + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
               + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
               + **c6.12u12g.cluster**: `3,600` to `90,000` GB
               + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               If the instance is created with `flavor_id`, the valid values are as follows:
               + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
               + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS kafka instance.
        :param pulumi.Input[str] type: Indicates the DMS kafka instance type.
        :param pulumi.Input[int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[str] user_id: Indicates the ID of the user who created the DMS kafka instance
        :param pulumi.Input[str] user_name: Indicates the name of the user who created the DMS kafka instance
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth is not None:
            warnings.warn("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""", DeprecationWarning)
            pulumi.log.warn("""bandwidth is deprecated: The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if cross_vpc_accesses is not None:
            pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dumping is not None:
            pulumi.set(__self__, "dumping", dumping)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if manager_password is not None:
            pulumi.set(__self__, "manager_password", manager_password)
        if manager_user is not None:
            pulumi.set(__self__, "manager_user", manager_user)
        if manegement_connect_address is not None:
            pulumi.set(__self__, "manegement_connect_address", manegement_connect_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_ids is not None:
            pulumi.set(__self__, "public_ip_ids", public_ip_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_spec_code is not None:
            pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_spec_code is not None:
            pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_storage_space is not None:
            pulumi.set(__self__, "used_storage_space", used_storage_space)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_user", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
        Unit: MB.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the broker numbers. Changing this creates a new instance resource.
        If the instance is created with `flavor_id`, this parameter is required.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "broker_num", value)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the IP address of the DMS kafka instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]:
        """
        Specifies the access information of cross-VPC.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @cross_vpc_accesses.setter
    def cross_vpc_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]):
        pulumi.set(self, "cross_vpc_accesses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the DMS kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dumping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable dumping. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "dumping")

    @dumping.setter
    def dumping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dumping", value)

    @property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_topic", value)

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether public access to the DMS kafka instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @enable_public_ip.setter
    def enable_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public_ip", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the kafka engine. Valid values are **1.1.0**
        and **2.3.0**. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project ID of the kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
        e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter(name="managerPassword")
    def manager_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "manager_password")

    @manager_password.setter
    def manager_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manager_password", value)

    @property
    @pulumi.getter(name="managerUser")
    def manager_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @manager_user.setter
    def manager_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manager_user", value)

    @property
    @pulumi.getter(name="manegementConnectAddress")
    def manegement_connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the connection address of the Kafka Manager of a Kafka instance.
        """
        return pulumi.get(self, "manegement_connect_address")

    @manegement_connect_address.setter
    def manegement_connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manegement_connect_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the DMS kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the maximum number of topics in the DMS kafka instance.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_num", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the DMS kafka instance. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        """
        return pulumi.get(self, "public_ip_ids")

    @public_ip_ids.setter
    def public_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ip_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DMS kafka instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @resource_spec_code.setter
    def resource_spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_spec_code", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the status of the DMS kafka instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the message storage capacity, the unit is GB.
        The storage spaces corresponding to the product IDs are as follows:
        + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
        + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
        + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
        + **c6.12u12g.cluster**: `3,600` to `90,000` GB
        + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage I/O specification.
        If the instance is created with `flavor_id`, the valid values are as follows:
        + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
        + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_spec_code", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DMS kafka instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the DMS kafka instance type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @used_storage_space.setter
    def used_storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_storage_space", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the ID of the user who created the DMS kafka instance
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the name of the user who created the DMS kafka instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class KafkaInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 broker_num: Optional[pulumi.Input[int]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaInstanceCrossVpcAccessArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dumping: Optional[pulumi.Input[bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 manager_password: Optional[pulumi.Input[str]] = None,
                 manager_user: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage DMS Kafka instance resources within HuaweiCloud.

        ## Example Usage
        ### Create a kafka instance using product ID

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        instance_name = config.require_object("instanceName")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_product = huaweicloud.Dms.get_product(engine="kafka",
            instance_type="cluster",
            version="2.3.0",
            bandwidth="100MB",
            storage_spec_code="dms.physical.storage.ultra")
        test_kafka_instance = huaweicloud.dms.KafkaInstance("testKafkaInstance",
            product_id=data["huaweicloud_dms_product"]["product_1"]["id"],
            engine_version=data["huaweicloud_dms_product"]["product_1"]["version"],
            storage_spec_code=data["huaweicloud_dms_product"]["product_1"]["storage_spec_code"],
            availability_zones=[
                data["huaweicloud_availability_zones"]["zones"]["names"],
                data["huaweicloud_availability_zones"]["zones"]["names"],
                data["huaweicloud_availability_zones"]["zones"]["names"],
            ],
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            access_user="user",
            password="Kafkatest@123",
            manager_user="kafka-user",
            manager_password="Kafkatest@123")
        ```

        ## Import

        DMS kafka instance can be imported using the instance id, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaInstance:KafkaInstance huaweicloud_dms_kafka_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `manager_password` and `public_ip_ids`. It is generally recommended running `terraform plan` after importing a DMS kafka instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dms_kafka_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password, manager_password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        :param pulumi.Input[str] bandwidth: The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
               Unit: MB.
        :param pulumi.Input[int] broker_num: Specifies the broker numbers. Changing this creates a new instance resource.
               If the instance is created with `flavor_id`, this parameter is required.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaInstanceCrossVpcAccessArgs']]]] cross_vpc_accesses: Specifies the access information of cross-VPC.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the DMS kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[bool] dumping: Specifies whether to enable dumping. Changing this creates a new instance
               resource.
        :param pulumi.Input[bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        :param pulumi.Input[str] engine_version: Specifies the version of the kafka engine. Valid values are **1.1.0**
               and **2.3.0**. Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the kafka instance.
        :param pulumi.Input[str] flavor_id: Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
               e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        :param pulumi.Input[str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[str] name: Specifies the name of the DMS kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[str] password: Specifies the password of the DMS kafka instance. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        :param pulumi.Input[str] region: The region in which to create the DMS kafka instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[int] storage_space: Specifies the message storage capacity, the unit is GB.
               The storage spaces corresponding to the product IDs are as follows:
               + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
               + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
               + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
               + **c6.12u12g.cluster**: `3,600` to `90,000` GB
               + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               If the instance is created with `flavor_id`, the valid values are as follows:
               + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
               + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS kafka instance.
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage DMS Kafka instance resources within HuaweiCloud.

        ## Example Usage
        ### Create a kafka instance using product ID

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        instance_name = config.require_object("instanceName")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_product = huaweicloud.Dms.get_product(engine="kafka",
            instance_type="cluster",
            version="2.3.0",
            bandwidth="100MB",
            storage_spec_code="dms.physical.storage.ultra")
        test_kafka_instance = huaweicloud.dms.KafkaInstance("testKafkaInstance",
            product_id=data["huaweicloud_dms_product"]["product_1"]["id"],
            engine_version=data["huaweicloud_dms_product"]["product_1"]["version"],
            storage_spec_code=data["huaweicloud_dms_product"]["product_1"]["storage_spec_code"],
            availability_zones=[
                data["huaweicloud_availability_zones"]["zones"]["names"],
                data["huaweicloud_availability_zones"]["zones"]["names"],
                data["huaweicloud_availability_zones"]["zones"]["names"],
            ],
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            access_user="user",
            password="Kafkatest@123",
            manager_user="kafka-user",
            manager_password="Kafkatest@123")
        ```

        ## Import

        DMS kafka instance can be imported using the instance id, e.g.

        ```sh
         $ pulumi import huaweicloud:Dms/kafkaInstance:KafkaInstance huaweicloud_dms_kafka_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `manager_password` and `public_ip_ids`. It is generally recommended running `terraform plan` after importing a DMS kafka instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dms_kafka_instance" "instance_1" {

         ...

         lifecycle {

         ignore_changes = [

         password, manager_password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param KafkaInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 broker_num: Optional[pulumi.Input[int]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaInstanceCrossVpcAccessArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dumping: Optional[pulumi.Input[bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[bool]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 manager_password: Optional[pulumi.Input[str]] = None,
                 manager_user: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_spec_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaInstanceArgs.__new__(KafkaInstanceArgs)

            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["availability_zones"] = availability_zones
            if available_zones is not None and not opts.urn:
                warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
                pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
            __props__.__dict__["available_zones"] = available_zones
            if bandwidth is not None and not opts.urn:
                warnings.warn("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""", DeprecationWarning)
                pulumi.log.warn("""bandwidth is deprecated: The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["broker_num"] = broker_num
            __props__.__dict__["cross_vpc_accesses"] = cross_vpc_accesses
            __props__.__dict__["description"] = description
            __props__.__dict__["dumping"] = dumping
            __props__.__dict__["enable_auto_topic"] = enable_auto_topic
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            if manager_password is None and not opts.urn:
                raise TypeError("Missing required property 'manager_password'")
            __props__.__dict__["manager_password"] = manager_password
            if manager_user is None and not opts.urn:
                raise TypeError("Missing required property 'manager_user'")
            __props__.__dict__["manager_user"] = manager_user
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["password"] = password
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["public_ip_ids"] = public_ip_ids
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_policy"] = retention_policy
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["storage_space"] = storage_space
            if storage_spec_code is None and not opts.urn:
                raise TypeError("Missing required property 'storage_spec_code'")
            __props__.__dict__["storage_spec_code"] = storage_spec_code
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connect_address"] = None
            __props__.__dict__["enable_public_ip"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["manegement_connect_address"] = None
            __props__.__dict__["partition_num"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["resource_spec_code"] = None
            __props__.__dict__["ssl_enable"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["used_storage_space"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
        super(KafkaInstance, __self__).__init__(
            'huaweicloud:Dms/kafkaInstance:KafkaInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            broker_num: Optional[pulumi.Input[int]] = None,
            connect_address: Optional[pulumi.Input[str]] = None,
            cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaInstanceCrossVpcAccessArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dumping: Optional[pulumi.Input[bool]] = None,
            enable_auto_topic: Optional[pulumi.Input[bool]] = None,
            enable_public_ip: Optional[pulumi.Input[bool]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            maintain_begin: Optional[pulumi.Input[str]] = None,
            maintain_end: Optional[pulumi.Input[str]] = None,
            manager_password: Optional[pulumi.Input[str]] = None,
            manager_user: Optional[pulumi.Input[str]] = None,
            manegement_connect_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            partition_num: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resource_spec_code: Optional[pulumi.Input[str]] = None,
            retention_policy: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            ssl_enable: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_space: Optional[pulumi.Input[int]] = None,
            storage_spec_code: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            used_storage_space: Optional[pulumi.Input[int]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'KafkaInstance':
        """
        Get an existing KafkaInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        :param pulumi.Input[str] bandwidth: The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
               Unit: MB.
        :param pulumi.Input[int] broker_num: Specifies the broker numbers. Changing this creates a new instance resource.
               If the instance is created with `flavor_id`, this parameter is required.
        :param pulumi.Input[str] connect_address: Indicates the IP address of the DMS kafka instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KafkaInstanceCrossVpcAccessArgs']]]] cross_vpc_accesses: Specifies the access information of cross-VPC.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the DMS kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[bool] dumping: Specifies whether to enable dumping. Changing this creates a new instance
               resource.
        :param pulumi.Input[bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        :param pulumi.Input[bool] enable_public_ip: Indicates whether public access to the DMS kafka instance is enabled.
        :param pulumi.Input[str] engine: Indicates the message engine.
        :param pulumi.Input[str] engine_version: Specifies the version of the kafka engine. Valid values are **1.1.0**
               and **2.3.0**. Changing this creates a new instance resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project ID of the kafka instance.
        :param pulumi.Input[str] flavor_id: Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
               e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        :param pulumi.Input[str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        :param pulumi.Input[str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[str] manegement_connect_address: Indicates the connection address of the Kafka Manager of a Kafka instance.
        :param pulumi.Input[str] name: Specifies the name of the DMS kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[int] partition_num: Indicates the maximum number of topics in the DMS kafka instance.
        :param pulumi.Input[str] password: Specifies the password of the DMS kafka instance. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[int] port: The port number.
        :param pulumi.Input[str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        :param pulumi.Input[str] region: The region in which to create the DMS kafka instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[str] status: Indicates the status of the DMS kafka instance.
        :param pulumi.Input[int] storage_space: Specifies the message storage capacity, the unit is GB.
               The storage spaces corresponding to the product IDs are as follows:
               + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
               + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
               + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
               + **c6.12u12g.cluster**: `3,600` to `90,000` GB
               + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        :param pulumi.Input[str] storage_spec_code: Specifies the storage I/O specification.
               If the instance is created with `flavor_id`, the valid values are as follows:
               + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
               + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DMS kafka instance.
        :param pulumi.Input[str] type: Indicates the DMS kafka instance type.
        :param pulumi.Input[int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[str] user_id: Indicates the ID of the user who created the DMS kafka instance
        :param pulumi.Input[str] user_name: Indicates the name of the user who created the DMS kafka instance
        :param pulumi.Input[str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaInstanceState.__new__(_KafkaInstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["broker_num"] = broker_num
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["cross_vpc_accesses"] = cross_vpc_accesses
        __props__.__dict__["description"] = description
        __props__.__dict__["dumping"] = dumping
        __props__.__dict__["enable_auto_topic"] = enable_auto_topic
        __props__.__dict__["enable_public_ip"] = enable_public_ip
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["manager_password"] = manager_password
        __props__.__dict__["manager_user"] = manager_user
        __props__.__dict__["manegement_connect_address"] = manegement_connect_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["partition_num"] = partition_num
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["public_ip_ids"] = public_ip_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_spec_code"] = resource_spec_code
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_spec_code"] = storage_spec_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_storage_space"] = used_storage_space
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        return KafkaInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        The Bandwidth of a Kafka instance, that is the maximum amount of data transferred per unit time.
        Unit: MB.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> pulumi.Output[int]:
        """
        Specifies the broker numbers. Changing this creates a new instance resource.
        If the instance is created with `flavor_id`, this parameter is required.
        """
        return pulumi.get(self, "broker_num")

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[str]:
        """
        Indicates the IP address of the DMS kafka instance.
        """
        return pulumi.get(self, "connect_address")

    @property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> pulumi.Output[Sequence['outputs.KafkaInstanceCrossVpcAccess']]:
        """
        Specifies the access information of cross-VPC.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the DMS kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dumping(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable dumping. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "dumping")

    @property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> pulumi.Output[bool]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> pulumi.Output[bool]:
        """
        Indicates whether public access to the DMS kafka instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Specifies the version of the kafka engine. Valid values are **1.1.0**
        and **2.3.0**. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project ID of the kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the kafka [flavor ID](https://support.huaweicloud.com/intl/en-us/productdesc-kafka/Kafka-specification.html),
        e.g. **c6.2u4g.cluster**. This parameter and `product_id` are alternative.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[str]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[str]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @property
    @pulumi.getter(name="managerPassword")
    def manager_password(self) -> pulumi.Output[str]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "manager_password")

    @property
    @pulumi.getter(name="managerUser")
    def manager_user(self) -> pulumi.Output[str]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @property
    @pulumi.getter(name="manegementConnectAddress")
    def manegement_connect_address(self) -> pulumi.Output[str]:
        """
        Indicates the connection address of the Kafka Manager of a Kafka instance.
        """
        return pulumi.get(self, "manegement_connect_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the DMS kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> pulumi.Output[int]:
        """
        Indicates the maximum number of topics in the DMS kafka instance.
        """
        return pulumi.get(self, "partition_num")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the password of the DMS kafka instance. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
        """
        return pulumi.get(self, "public_ip_ids")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DMS kafka instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> pulumi.Output[str]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[str]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[bool]:
        """
        Indicates whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the status of the DMS kafka instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[int]:
        """
        Specifies the message storage capacity, the unit is GB.
        The storage spaces corresponding to the product IDs are as follows:
        + **c6.2u4g.cluster** (100MB bandwidth): `600` to `90,000` GB
        + **c6.4u8g.cluster** (300MB bandwidth): `1,200` to `90,000` GB
        + **c6.8u16g.cluster** (600MB bandwidth): `2,400` to `90,000` GB
        + **c6.12u12g.cluster**: `3,600` to `90,000` GB
        + **c6.16u32g.cluster** (1,200MB bandwidth): `4,800` to `90,000` GB
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Output[str]:
        """
        Specifies the storage I/O specification.
        If the instance is created with `flavor_id`, the valid values are as follows:
        + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
        + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        """
        return pulumi.get(self, "storage_spec_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the DMS kafka instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Indicates the DMS kafka instance type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> pulumi.Output[int]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Indicates the ID of the user who created the DMS kafka instance
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Indicates the name of the user who created the DMS kafka instance
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

