# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 data_location: pulumi.Input[str],
                 database_name: pulumi.Input[str],
                 bucket_location: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 escape_char: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quote_char: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 with_column_header: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[str] data_location: Specifies data storage location. Changing this parameter will create
               a newresource. The options are as follows:
               + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
               + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
               and analysis.
        :param pulumi.Input[str] database_name: Specifies the database name which the table belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] bucket_location: Specifies storage path of data which will be import to the OBS table.
               Changing this parameter will create a new resource.
               > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
               creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]] columns: Specifies Columns of the new table. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_format: Specifies type of the data to be added to the OBS table.
               The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        :param pulumi.Input[str] date_format: Specifies date type. `yyyy-MM-dd` is used by default. Only
               data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] delimiter: Specifies data delimiter. Only data in CSV files has this
               attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of column. Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] escape_char: Specifies escape character. Backslashes (`\\\\`) are used by
               default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of column. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] quote_char: Specifies reference character. Double quotation marks (`\\`)
               are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the dli table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] timestamp_format: Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
               Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] with_column_header: Specifies whether the table header is included in the data file.
               Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "data_location", data_location)
        pulumi.set(__self__, "database_name", database_name)
        if bucket_location is not None:
            pulumi.set(__self__, "bucket_location", bucket_location)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if escape_char is not None:
            pulumi.set(__self__, "escape_char", escape_char)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quote_char is not None:
            pulumi.set(__self__, "quote_char", quote_char)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if with_column_header is not None:
            pulumi.set(__self__, "with_column_header", with_column_header)

    @property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> pulumi.Input[str]:
        """
        Specifies data storage location. Changing this parameter will create
        a newresource. The options are as follows:
        + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
        + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
        and analysis.
        """
        return pulumi.get(self, "data_location")

    @data_location.setter
    def data_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_location", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Specifies the database name which the table belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="bucketLocation")
    def bucket_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies storage path of data which will be import to the OBS table.
        Changing this parameter will create a new resource.
        > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
        creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        """
        return pulumi.get(self, "bucket_location")

    @bucket_location.setter
    def bucket_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_location", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]:
        """
        Specifies Columns of the new table. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies type of the data to be added to the OBS table.
        The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies date type. `yyyy-MM-dd` is used by default. Only
        data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies data delimiter. Only data in CSV files has this
        attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of column. Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="escapeChar")
    def escape_char(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies escape character. Backslashes (`\\\\`) are used by
        default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "escape_char")

    @escape_char.setter
    def escape_char(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape_char", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of column. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="quoteChar")
    def quote_char(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies reference character. Double quotation marks (`\\`)
        are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "quote_char")

    @quote_char.setter
    def quote_char(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote_char", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dli table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
        Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the table header is included in the data file.
        Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "with_column_header")

    @with_column_header.setter
    def with_column_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_column_header", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 bucket_location: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_location: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 escape_char: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quote_char: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 with_column_header: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input[str] bucket_location: Specifies storage path of data which will be import to the OBS table.
               Changing this parameter will create a new resource.
               > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
               creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]] columns: Specifies Columns of the new table. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_format: Specifies type of the data to be added to the OBS table.
               The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_location: Specifies data storage location. Changing this parameter will create
               a newresource. The options are as follows:
               + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
               + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
               and analysis.
        :param pulumi.Input[str] database_name: Specifies the database name which the table belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] date_format: Specifies date type. `yyyy-MM-dd` is used by default. Only
               data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] delimiter: Specifies data delimiter. Only data in CSV files has this
               attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of column. Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] escape_char: Specifies escape character. Backslashes (`\\\\`) are used by
               default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of column. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] quote_char: Specifies reference character. Double quotation marks (`\\`)
               are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the dli table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] timestamp_format: Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
               Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] with_column_header: Specifies whether the table header is included in the data file.
               Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        if bucket_location is not None:
            pulumi.set(__self__, "bucket_location", bucket_location)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if data_location is not None:
            pulumi.set(__self__, "data_location", data_location)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if escape_char is not None:
            pulumi.set(__self__, "escape_char", escape_char)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if quote_char is not None:
            pulumi.set(__self__, "quote_char", quote_char)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)
        if with_column_header is not None:
            pulumi.set(__self__, "with_column_header", with_column_header)

    @property
    @pulumi.getter(name="bucketLocation")
    def bucket_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies storage path of data which will be import to the OBS table.
        Changing this parameter will create a new resource.
        > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
        creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        """
        return pulumi.get(self, "bucket_location")

    @bucket_location.setter
    def bucket_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_location", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]:
        """
        Specifies Columns of the new table. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies type of the data to be added to the OBS table.
        The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies data storage location. Changing this parameter will create
        a newresource. The options are as follows:
        + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
        + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
        and analysis.
        """
        return pulumi.get(self, "data_location")

    @data_location.setter
    def data_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_location", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name which the table belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies date type. `yyyy-MM-dd` is used by default. Only
        data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies data delimiter. Only data in CSV files has this
        attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of column. Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="escapeChar")
    def escape_char(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies escape character. Backslashes (`\\\\`) are used by
        default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "escape_char")

    @escape_char.setter
    def escape_char(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "escape_char", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of column. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="quoteChar")
    def quote_char(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies reference character. Double quotation marks (`\\`)
        are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "quote_char")

    @quote_char.setter
    def quote_char(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote_char", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dli table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
        Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "timestamp_format")

    @timestamp_format.setter
    def timestamp_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_format", value)

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the table header is included in the data file.
        Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "with_column_header")

    @with_column_header.setter
    def with_column_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_column_header", value)


class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_location: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TableColumnArgs']]]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_location: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 escape_char: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quote_char: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 with_column_header: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Manages DLI Table resource within HuaweiCloud

        ## Example Usage
        ### Create a Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        test_database = huaweicloud.dli.Database("testDatabase")
        test_table = huaweicloud.dli.Table("testTable",
            database_name=test_database.name,
            data_location="DLI",
            description="SQL table_1 description",
            columns=[
                huaweicloud.dli.TableColumnArgs(
                    name="column_1",
                    type="string",
                    description="the first column",
                ),
                huaweicloud.dli.TableColumnArgs(
                    name="column_2",
                    type="string",
                    description="the second column",
                ),
            ])
        ```

        ## Import

        DLI table can be imported by `id`. It is composed of the name of database which table belongs and the name of table,

        separated by a slash. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/table:Table example <database_name>/<table_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_location: Specifies storage path of data which will be import to the OBS table.
               Changing this parameter will create a new resource.
               > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
               creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TableColumnArgs']]]] columns: Specifies Columns of the new table. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_format: Specifies type of the data to be added to the OBS table.
               The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_location: Specifies data storage location. Changing this parameter will create
               a newresource. The options are as follows:
               + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
               + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
               and analysis.
        :param pulumi.Input[str] database_name: Specifies the database name which the table belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] date_format: Specifies date type. `yyyy-MM-dd` is used by default. Only
               data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] delimiter: Specifies data delimiter. Only data in CSV files has this
               attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of column. Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] escape_char: Specifies escape character. Backslashes (`\\\\`) are used by
               default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of column. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] quote_char: Specifies reference character. Double quotation marks (`\\`)
               are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the dli table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] timestamp_format: Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
               Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] with_column_header: Specifies whether the table header is included in the data file.
               Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI Table resource within HuaweiCloud

        ## Example Usage
        ### Create a Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        test_database = huaweicloud.dli.Database("testDatabase")
        test_table = huaweicloud.dli.Table("testTable",
            database_name=test_database.name,
            data_location="DLI",
            description="SQL table_1 description",
            columns=[
                huaweicloud.dli.TableColumnArgs(
                    name="column_1",
                    type="string",
                    description="the first column",
                ),
                huaweicloud.dli.TableColumnArgs(
                    name="column_2",
                    type="string",
                    description="the second column",
                ),
            ])
        ```

        ## Import

        DLI table can be imported by `id`. It is composed of the name of database which table belongs and the name of table,

        separated by a slash. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/table:Table example <database_name>/<table_name>
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_location: Optional[pulumi.Input[str]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TableColumnArgs']]]]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_location: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 date_format: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 escape_char: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 quote_char: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timestamp_format: Optional[pulumi.Input[str]] = None,
                 with_column_header: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["bucket_location"] = bucket_location
            __props__.__dict__["columns"] = columns
            __props__.__dict__["data_format"] = data_format
            if data_location is None and not opts.urn:
                raise TypeError("Missing required property 'data_location'")
            __props__.__dict__["data_location"] = data_location
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["date_format"] = date_format
            __props__.__dict__["delimiter"] = delimiter
            __props__.__dict__["description"] = description
            __props__.__dict__["escape_char"] = escape_char
            __props__.__dict__["name"] = name
            __props__.__dict__["quote_char"] = quote_char
            __props__.__dict__["region"] = region
            __props__.__dict__["timestamp_format"] = timestamp_format
            __props__.__dict__["with_column_header"] = with_column_header
        super(Table, __self__).__init__(
            'huaweicloud:Dli/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_location: Optional[pulumi.Input[str]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TableColumnArgs']]]]] = None,
            data_format: Optional[pulumi.Input[str]] = None,
            data_location: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            date_format: Optional[pulumi.Input[str]] = None,
            delimiter: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            escape_char: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            quote_char: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            timestamp_format: Optional[pulumi.Input[str]] = None,
            with_column_header: Optional[pulumi.Input[bool]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_location: Specifies storage path of data which will be import to the OBS table.
               Changing this parameter will create a new resource.
               > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
               creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TableColumnArgs']]]] columns: Specifies Columns of the new table. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_format: Specifies type of the data to be added to the OBS table.
               The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        :param pulumi.Input[str] data_location: Specifies data storage location. Changing this parameter will create
               a newresource. The options are as follows:
               + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
               + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
               and analysis.
        :param pulumi.Input[str] database_name: Specifies the database name which the table belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] date_format: Specifies date type. `yyyy-MM-dd` is used by default. Only
               data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] delimiter: Specifies data delimiter. Only data in CSV files has this
               attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of column. Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] escape_char: Specifies escape character. Backslashes (`\\\\`) are used by
               default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of column. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] quote_char: Specifies reference character. Double quotation marks (`\\`)
               are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the dli table resource. If omitted,
               the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] timestamp_format: Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
               Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] with_column_header: Specifies whether the table header is included in the data file.
               Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["bucket_location"] = bucket_location
        __props__.__dict__["columns"] = columns
        __props__.__dict__["data_format"] = data_format
        __props__.__dict__["data_location"] = data_location
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["date_format"] = date_format
        __props__.__dict__["delimiter"] = delimiter
        __props__.__dict__["description"] = description
        __props__.__dict__["escape_char"] = escape_char
        __props__.__dict__["name"] = name
        __props__.__dict__["quote_char"] = quote_char
        __props__.__dict__["region"] = region
        __props__.__dict__["timestamp_format"] = timestamp_format
        __props__.__dict__["with_column_header"] = with_column_header
        return Table(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketLocation")
    def bucket_location(self) -> pulumi.Output[str]:
        """
        Specifies storage path of data which will be import to the OBS table.
        Changing this parameter will create a new resource.
        > If you need to import data stored in OBS to the OBS table, set this parameter to the path of a folder. If the table
        creation path is a file, data fails to be imported. which must be a path on OBS and must begin with obs.
        """
        return pulumi.get(self, "bucket_location")

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Optional[Sequence['outputs.TableColumn']]]:
        """
        Specifies Columns of the new table. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> pulumi.Output[str]:
        """
        Specifies type of the data to be added to the OBS table.
        The options: parquet, orc, csv, json, carbon, and avro. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> pulumi.Output[str]:
        """
        Specifies data storage location. Changing this parameter will create
        a newresource. The options are as follows:
        + **DLI**: Data stored in DLI tables is applicable to delay-sensitive services, such as interactive queries.
        + **OBS**: Data stored in OBS tables is applicable to delay-insensitive services, such as historical data statistics
        and analysis.
        """
        return pulumi.get(self, "data_location")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Specifies the database name which the table belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Output[str]:
        """
        Specifies date type. `yyyy-MM-dd` is used by default. Only
        data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter
    def delimiter(self) -> pulumi.Output[str]:
        """
        Specifies data delimiter. Only data in CSV files has this
        attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of column. Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="escapeChar")
    def escape_char(self) -> pulumi.Output[str]:
        """
        Specifies escape character. Backslashes (`\\\\`) are used by
        default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "escape_char")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of column. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="quoteChar")
    def quote_char(self) -> pulumi.Output[str]:
        """
        Specifies reference character. Double quotation marks (`\\`)
        are used by default. Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "quote_char")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the dli table resource. If omitted,
        the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> pulumi.Output[str]:
        """
        Specifies timestamp type. `yyyy-MM-dd HH:mm:ss` is used by default.
        Only data in CSV and JSON files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "timestamp_format")

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> pulumi.Output[bool]:
        """
        Specifies whether the table header is included in the data file.
        Only data in CSV files has this attribute. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "with_column_header")

