# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 cu_count: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_mode: Optional[pulumi.Input[int]] = None,
                 subnet_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
        :param pulumi.Input[str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
        """
        pulumi.set(__self__, "cu_count", cu_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if management_subnet_cidr is not None:
            warnings.warn("""management_subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""management_subnet_cidr is deprecated: management_subnet_cidr is Deprecated""")
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_mode is not None:
            pulumi.set(__self__, "resource_mode", resource_mode)
        if subnet_cidr is not None:
            warnings.warn("""subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""subnet_cidr is deprecated: subnet_cidr is Deprecated""")
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cidr is not None:
            pulumi.set(__self__, "vpc_cidr", vpc_cidr)

    @property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> pulumi.Input[int]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @cu_count.setter
    def cu_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "cu_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @resource_mode.setter
    def resource_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resource_mode", value)

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_cidr", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:
        """
        return pulumi.get(self, "vpc_cidr")

    @vpc_cidr.setter
    def vpc_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_cidr", value)


@pulumi.input_type
class _QueueState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[int]] = None,
                 cu_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_mode: Optional[pulumi.Input[int]] = None,
                 subnet_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Queue resources.
        :param pulumi.Input[int] create_time: Time when a queue is created.
        :param pulumi.Input[int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
        :param pulumi.Input[str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cu_count is not None:
            pulumi.set(__self__, "cu_count", cu_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if management_subnet_cidr is not None:
            warnings.warn("""management_subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""management_subnet_cidr is deprecated: management_subnet_cidr is Deprecated""")
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_mode is not None:
            pulumi.set(__self__, "resource_mode", resource_mode)
        if subnet_cidr is not None:
            warnings.warn("""subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""subnet_cidr is deprecated: subnet_cidr is Deprecated""")
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cidr is not None:
            pulumi.set(__self__, "vpc_cidr", vpc_cidr)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @cu_count.setter
    def cu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cu_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @resource_mode.setter
    def resource_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resource_mode", value)

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_cidr", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:
        """
        return pulumi.get(self, "vpc_cidr")

    @vpc_cidr.setter
    def vpc_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_cidr", value)


class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cu_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_mode: Optional[pulumi.Input[int]] = None,
                 subnet_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages DLI Queue resource within HuaweiCloud

        ## Example Usage
        ### Create a queue

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        queue = huaweicloud.dli.Queue("queue",
            cu_count=16,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a queue with CIDR Block

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        queue = huaweicloud.dli.Queue("queue",
            cu_count=16,
            resource_mode=1,
            tags={
                "foo": "bar",
                "key": "value",
            },
            vpc_cidr="172.16.0.0/14")
        ```

        ## Import

        DLI queue can be imported by

        `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/queue:Queue example abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
        :param pulumi.Input[str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI Queue resource within HuaweiCloud

        ## Example Usage
        ### Create a queue

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        queue = huaweicloud.dli.Queue("queue",
            cu_count=16,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```
        ### Create a queue with CIDR Block

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        queue = huaweicloud.dli.Queue("queue",
            cu_count=16,
            resource_mode=1,
            tags={
                "foo": "bar",
                "key": "value",
            },
            vpc_cidr="172.16.0.0/14")
        ```

        ## Import

        DLI queue can be imported by

        `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Dli/queue:Queue example abc123
        ```

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cu_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 feature: Optional[pulumi.Input[str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 queue_type: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_mode: Optional[pulumi.Input[int]] = None,
                 subnet_cidr: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            if cu_count is None and not opts.urn:
                raise TypeError("Missing required property 'cu_count'")
            __props__.__dict__["cu_count"] = cu_count
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["feature"] = feature
            if management_subnet_cidr is not None and not opts.urn:
                warnings.warn("""management_subnet_cidr is Deprecated""", DeprecationWarning)
                pulumi.log.warn("""management_subnet_cidr is deprecated: management_subnet_cidr is Deprecated""")
            __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
            __props__.__dict__["name"] = name
            __props__.__dict__["platform"] = platform
            __props__.__dict__["queue_type"] = queue_type
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_mode"] = resource_mode
            if subnet_cidr is not None and not opts.urn:
                warnings.warn("""subnet_cidr is Deprecated""", DeprecationWarning)
                pulumi.log.warn("""subnet_cidr is deprecated: subnet_cidr is Deprecated""")
            __props__.__dict__["subnet_cidr"] = subnet_cidr
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_cidr"] = vpc_cidr
            __props__.__dict__["create_time"] = None
        super(Queue, __self__).__init__(
            'huaweicloud:Dli/queue:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            cu_count: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            feature: Optional[pulumi.Input[str]] = None,
            management_subnet_cidr: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            queue_type: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            resource_mode: Optional[pulumi.Input[int]] = None,
            subnet_cidr: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_cidr: Optional[pulumi.Input[str]] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] create_time: Time when a queue is created.
        :param pulumi.Input[int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
        :param pulumi.Input[str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueState.__new__(_QueueState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cu_count"] = cu_count
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["feature"] = feature
        __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["queue_type"] = queue_type
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_mode"] = resource_mode
        __props__.__dict__["subnet_cidr"] = subnet_cidr
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_cidr"] = vpc_cidr
        return Queue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> pulumi.Output[int]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def feature(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general
        """
        return pulumi.get(self, "queue_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> pulumi.Output[Optional[int]]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "subnet_cidr")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> pulumi.Output[str]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:
        """
        return pulumi.get(self, "vpc_cidr")

