# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDataKeyResult',
    'AwaitableGetDataKeyResult',
    'get_data_key',
    'get_data_key_output',
]

@pulumi.output_type
class GetDataKeyResult:
    """
    A collection of values returned by getDataKey.
    """
    def __init__(__self__, cipher_text=None, datakey_length=None, encryption_context=None, id=None, key_id=None, plain_text=None, region=None):
        if cipher_text and not isinstance(cipher_text, str):
            raise TypeError("Expected argument 'cipher_text' to be a str")
        pulumi.set(__self__, "cipher_text", cipher_text)
        if datakey_length and not isinstance(datakey_length, str):
            raise TypeError("Expected argument 'datakey_length' to be a str")
        pulumi.set(__self__, "datakey_length", datakey_length)
        if encryption_context and not isinstance(encryption_context, str):
            raise TypeError("Expected argument 'encryption_context' to be a str")
        pulumi.set(__self__, "encryption_context", encryption_context)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if plain_text and not isinstance(plain_text, str):
            raise TypeError("Expected argument 'plain_text' to be a str")
        pulumi.set(__self__, "plain_text", plain_text)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="cipherText")
    def cipher_text(self) -> str:
        """
        The ciphertext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
        """
        return pulumi.get(self, "cipher_text")

    @property
    @pulumi.getter(name="datakeyLength")
    def datakey_length(self) -> str:
        return pulumi.get(self, "datakey_length")

    @property
    @pulumi.getter(name="encryptionContext")
    def encryption_context(self) -> Optional[str]:
        return pulumi.get(self, "encryption_context")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="plainText")
    def plain_text(self) -> str:
        """
        The plaintext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
        """
        return pulumi.get(self, "plain_text")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetDataKeyResult(GetDataKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataKeyResult(
            cipher_text=self.cipher_text,
            datakey_length=self.datakey_length,
            encryption_context=self.encryption_context,
            id=self.id,
            key_id=self.key_id,
            plain_text=self.plain_text,
            region=self.region)


def get_data_key(cipher_text: Optional[str] = None,
                 datakey_length: Optional[str] = None,
                 encryption_context: Optional[str] = None,
                 key_id: Optional[str] = None,
                 plain_text: Optional[str] = None,
                 region: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataKeyResult:
    """
    Use this data source to get the plaintext and the ciphertext of an available HuaweiCloud KMS DEK (data encryption key).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    key1 = huaweicloud.dew.Key("key1",
        key_alias="key_1",
        pending_days="7",
        key_description="first test key")
    kms_datakey1 = huaweicloud.Dew.get_data_key_output(key_id=key1.id,
        datakey_length="512")
    ```


    :param str cipher_text: The ciphertext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
    :param str datakey_length: Number of bits in the length of a DEK (data encryption keys). The maximum number
           is 512. Changing this gets the new data encryption key.
    :param str encryption_context: The value of this parameter must be a series of
           "key:value" pairs used to record resource context information. The value of this parameter must not contain sensitive
           information and must be within 8192 characters in length. Example: {"Key1":"Value1","Key2":"Value2"}
    :param str key_id: The globally unique identifier for the key. Changing this gets the new data encryption
           key.
    :param str plain_text: The plaintext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
    :param str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['cipherText'] = cipher_text
    __args__['datakeyLength'] = datakey_length
    __args__['encryptionContext'] = encryption_context
    __args__['keyId'] = key_id
    __args__['plainText'] = plain_text
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dew/getDataKey:getDataKey', __args__, opts=opts, typ=GetDataKeyResult).value

    return AwaitableGetDataKeyResult(
        cipher_text=__ret__.cipher_text,
        datakey_length=__ret__.datakey_length,
        encryption_context=__ret__.encryption_context,
        id=__ret__.id,
        key_id=__ret__.key_id,
        plain_text=__ret__.plain_text,
        region=__ret__.region)


@_utilities.lift_output_func(get_data_key)
def get_data_key_output(cipher_text: Optional[pulumi.Input[Optional[str]]] = None,
                        datakey_length: Optional[pulumi.Input[str]] = None,
                        encryption_context: Optional[pulumi.Input[Optional[str]]] = None,
                        key_id: Optional[pulumi.Input[str]] = None,
                        plain_text: Optional[pulumi.Input[Optional[str]]] = None,
                        region: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataKeyResult]:
    """
    Use this data source to get the plaintext and the ciphertext of an available HuaweiCloud KMS DEK (data encryption key).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    key1 = huaweicloud.dew.Key("key1",
        key_alias="key_1",
        pending_days="7",
        key_description="first test key")
    kms_datakey1 = huaweicloud.Dew.get_data_key_output(key_id=key1.id,
        datakey_length="512")
    ```


    :param str cipher_text: The ciphertext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
    :param str datakey_length: Number of bits in the length of a DEK (data encryption keys). The maximum number
           is 512. Changing this gets the new data encryption key.
    :param str encryption_context: The value of this parameter must be a series of
           "key:value" pairs used to record resource context information. The value of this parameter must not contain sensitive
           information and must be within 8192 characters in length. Example: {"Key1":"Value1","Key2":"Value2"}
    :param str key_id: The globally unique identifier for the key. Changing this gets the new data encryption
           key.
    :param str plain_text: The plaintext of a DEK is expressed in hexadecimal format, and two characters indicate one byte.
    :param str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    ...
