# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcChannelArgs', 'VpcChannel']

@pulumi.input_type
class VpcChannelArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 members: pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]],
                 port: pulumi.Input[int],
                 algorithm: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 http_code: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 member_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a VpcChannel resource.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the APIG
               vpc channel belongs to.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]] members: Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
               channel.
               The object structure is documented below.
        :param pulumi.Input[int] port: Specifies the host port of the VPC channel.
               The valid value is range from 1 to 65535.
        :param pulumi.Input[str] algorithm: Specifies the type of the backend service.
               The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        :param pulumi.Input[int] healthy_threshold: Specifies the healthy threshold, which refers to the number of consecutive
               successful checks required for a backend server to be considered healthy.
               The valid value is range from 2 to 10, default to 2.
        :param pulumi.Input[int] interval: Specifies the interval between consecutive checks, in second.
               The valid value is range from 5 to 300, default to 10.
        :param pulumi.Input[str] member_type: Specifies the type of the backend service.
               The valid types are *ECS* and *EIP*, default to *ECS*.
        :param pulumi.Input[str] name: Specifies the name of the VPC channel.
               The channel name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] path: Specifies the destination path for health checks.
               Required if `protocol` is *HTTP* or *HTTPS*.
        :param pulumi.Input[str] protocol: Specifies the protocol for performing health checks on backend servers in the VPC
               channel.
               The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC channel resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] timeout: Specifies the timeout for determining whether a health check fails, in second.
               The value must be less than the value of time_interval.
               The valid value is range from 2 to 30, default to 5.
        :param pulumi.Input[int] unhealthy_threshold: Specifies the unhealthy threshold, which refers to the number of consecutive
               failed checks required for a backend server to be considered unhealthy.
               The valid value is range from 2 to 10, default to 5.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "port", port)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http_code is not None:
            pulumi.set(__self__, "http_code", http_code)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the APIG
        vpc channel belongs to.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]]:
        """
        Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
        channel.
        The object structure is documented below.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the host port of the VPC channel.
        The valid value is range from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the healthy threshold, which refers to the number of consecutive
        successful checks required for a backend server to be considered healthy.
        The valid value is range from 2 to 10, default to 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_code")

    @http_code.setter
    def http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_code", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval between consecutive checks, in second.
        The valid value is range from 5 to 300, default to 10.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *ECS* and *EIP*, default to *ECS*.
        """
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the VPC channel.
        The channel name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination path for health checks.
        Required if `protocol` is *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol for performing health checks on backend servers in the VPC
        channel.
        The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the VPC channel resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout for determining whether a health check fails, in second.
        The value must be less than the value of time_interval.
        The valid value is range from 2 to 30, default to 5.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the unhealthy threshold, which refers to the number of consecutive
        failed checks required for a backend server to be considered unhealthy.
        The valid value is range from 2 to 10, default to 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class _VpcChannelState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 http_code: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 member_type: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering VpcChannel resources.
        :param pulumi.Input[str] algorithm: Specifies the type of the backend service.
               The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        :param pulumi.Input[str] create_time: Time when the channel created, in UTC format.
        :param pulumi.Input[int] healthy_threshold: Specifies the healthy threshold, which refers to the number of consecutive
               successful checks required for a backend server to be considered healthy.
               The valid value is range from 2 to 10, default to 2.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the APIG
               vpc channel belongs to.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] interval: Specifies the interval between consecutive checks, in second.
               The valid value is range from 5 to 300, default to 10.
        :param pulumi.Input[str] member_type: Specifies the type of the backend service.
               The valid types are *ECS* and *EIP*, default to *ECS*.
        :param pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]] members: Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
               channel.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the VPC channel.
               The channel name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] path: Specifies the destination path for health checks.
               Required if `protocol` is *HTTP* or *HTTPS*.
        :param pulumi.Input[int] port: Specifies the host port of the VPC channel.
               The valid value is range from 1 to 65535.
        :param pulumi.Input[str] protocol: Specifies the protocol for performing health checks on backend servers in the VPC
               channel.
               The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC channel resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[str] status: The status of VPC channel, supports *Normal* and *Abnormal*.
        :param pulumi.Input[int] timeout: Specifies the timeout for determining whether a health check fails, in second.
               The value must be less than the value of time_interval.
               The valid value is range from 2 to 30, default to 5.
        :param pulumi.Input[int] unhealthy_threshold: Specifies the unhealthy threshold, which refers to the number of consecutive
               failed checks required for a backend server to be considered unhealthy.
               The valid value is range from 2 to 10, default to 5.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http_code is not None:
            pulumi.set(__self__, "http_code", http_code)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the channel created, in UTC format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the healthy threshold, which refers to the number of consecutive
        successful checks required for a backend server to be considered healthy.
        The valid value is range from 2 to 10, default to 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_code")

    @http_code.setter
    def http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_code", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG dedicated instance to which the APIG
        vpc channel belongs to.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval between consecutive checks, in second.
        The valid value is range from 5 to 300, default to 10.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *ECS* and *EIP*, default to *ECS*.
        """
        return pulumi.get(self, "member_type")

    @member_type.setter
    def member_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "member_type", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]]]:
        """
        Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
        channel.
        The object structure is documented below.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcChannelMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the VPC channel.
        The channel name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the destination path for health checks.
        Required if `protocol` is *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the host port of the VPC channel.
        The valid value is range from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol for performing health checks on backend servers in the VPC
        channel.
        The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the VPC channel resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of VPC channel, supports *Normal* and *Abnormal*.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the timeout for determining whether a health check fails, in second.
        The value must be less than the value of time_interval.
        The valid value is range from 2 to 30, default to 5.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the unhealthy threshold, which refers to the number of consecutive
        failed checks required for a backend server to be considered unhealthy.
        The valid value is range from 2 to 10, default to 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


class VpcChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 http_code: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 member_type: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcChannelMemberArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a VPC channel resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        channel_name = config.require_object("channelName")
        ecs_id1 = config.require_object("ecsId1")
        ecs_id2 = config.require_object("ecsId2")
        test = huaweicloud.dedicated_apig.VpcChannel("test",
            instance_id=instance_id,
            port=8080,
            protocol="HTTPS",
            path="/",
            http_code="201,202,203",
            members=[
                huaweicloud.dedicated_apig.VpcChannelMemberArgs(
                    id=ecs_id1,
                    weight=30,
                ),
                huaweicloud.dedicated_apig.VpcChannelMemberArgs(
                    id=ecs_id2,
                    weight=70,
                ),
            ])
        ```

        ## Import

        VPC Channels can be imported using their `name` and ID of the APIG dedicated instance to which the channel belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/vpcChannel:VpcChannel test <instance id>/<channel name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Specifies the type of the backend service.
               The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        :param pulumi.Input[int] healthy_threshold: Specifies the healthy threshold, which refers to the number of consecutive
               successful checks required for a backend server to be considered healthy.
               The valid value is range from 2 to 10, default to 2.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the APIG
               vpc channel belongs to.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] interval: Specifies the interval between consecutive checks, in second.
               The valid value is range from 5 to 300, default to 10.
        :param pulumi.Input[str] member_type: Specifies the type of the backend service.
               The valid types are *ECS* and *EIP*, default to *ECS*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcChannelMemberArgs']]]] members: Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
               channel.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the VPC channel.
               The channel name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] path: Specifies the destination path for health checks.
               Required if `protocol` is *HTTP* or *HTTPS*.
        :param pulumi.Input[int] port: Specifies the host port of the VPC channel.
               The valid value is range from 1 to 65535.
        :param pulumi.Input[str] protocol: Specifies the protocol for performing health checks on backend servers in the VPC
               channel.
               The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC channel resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] timeout: Specifies the timeout for determining whether a health check fails, in second.
               The value must be less than the value of time_interval.
               The valid value is range from 2 to 30, default to 5.
        :param pulumi.Input[int] unhealthy_threshold: Specifies the unhealthy threshold, which refers to the number of consecutive
               failed checks required for a backend server to be considered unhealthy.
               The valid value is range from 2 to 10, default to 5.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC channel resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        channel_name = config.require_object("channelName")
        ecs_id1 = config.require_object("ecsId1")
        ecs_id2 = config.require_object("ecsId2")
        test = huaweicloud.dedicated_apig.VpcChannel("test",
            instance_id=instance_id,
            port=8080,
            protocol="HTTPS",
            path="/",
            http_code="201,202,203",
            members=[
                huaweicloud.dedicated_apig.VpcChannelMemberArgs(
                    id=ecs_id1,
                    weight=30,
                ),
                huaweicloud.dedicated_apig.VpcChannelMemberArgs(
                    id=ecs_id2,
                    weight=70,
                ),
            ])
        ```

        ## Import

        VPC Channels can be imported using their `name` and ID of the APIG dedicated instance to which the channel belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/vpcChannel:VpcChannel test <instance id>/<channel name>
        ```

        :param str resource_name: The name of the resource.
        :param VpcChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 http_code: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 member_type: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcChannelMemberArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcChannelArgs.__new__(VpcChannelArgs)

            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["http_code"] = http_code
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["interval"] = interval
            __props__.__dict__["member_type"] = member_type
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            __props__.__dict__["path"] = path
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(VpcChannel, __self__).__init__(
            'huaweicloud:DedicatedApig/vpcChannel:VpcChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            healthy_threshold: Optional[pulumi.Input[int]] = None,
            http_code: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            interval: Optional[pulumi.Input[int]] = None,
            member_type: Optional[pulumi.Input[str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcChannelMemberArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            unhealthy_threshold: Optional[pulumi.Input[int]] = None) -> 'VpcChannel':
        """
        Get an existing VpcChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: Specifies the type of the backend service.
               The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        :param pulumi.Input[str] create_time: Time when the channel created, in UTC format.
        :param pulumi.Input[int] healthy_threshold: Specifies the healthy threshold, which refers to the number of consecutive
               successful checks required for a backend server to be considered healthy.
               The valid value is range from 2 to 10, default to 2.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the APIG
               vpc channel belongs to.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[int] interval: Specifies the interval between consecutive checks, in second.
               The valid value is range from 5 to 300, default to 10.
        :param pulumi.Input[str] member_type: Specifies the type of the backend service.
               The valid types are *ECS* and *EIP*, default to *ECS*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcChannelMemberArgs']]]] members: Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
               channel.
               The object structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of the VPC channel.
               The channel name consists of 3 to 64 characters, starting with a letter.
               Only letters, digits and underscores (_) are allowed.
               Chinese characters must be in UTF-8 or Unicode format.
        :param pulumi.Input[str] path: Specifies the destination path for health checks.
               Required if `protocol` is *HTTP* or *HTTPS*.
        :param pulumi.Input[int] port: Specifies the host port of the VPC channel.
               The valid value is range from 1 to 65535.
        :param pulumi.Input[str] protocol: Specifies the protocol for performing health checks on backend servers in the VPC
               channel.
               The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        :param pulumi.Input[str] region: Specifies the region in which to create the VPC channel resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new VPC channel resource.
        :param pulumi.Input[str] status: The status of VPC channel, supports *Normal* and *Abnormal*.
        :param pulumi.Input[int] timeout: Specifies the timeout for determining whether a health check fails, in second.
               The value must be less than the value of time_interval.
               The valid value is range from 2 to 30, default to 5.
        :param pulumi.Input[int] unhealthy_threshold: Specifies the unhealthy threshold, which refers to the number of consecutive
               failed checks required for a backend server to be considered unhealthy.
               The valid value is range from 2 to 10, default to 5.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcChannelState.__new__(_VpcChannelState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["http_code"] = http_code
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["interval"] = interval
        __props__.__dict__["member_type"] = member_type
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        return VpcChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *WRR*, *WLC*, *SH* and *URI hashing*, default to *WRR*.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the channel created, in UTC format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the healthy threshold, which refers to the number of consecutive
        successful checks required for a backend server to be considered healthy.
        The valid value is range from 2 to 10, default to 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "http_code")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the APIG
        vpc channel belongs to.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the interval between consecutive checks, in second.
        The valid value is range from 5 to 300, default to 10.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the backend service.
        The valid types are *ECS* and *EIP*, default to *ECS*.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.VpcChannelMember']]:
        """
        Specifies an array of one or more backend server IDs or IP addresses that bind the VPC
        channel.
        The object structure is documented below.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the VPC channel.
        The channel name consists of 3 to 64 characters, starting with a letter.
        Only letters, digits and underscores (_) are allowed.
        Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the destination path for health checks.
        Required if `protocol` is *HTTP* or *HTTPS*.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Specifies the host port of the VPC channel.
        The valid value is range from 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the protocol for performing health checks on backend servers in the VPC
        channel.
        The valid values are *TCP*, *HTTP* and *HTTPS*, default to *TCP*.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the VPC channel resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of VPC channel, supports *Normal* and *Abnormal*.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the timeout for determining whether a health check fails, in second.
        The value must be less than the value of time_interval.
        The valid value is range from 2 to 30, default to 5.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the unhealthy threshold, which refers to the number of consecutive
        failed checks required for a backend server to be considered unhealthy.
        The valid value is range from 2 to 10, default to 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

