# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 available_zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 edition: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: Specifies an array of available zone names for the APIG dedicated
               instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] edition: Specifies the edition of the APIG dedicated instance. The supported editions
               are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
               resource.
        :param pulumi.Input[str] security_group_id: Specifies an ID of the security group to which the APIG dedicated instance
               belongs to.
        :param pulumi.Input[str] subnet_id: Specifies an ID of the VPC subnet used to create the APIG dedicated
               instance. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] vpc_id: Specifies an ID of the VPC used to create the APIG dedicated instance.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the egress bandwidth size of the APIG dedicated instance. The range of
               valid value is from 1 to 2000.
        :param pulumi.Input[str] description: Specifies the description about the APIG dedicated instance. The description
               contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] eip_id: Specifies the eip ID associated with the APIG dedicated instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies an enterprise project ID. This parameter is required
               for enterprise users. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] maintain_begin: Specifies a start time of the maintenance time window in the format 'xx:00:00'.
               The value of xx can be 02, 06, 10, 14, 18 or 22.
        :param pulumi.Input[str] name: Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
               characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the APIG dedicated instance resource.
               If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        """
        pulumi.set(__self__, "available_zones", available_zones)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies an array of available zone names for the APIG dedicated
        instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Input[str]:
        """
        Specifies the edition of the APIG dedicated instance. The supported editions
        are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
        resource.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[str]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the security group to which the APIG dedicated instance
        belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the VPC subnet used to create the APIG dedicated
        instance. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the VPC used to create the APIG dedicated instance.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the egress bandwidth size of the APIG dedicated instance. The range of
        valid value is from 1 to 2000.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the APIG dedicated instance. The description
        contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the eip ID associated with the APIG dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an enterprise project ID. This parameter is required
        for enterprise users. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a start time of the maintenance time window in the format 'xx:00:00'.
        The value of xx can be 02, 06, 10, 14, 18 or 22.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
        characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the APIG dedicated instance resource.
        If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 egress_address: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ingress_address: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 maintain_end: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 supported_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpc_ingress_address: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: Specifies an array of available zone names for the APIG dedicated
               instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the egress bandwidth size of the APIG dedicated instance. The range of
               valid value is from 1 to 2000.
        :param pulumi.Input[str] create_time: Time when the APIG instance is created, in RFC-3339 format.
        :param pulumi.Input[str] description: Specifies the description about the APIG dedicated instance. The description
               contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] edition: Specifies the edition of the APIG dedicated instance. The supported editions
               are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
               resource.
        :param pulumi.Input[str] egress_address: The egress (nat) public ip address.
        :param pulumi.Input[str] eip_id: Specifies the eip ID associated with the APIG dedicated instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies an enterprise project ID. This parameter is required
               for enterprise users. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] ingress_address: The ingress eip address.
        :param pulumi.Input[str] maintain_begin: Specifies a start time of the maintenance time window in the format 'xx:00:00'.
               The value of xx can be 02, 06, 10, 14, 18 or 22.
        :param pulumi.Input[str] maintain_end: End time of the maintenance time window, 4-hour difference between the start time and end time.
        :param pulumi.Input[str] name: Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
               characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the APIG dedicated instance resource.
               If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] security_group_id: Specifies an ID of the security group to which the APIG dedicated instance
               belongs to.
        :param pulumi.Input[str] status: Status of the APIG dedicated instance.
        :param pulumi.Input[str] subnet_id: Specifies an ID of the VPC subnet used to create the APIG dedicated
               instance. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_features: The supported features of the APIG dedicated instance.
        :param pulumi.Input[str] vpc_id: Specifies an ID of the VPC used to create the APIG dedicated instance.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] vpc_ingress_address: The ingress private ip address of vpc.
        """
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if egress_address is not None:
            pulumi.set(__self__, "egress_address", egress_address)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ingress_address is not None:
            pulumi.set(__self__, "ingress_address", ingress_address)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if supported_features is not None:
            pulumi.set(__self__, "supported_features", supported_features)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_ingress_address is not None:
            pulumi.set(__self__, "vpc_ingress_address", vpc_ingress_address)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of available zone names for the APIG dedicated
        instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_zones", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the egress bandwidth size of the APIG dedicated instance. The range of
        valid value is from 1 to 2000.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the APIG instance is created, in RFC-3339 format.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the APIG dedicated instance. The description
        contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the edition of the APIG dedicated instance. The supported editions
        are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
        resource.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> Optional[pulumi.Input[str]]:
        """
        The egress (nat) public ip address.
        """
        return pulumi.get(self, "egress_address")

    @egress_address.setter
    def egress_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_address", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the eip ID associated with the APIG dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an enterprise project ID. This parameter is required
        for enterprise users. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress eip address.
        """
        return pulumi.get(self, "ingress_address")

    @ingress_address.setter
    def ingress_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_address", value)

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a start time of the maintenance time window in the format 'xx:00:00'.
        The value of xx can be 02, 06, 10, 14, 18 or 22.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_begin", value)

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[str]]:
        """
        End time of the maintenance time window, 4-hour difference between the start time and end time.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintain_end", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
        characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the APIG dedicated instance resource.
        If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the security group to which the APIG dedicated instance
        belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the APIG dedicated instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the VPC subnet used to create the APIG dedicated
        instance. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="supportedFeatures")
    def supported_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The supported features of the APIG dedicated instance.
        """
        return pulumi.get(self, "supported_features")

    @supported_features.setter
    def supported_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_features", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the VPC used to create the APIG dedicated instance.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcIngressAddress")
    def vpc_ingress_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress private ip address of vpc.
        """
        return pulumi.get(self, "vpc_ingress_address")

    @vpc_ingress_address.setter
    def vpc_ingress_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_ingress_address", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an APIG dedicated instance resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_name = config.require_object("instanceName")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        eip_id = config.require_object("eipId")
        enterprise_project_id = config.require_object("enterpriseProjectId")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_instance = huaweicloud.dedicated_apig.Instance("testInstance",
            edition="BASIC",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            enterprise_project_id=enterprise_project_id,
            maintain_begin="06:00:00",
            description="Created by script",
            bandwidth_size=3,
            eip_id=eip_id,
            available_zones=[
                test_availability_zones.names[0],
                test_availability_zones.names[1],
            ])
        ```

        ## Import

        APIG Dedicated Instances can be imported by their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/instance:Instance test de379eed30aa4d31a84f426ea3c7ef4e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: Specifies an array of available zone names for the APIG dedicated
               instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the egress bandwidth size of the APIG dedicated instance. The range of
               valid value is from 1 to 2000.
        :param pulumi.Input[str] description: Specifies the description about the APIG dedicated instance. The description
               contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] edition: Specifies the edition of the APIG dedicated instance. The supported editions
               are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
               resource.
        :param pulumi.Input[str] eip_id: Specifies the eip ID associated with the APIG dedicated instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies an enterprise project ID. This parameter is required
               for enterprise users. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] maintain_begin: Specifies a start time of the maintenance time window in the format 'xx:00:00'.
               The value of xx can be 02, 06, 10, 14, 18 or 22.
        :param pulumi.Input[str] name: Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
               characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the APIG dedicated instance resource.
               If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] security_group_id: Specifies an ID of the security group to which the APIG dedicated instance
               belongs to.
        :param pulumi.Input[str] subnet_id: Specifies an ID of the VPC subnet used to create the APIG dedicated
               instance. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] vpc_id: Specifies an ID of the VPC used to create the APIG dedicated instance.
               Changing this will create a new APIG dedicated instance resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an APIG dedicated instance resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_name = config.require_object("instanceName")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        eip_id = config.require_object("eipId")
        enterprise_project_id = config.require_object("enterpriseProjectId")
        test_availability_zones = huaweicloud.get_availability_zones()
        test_instance = huaweicloud.dedicated_apig.Instance("testInstance",
            edition="BASIC",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            enterprise_project_id=enterprise_project_id,
            maintain_begin="06:00:00",
            description="Created by script",
            bandwidth_size=3,
            eip_id=eip_id,
            available_zones=[
                test_availability_zones.names[0],
                test_availability_zones.names[1],
            ])
        ```

        ## Import

        APIG Dedicated Instances can be imported by their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/instance:Instance test de379eed30aa4d31a84f426ea3c7ef4e
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 maintain_begin: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if available_zones is None and not opts.urn:
                raise TypeError("Missing required property 'available_zones'")
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            __props__.__dict__["description"] = description
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["egress_address"] = None
            __props__.__dict__["ingress_address"] = None
            __props__.__dict__["maintain_end"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["supported_features"] = None
            __props__.__dict__["vpc_ingress_address"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:DedicatedApig/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bandwidth_size: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            edition: Optional[pulumi.Input[str]] = None,
            egress_address: Optional[pulumi.Input[str]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            ingress_address: Optional[pulumi.Input[str]] = None,
            maintain_begin: Optional[pulumi.Input[str]] = None,
            maintain_end: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            supported_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpc_ingress_address: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_zones: Specifies an array of available zone names for the APIG dedicated
               instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the egress bandwidth size of the APIG dedicated instance. The range of
               valid value is from 1 to 2000.
        :param pulumi.Input[str] create_time: Time when the APIG instance is created, in RFC-3339 format.
        :param pulumi.Input[str] description: Specifies the description about the APIG dedicated instance. The description
               contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        :param pulumi.Input[str] edition: Specifies the edition of the APIG dedicated instance. The supported editions
               are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
               resource.
        :param pulumi.Input[str] egress_address: The egress (nat) public ip address.
        :param pulumi.Input[str] eip_id: Specifies the eip ID associated with the APIG dedicated instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies an enterprise project ID. This parameter is required
               for enterprise users. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] ingress_address: The ingress eip address.
        :param pulumi.Input[str] maintain_begin: Specifies a start time of the maintenance time window in the format 'xx:00:00'.
               The value of xx can be 02, 06, 10, 14, 18 or 22.
        :param pulumi.Input[str] maintain_end: End time of the maintenance time window, 4-hour difference between the start time and end time.
        :param pulumi.Input[str] name: Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
               characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        :param pulumi.Input[str] region: Specifies the region in which to create the APIG dedicated instance resource.
               If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] security_group_id: Specifies an ID of the security group to which the APIG dedicated instance
               belongs to.
        :param pulumi.Input[str] status: Status of the APIG dedicated instance.
        :param pulumi.Input[str] subnet_id: Specifies an ID of the VPC subnet used to create the APIG dedicated
               instance. Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_features: The supported features of the APIG dedicated instance.
        :param pulumi.Input[str] vpc_id: Specifies an ID of the VPC used to create the APIG dedicated instance.
               Changing this will create a new APIG dedicated instance resource.
        :param pulumi.Input[str] vpc_ingress_address: The ingress private ip address of vpc.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["edition"] = edition
        __props__.__dict__["egress_address"] = egress_address
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ingress_address"] = ingress_address
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["supported_features"] = supported_features
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_ingress_address"] = vpc_ingress_address
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of available zone names for the APIG dedicated
        instance. Please following [reference](https://developer.huaweicloud.com/intl/en-us/endpoint?APIG) for list elements.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the egress bandwidth size of the APIG dedicated instance. The range of
        valid value is from 1 to 2000.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the APIG instance is created, in RFC-3339 format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description about the APIG dedicated instance. The description
        contain a maximum of 255 characters and the angle brackets (< and >) are not allowed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[str]:
        """
        Specifies the edition of the APIG dedicated instance. The supported editions
        are as follows: BASIC, PROFESSIONAL, ENTERPRISE, PLATINUM. Changing this will create a new APIG dedicated instance
        resource.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> pulumi.Output[str]:
        """
        The egress (nat) public ip address.
        """
        return pulumi.get(self, "egress_address")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the eip ID associated with the APIG dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies an enterprise project ID. This parameter is required
        for enterprise users. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> pulumi.Output[str]:
        """
        The ingress eip address.
        """
        return pulumi.get(self, "ingress_address")

    @property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[str]:
        """
        Specifies a start time of the maintenance time window in the format 'xx:00:00'.
        The value of xx can be 02, 06, 10, 14, 18 or 22.
        """
        return pulumi.get(self, "maintain_begin")

    @property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[str]:
        """
        End time of the maintenance time window, 4-hour difference between the start time and end time.
        """
        return pulumi.get(self, "maintain_end")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the API dedicated instance. The API group name consists of 3 to 64
        characters, starting with a letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the APIG dedicated instance resource.
        If omitted, the provider-level region will be used. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the security group to which the APIG dedicated instance
        belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the APIG dedicated instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the VPC subnet used to create the APIG dedicated
        instance. Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="supportedFeatures")
    def supported_features(self) -> pulumi.Output[Sequence[str]]:
        """
        The supported features of the APIG dedicated instance.
        """
        return pulumi.get(self, "supported_features")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the VPC used to create the APIG dedicated instance.
        Changing this will create a new APIG dedicated instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcIngressAddress")
    def vpc_ingress_address(self) -> pulumi.Output[str]:
        """
        The ingress private ip address of vpc.
        """
        return pulumi.get(self, "vpc_ingress_address")

