# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseUserArgs', 'DatabaseUser']

@pulumi.input_type
class DatabaseUserArgs:
    def __init__(__self__, *,
                 db_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 password: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseUser resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the user belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] password: Specifies the user password.
               The assword content must meet the following conditions:
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]] roles: Specifies the list of roles owned by the current user.
               The object structure is documented below. Changing this parameter will create a new user.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current user.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new user.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new user.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "roles", roles)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[str]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the DDS instance ID to which the user belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the user password.
        The assword content must meet the following conditions:
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]:
        """
        Specifies the list of roles owned by the current user.
        The object structure is documented below. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of role owned by the current user.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseUserState:
    def __init__(__self__, *,
                 db_name: Optional[pulumi.Input[str]] = None,
                 inherited_privileges: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserInheritedPrivilegeArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserPrivilegeArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering DatabaseUser resources.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserInheritedPrivilegeArgs']]] inherited_privileges: The list of database privileges owned by the current user, includes all privileges
               inherited by owned roles. The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the user belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current user.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new user.
        :param pulumi.Input[str] password: Specifies the user password.
               The assword content must meet the following conditions:
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserPrivilegeArgs']]] privileges: The list of database privileges owned by the current user.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new user.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]] roles: Specifies the list of roles owned by the current user.
               The object structure is documented below. Changing this parameter will create a new user.
        """
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if inherited_privileges is not None:
            pulumi.set(__self__, "inherited_privileges", inherited_privileges)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="inheritedPrivileges")
    def inherited_privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserInheritedPrivilegeArgs']]]]:
        """
        The list of database privileges owned by the current user, includes all privileges
        inherited by owned roles. The object structure is documented below.
        """
        return pulumi.get(self, "inherited_privileges")

    @inherited_privileges.setter
    def inherited_privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserInheritedPrivilegeArgs']]]]):
        pulumi.set(self, "inherited_privileges", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DDS instance ID to which the user belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of role owned by the current user.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        The assword content must meet the following conditions:
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserPrivilegeArgs']]]]:
        """
        The list of database privileges owned by the current user.
        The object structure is documented below.
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserPrivilegeArgs']]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]:
        """
        Specifies the list of roles owned by the current user.
        The object structure is documented below. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)


class DatabaseUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None,
                 __props__=None):
        """
        Manages a database user resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        owned_role_name = config.require_object("ownedRoleName")
        owned_role_db_name = config.require_object("ownedRoleDbName")
        test = huaweicloud.dds.DatabaseUser("test",
            instance_id=instance_id,
            password=user_password,
            db_name=var["db_name"],
            roles=[huaweicloud.dds.DatabaseUserRoleArgs(
                name=owned_role_name,
                db_name=owned_role_db_name,
            )])
        ```

        ## Import

        Database users can be imported using their `id` (combination of `instance_id`, `db_name` and `name`), separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/databaseUser:DatabaseUser test &ltinstance_id&gt/&ltdb_name&gt/&ltname&gt
        ```

         Due to security reason, the imported state may not be identical to your resource definition (`password` parameter). It is generally recommended running `terraform plan` after importing a user resource. You can then decide if changes should be applied to the user, or the resource definition should be updated to align with the user. Also you can ignore changes as below. resource "huaweicloud_dds_database_user" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the user belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current user.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new user.
        :param pulumi.Input[str] password: Specifies the user password.
               The assword content must meet the following conditions:
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]] roles: Specifies the list of roles owned by the current user.
               The object structure is documented below. Changing this parameter will create a new user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a database user resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        owned_role_name = config.require_object("ownedRoleName")
        owned_role_db_name = config.require_object("ownedRoleDbName")
        test = huaweicloud.dds.DatabaseUser("test",
            instance_id=instance_id,
            password=user_password,
            db_name=var["db_name"],
            roles=[huaweicloud.dds.DatabaseUserRoleArgs(
                name=owned_role_name,
                db_name=owned_role_db_name,
            )])
        ```

        ## Import

        Database users can be imported using their `id` (combination of `instance_id`, `db_name` and `name`), separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/databaseUser:DatabaseUser test &ltinstance_id&gt/&ltdb_name&gt/&ltname&gt
        ```

         Due to security reason, the imported state may not be identical to your resource definition (`password` parameter). It is generally recommended running `terraform plan` after importing a user resource. You can then decide if changes should be applied to the user, or the resource definition should be updated to align with the user. Also you can ignore changes as below. resource "huaweicloud_dds_database_user" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DatabaseUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseUserArgs.__new__(DatabaseUserArgs)

            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["region"] = region
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            __props__.__dict__["inherited_privileges"] = None
            __props__.__dict__["privileges"] = None
        super(DatabaseUser, __self__).__init__(
            'huaweicloud:Dds/databaseUser:DatabaseUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            inherited_privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserInheritedPrivilegeArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserPrivilegeArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None) -> 'DatabaseUser':
        """
        Get an existing DatabaseUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name to which this owned role belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserInheritedPrivilegeArgs']]]] inherited_privileges: The list of database privileges owned by the current user, includes all privileges
               inherited by owned roles. The object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies the DDS instance ID to which the user belongs.
               Changing this parameter will create a new user.
        :param pulumi.Input[str] name: Specifies the name of role owned by the current user.
               The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
               allowed. Changing this parameter will create a new user.
        :param pulumi.Input[str] password: Specifies the user password.
               The assword content must meet the following conditions:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserPrivilegeArgs']]]] privileges: The list of database privileges owned by the current user.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region where the DDS instance is located.
               Changing this parameter will create a new user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]] roles: Specifies the list of roles owned by the current user.
               The object structure is documented below. Changing this parameter will create a new user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseUserState.__new__(_DatabaseUserState)

        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["inherited_privileges"] = inherited_privileges
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["region"] = region
        __props__.__dict__["roles"] = roles
        return DatabaseUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        Specifies the database name to which this owned role belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="inheritedPrivileges")
    def inherited_privileges(self) -> pulumi.Output[Sequence['outputs.DatabaseUserInheritedPrivilege']]:
        """
        The list of database privileges owned by the current user, includes all privileges
        inherited by owned roles. The object structure is documented below.
        """
        return pulumi.get(self, "inherited_privileges")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the DDS instance ID to which the user belongs.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of role owned by the current user.
        The name can contain `1` to `64` characters, only letters, digits, underscores (_), hyphens (-) and dots (.) are
        allowed. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the user password.
        The assword content must meet the following conditions:
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Sequence['outputs.DatabaseUserPrivilege']]:
        """
        The list of database privileges owned by the current user.
        The object structure is documented below.
        """
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the DDS instance is located.
        Changing this parameter will create a new user.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.DatabaseUserRole']]:
        """
        Specifies the list of roles owned by the current user.
        The object structure is documented below. Changing this parameter will create a new user.
        """
        return pulumi.get(self, "roles")

