# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[str] cluster_id: Specifies ID of the CSS cluster where index data is to be backed up.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of a snapshot. The value contains 0 to 256
               characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] index: Specifies the name of the index to be backed up. Multiple index names are
               separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
               certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
               backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
               including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the snapshot name. The snapshot name must start with a letter and
               contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
               this parameter will create a new resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies ID of the CSS cluster where index data is to be backed up.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of a snapshot. The value contains 0 to 256
        characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the index to be backed up. Multiple index names are
        separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
        certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
        backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
        including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the snapshot name. The snapshot name must start with a letter and
        contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[str] backup_type: Indicates the snapshot creation mode, the value should be "manual" or "automated".
        :param pulumi.Input[str] cluster_id: Specifies ID of the CSS cluster where index data is to be backed up.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] cluster_name: Indicates the CSS cluster name.
        :param pulumi.Input[str] description: Specifies the description of a snapshot. The value contains 0 to 256
               characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] index: Specifies the name of the index to be backed up. Multiple index names are
               separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
               certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
               backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
               including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the snapshot name. The snapshot name must start with a letter and
               contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the snapshot status.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the snapshot creation mode, the value should be "manual" or "automated".
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies ID of the CSS cluster where index data is to be backed up.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the CSS cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of a snapshot. The value contains 0 to 256
        characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the index to be backed up. Multiple index names are
        separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
        certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
        backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
        including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the snapshot name. The snapshot name must start with a letter and
        contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the snapshot status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        CSS cluster snapshot management

        ## Example Usage
        ### Create a snapshot

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snapshot = huaweicloud.css.Snapshot("snapshot",
            description="a snapshot created by manual",
            cluster_id=var["css_cluster_id"])
        ```

        ## Import

        This resource can be imported by specifying the CSS cluster ID and snapshot ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Css/snapshot:Snapshot snapshot_1 < cluster_id >/< snapshot_id >
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies ID of the CSS cluster where index data is to be backed up.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of a snapshot. The value contains 0 to 256
               characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] index: Specifies the name of the index to be backed up. Multiple index names are
               separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
               certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
               backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
               including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the snapshot name. The snapshot name must start with a letter and
               contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
               this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CSS cluster snapshot management

        ## Example Usage
        ### Create a snapshot

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        snapshot = huaweicloud.css.Snapshot("snapshot",
            description="a snapshot created by manual",
            cluster_id=var["css_cluster_id"])
        ```

        ## Import

        This resource can be imported by specifying the CSS cluster ID and snapshot ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Css/snapshot:Snapshot snapshot_1 < cluster_id >/< snapshot_id >
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["description"] = description
            __props__.__dict__["index"] = index
            __props__.__dict__["name"] = name
            __props__.__dict__["backup_type"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["status"] = None
        super(Snapshot, __self__).__init__(
            'huaweicloud:Css/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_type: Indicates the snapshot creation mode, the value should be "manual" or "automated".
        :param pulumi.Input[str] cluster_id: Specifies ID of the CSS cluster where index data is to be backed up.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] cluster_name: Indicates the CSS cluster name.
        :param pulumi.Input[str] description: Specifies the description of a snapshot. The value contains 0 to 256
               characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] index: Specifies the name of the index to be backed up. Multiple index names are
               separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
               certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
               backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
               including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the snapshot name. The snapshot name must start with a letter and
               contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
               this parameter will create a new resource.
        :param pulumi.Input[str] status: Indicates the snapshot status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["description"] = description
        __props__.__dict__["index"] = index
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[str]:
        """
        Indicates the snapshot creation mode, the value should be "manual" or "automated".
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies ID of the CSS cluster where index data is to be backed up.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Indicates the CSS cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of a snapshot. The value contains 0 to 256
        characters, and angle brackets (<) and (>) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        Specifies the name of the index to be backed up. Multiple index names are
        separated by commas (,). By default, data of all indices is backed up. You can use the asterisk (*) to back up data of
        certain indices. For example, if you enter 2020-06*, then data of indices with the name prefix of 2020-06 will be
        backed up. The value contains 0 to 1024 characters. Uppercase letters, spaces, and certain special characters (
        including "\\\\<|>/?) are not allowed. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the snapshot name. The snapshot name must start with a letter and
        contains 4 to 64 characters consisting of only lowercase letters, digits, hyphens (-), and underscores (_). Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the snapshot status.
        """
        return pulumi.get(self, "status")

