# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterBackupStrategy',
    'ClusterClientNodeConfig',
    'ClusterClientNodeConfigVolume',
    'ClusterColdNodeConfig',
    'ClusterColdNodeConfigVolume',
    'ClusterEssNodeConfig',
    'ClusterEssNodeConfigVolume',
    'ClusterKibanaPublicAccess',
    'ClusterMasterNodeConfig',
    'ClusterMasterNodeConfigVolume',
    'ClusterNode',
    'ClusterNodeConfig',
    'ClusterNodeConfigNetworkInfo',
    'ClusterNodeConfigVolume',
    'ClusterPublicAccess',
    'ClusterVpcepEndpoint',
    'GetFlavorsFlavorResult',
]

@pulumi.output_type
class ClusterBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "backupPath":
            suggest = "backup_path"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 agency: Optional[str] = None,
                 backup_path: Optional[str] = None,
                 bucket: Optional[str] = None,
                 keep_days: Optional[int] = None,
                 prefix: Optional[str] = None):
        """
        :param str start_time: Specifies the time when a snapshot is automatically created everyday. Snapshots can
               only be created on the hour. The time format is the time followed by the time zone, specifically, **HH:mm z**. In the
               format, HH:mm refers to the hour time and z refers to the time zone. For example, "00:00 GMT+08:00"
               and "01:00 GMT+08:00".
        :param str agency: Specifies the IAM agency used to access OBS.
        :param str backup_path: Specifies the storage path of the snapshot in the OBS bucket.
        :param str bucket: Specifies the OBS bucket used for index data backup. If there is snapshot data in an OBS
               bucket, only the OBS bucket is used and cannot be changed.
        :param int keep_days: Specifies the number of days to retain the generated snapshots. Snapshots are reserved
               for seven days by default.
        :param str prefix: Specifies the prefix of the snapshot that is automatically created. The default value
               is "snapshot".
        """
        pulumi.set(__self__, "start_time", start_time)
        if agency is not None:
            pulumi.set(__self__, "agency", agency)
        if backup_path is not None:
            pulumi.set(__self__, "backup_path", backup_path)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the time when a snapshot is automatically created everyday. Snapshots can
        only be created on the hour. The time format is the time followed by the time zone, specifically, **HH:mm z**. In the
        format, HH:mm refers to the hour time and z refers to the time zone. For example, "00:00 GMT+08:00"
        and "01:00 GMT+08:00".
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def agency(self) -> Optional[str]:
        """
        Specifies the IAM agency used to access OBS.
        """
        return pulumi.get(self, "agency")

    @property
    @pulumi.getter(name="backupPath")
    def backup_path(self) -> Optional[str]:
        """
        Specifies the storage path of the snapshot in the OBS bucket.
        """
        return pulumi.get(self, "backup_path")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Specifies the OBS bucket used for index data backup. If there is snapshot data in an OBS
        bucket, only the OBS bucket is used and cannot be changed.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated snapshots. Snapshots are reserved
        for seven days by default.
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Specifies the prefix of the snapshot that is automatically created. The default value
        is "snapshot".
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ClusterClientNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceNumber":
            suggest = "instance_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor: str,
                 instance_number: int,
                 volume: 'outputs.ClusterClientNodeConfigVolume'):
        """
        :param str flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param int instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param 'ClusterClientNodeConfigVolumeArgs' volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> int:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter
    def volume(self) -> 'outputs.ClusterClientNodeConfigVolume':
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class ClusterClientNodeConfigVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientNodeConfigVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientNodeConfigVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientNodeConfigVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 volume_type: str):
        """
        :param int size: Specifies the volume size in GB, which must be a multiple of 10.
        :param str volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterColdNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceNumber":
            suggest = "instance_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterColdNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterColdNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterColdNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor: str,
                 instance_number: int,
                 volume: 'outputs.ClusterColdNodeConfigVolume'):
        """
        :param str flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param int instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param 'ClusterColdNodeConfigVolumeArgs' volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> int:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter
    def volume(self) -> 'outputs.ClusterColdNodeConfigVolume':
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class ClusterColdNodeConfigVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterColdNodeConfigVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterColdNodeConfigVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterColdNodeConfigVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 volume_type: str):
        """
        :param int size: Specifies the volume size in GB, which must be a multiple of 10.
        :param str volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterEssNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceNumber":
            suggest = "instance_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEssNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEssNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEssNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor: str,
                 instance_number: int,
                 volume: 'outputs.ClusterEssNodeConfigVolume'):
        """
        :param str flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param int instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param 'ClusterEssNodeConfigVolumeArgs' volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> int:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter
    def volume(self) -> 'outputs.ClusterEssNodeConfigVolume':
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class ClusterEssNodeConfigVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEssNodeConfigVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEssNodeConfigVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEssNodeConfigVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 volume_type: str):
        """
        :param int size: Specifies the volume size in GB, which must be a multiple of 10.
        :param str volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterKibanaPublicAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistEnabled":
            suggest = "whitelist_enabled"
        elif key == "publicIp":
            suggest = "public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKibanaPublicAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKibanaPublicAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKibanaPublicAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth: int,
                 whitelist_enabled: bool,
                 public_ip: Optional[str] = None,
                 whitelist: Optional[str] = None):
        """
        :param int bandwidth: Specifies the public network bandwidth.
        :param bool whitelist_enabled: Specifies whether to enable the public network access control.
        :param str whitelist: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "whitelist_enabled", whitelist_enabled)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        Specifies the public network bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="whitelistEnabled")
    def whitelist_enabled(self) -> bool:
        """
        Specifies whether to enable the public network access control.
        """
        return pulumi.get(self, "whitelist_enabled")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[str]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelist")


@pulumi.output_type
class ClusterMasterNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceNumber":
            suggest = "instance_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor: str,
                 instance_number: int,
                 volume: 'outputs.ClusterMasterNodeConfigVolume'):
        """
        :param str flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param int instance_number: Specifies the number of cluster instances.
               + When it is `ess_node_config`, The value range is 1 to 200.
               + When it is `master_node_config`, The value range is 3 to 10.
               + When it is `client_node_config`, The value range is 1 to 32.
               + When it is `cold_node_config`, The value range is 1 to 32.
        :param 'ClusterMasterNodeConfigVolumeArgs' volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> int:
        """
        Specifies the number of cluster instances.
        + When it is `ess_node_config`, The value range is 1 to 200.
        + When it is `master_node_config`, The value range is 3 to 10.
        + When it is `client_node_config`, The value range is 1 to 32.
        + When it is `cold_node_config`, The value range is 1 to 32.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter
    def volume(self) -> 'outputs.ClusterMasterNodeConfigVolume':
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class ClusterMasterNodeConfigVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterNodeConfigVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterNodeConfigVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterNodeConfigVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 volume_type: str):
        """
        :param int size: Specifies the volume size in GB, which must be a multiple of 10.
        :param str volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "specCode":
            suggest = "spec_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 spec_code: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param str id: Instance ID.
        :param str name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param str status: The cluster status
               + `100`: The operation, such as instance creation, is in progress.
               + `200`: The cluster is available.
               + `303`: The cluster is unavailable.
        :param str type: Node type. The options are as follows:
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec_code is not None:
            pulumi.set(__self__, "spec_code", spec_code)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the cluster name. It contains 4 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="specCode")
    def spec_code(self) -> Optional[str]:
        return pulumi.get(self, "spec_code")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The cluster status
        + `100`: The operation, such as instance creation, is in progress.
        + `200`: The cluster is available.
        + `303`: The cluster is unavailable.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Node type. The options are as follows:
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "networkInfo":
            suggest = "network_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: str,
                 flavor: str,
                 network_info: 'outputs.ClusterNodeConfigNetworkInfo',
                 volume: 'outputs.ClusterNodeConfigVolume'):
        """
        :param str availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param str flavor: Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
               40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
               to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
               to 10240 GB. Changing this parameter will create a new resource.
        :param 'ClusterNodeConfigVolumeArgs' volume: Specifies the information about the volume.
               The volume structure is documented below.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "network_info", network_info)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the flavor name. For example: value range of flavor ess.spec-2u8g:
        40 GB to 800 GB, value range of flavor ess.spec-4u16g: 40 GB to 1600 GB, value range of flavor ess.spec-8u32g: 80 GB
        to 3200 GB, value range of flavor ess.spec-16u64g: 100 GB to 6400 GB, value range of flavor ess.spec-32u128g: 100 GB
        to 10240 GB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> 'outputs.ClusterNodeConfigNetworkInfo':
        return pulumi.get(self, "network_info")

    @property
    @pulumi.getter
    def volume(self) -> 'outputs.ClusterNodeConfigVolume':
        """
        Specifies the information about the volume.
        The volume structure is documented below.
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class ClusterNodeConfigNetworkInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeConfigNetworkInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeConfigNetworkInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeConfigNetworkInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_id: str,
                 subnet_id: str,
                 vpc_id: str):
        """
        :param str security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param str subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param str vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Specifies Security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the Subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ClusterNodeConfigVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeConfigVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeConfigVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeConfigVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 volume_type: str):
        """
        :param int size: Specifies the volume size in GB, which must be a multiple of 10.
        :param str volume_type: Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
               HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
               parameter will create a new resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in GB, which must be a multiple of 10.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Specifies the volume type. COMMON: Common I/O. The SATA disk is used.
        HIGH: High I/O. The SAS disk is used. ULTRAHIGH: Ultra-high I/O. The solid-state drive (SSD) is used. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterPublicAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistEnabled":
            suggest = "whitelist_enabled"
        elif key == "publicIp":
            suggest = "public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPublicAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPublicAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPublicAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth: int,
                 whitelist_enabled: bool,
                 public_ip: Optional[str] = None,
                 whitelist: Optional[str] = None):
        """
        :param int bandwidth: Specifies the public network bandwidth.
        :param bool whitelist_enabled: Specifies whether to enable the public network access control.
        :param str whitelist: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "whitelist_enabled", whitelist_enabled)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if whitelist is not None:
            pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        Specifies the public network bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="whitelistEnabled")
    def whitelist_enabled(self) -> bool:
        """
        Specifies whether to enable the public network access control.
        """
        return pulumi.get(self, "whitelist_enabled")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def whitelist(self) -> Optional[str]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelist")


@pulumi.output_type
class ClusterVpcepEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointWithDnsName":
            suggest = "endpoint_with_dns_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVpcepEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVpcepEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVpcepEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_with_dns_name: bool,
                 whitelists: Optional[Sequence[str]] = None):
        """
        :param bool endpoint_with_dns_name: Specifies whether to enable the private domain name.
        :param Sequence[str] whitelists: Specifies the whitelist of access control.
               Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        pulumi.set(__self__, "endpoint_with_dns_name", endpoint_with_dns_name)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @property
    @pulumi.getter(name="endpointWithDnsName")
    def endpoint_with_dns_name(self) -> bool:
        """
        Specifies whether to enable the private domain name.
        """
        return pulumi.get(self, "endpoint_with_dns_name")

    @property
    @pulumi.getter
    def whitelists(self) -> Optional[Sequence[str]]:
        """
        Specifies the whitelist of access control.
        Separate the whitelisted Account IDs with commas (,), and each of them must be unique.
        """
        return pulumi.get(self, "whitelists")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 disk_range: str,
                 id: str,
                 memory: int,
                 name: str,
                 region: str,
                 type: str,
                 vcpus: int,
                 version: str):
        """
        :param str disk_range: The disk capacity range of an instance, in GB.
        :param str id: The ID of CSS flavor.
        :param int memory: Specifies the memory size(GB) in the CSS flavor.
        :param str name: Specifies the name of the CSS flavor.
        :param str region: Specifies the region in which to obtain the CSS flavors. If omitted, the
               provider-level region will be used.
        :param str type: Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
               and `ess-client`.
        :param int vcpus: Specifies the number of vCPUs in the CSS flavor.
        :param str version: Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
               `7.6.2` and `7.9.3`.
        """
        pulumi.set(__self__, "disk_range", disk_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="diskRange")
    def disk_range(self) -> str:
        """
        The disk capacity range of an instance, in GB.
        """
        return pulumi.get(self, "disk_range")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of CSS flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Specifies the memory size(GB) in the CSS flavor.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the CSS flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Specifies the region in which to obtain the CSS flavors. If omitted, the
        provider-level region will be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the node instance type. The options are `ess`, `ess-cold`, `ess-master`
        and `ess-client`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        Specifies the number of vCPUs in the CSS flavor.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the engine version. The options are `5.5.1`, `6.2.3`, `6.5.4`, `7.1.1`,
        `7.6.2` and `7.9.3`.
        """
        return pulumi.get(self, "version")


