# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MicroserviceArgs', 'Microservice']

@pulumi.input_type
class MicroserviceArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 connect_address: pulumi.Input[str],
                 version: pulumi.Input[str],
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Microservice resource.
        :param pulumi.Input[str] app_name: Specifies the name of the dedicated microservice application.
               Changing this will create a new microservice.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice.
               Changing this will create a new microservice.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice.
               The description can contian a maximum of `256` characters.
               Changing this will create a new microservice.
        :param pulumi.Input[str] environment: Specifies the environment (stage) type.
               The valid values are **development**, **testing**, **acceptance** and **production**.
               If omitted, the microservice will be deployed in an empty environment.
               Changing this will create a new microservice.
        :param pulumi.Input[str] level: Specifies the microservice level.
               The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice.
               The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
               allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "connect_address", connect_address)
        pulumi.set(__self__, "version", version)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the dedicated microservice application.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Input[str]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the version of the dedicated microservice.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the dedicated microservice.
        The description can contian a maximum of `256` characters.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment (stage) type.
        The valid values are **development**, **testing**, **acceptance** and **production**.
        If omitted, the microservice will be deployed in an empty environment.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the microservice level.
        The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dedicated microservice.
        The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
        allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MicroserviceState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Microservice resources.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        :param pulumi.Input[str] app_name: Specifies the name of the dedicated microservice application.
               Changing this will create a new microservice.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice.
               The description can contian a maximum of `256` characters.
               Changing this will create a new microservice.
        :param pulumi.Input[str] environment: Specifies the environment (stage) type.
               The valid values are **development**, **testing**, **acceptance** and **production**.
               If omitted, the microservice will be deployed in an empty environment.
               Changing this will create a new microservice.
        :param pulumi.Input[str] level: Specifies the microservice level.
               The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice.
               The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
               allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        :param pulumi.Input[str] status: The microservice status. The values supports **UP** and **DOWN**.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice.
               Changing this will create a new microservice.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if admin_user is not None:
            pulumi.set(__self__, "admin_user", admin_user)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "admin_user")

    @admin_user.setter
    def admin_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user", value)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dedicated microservice application.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the dedicated microservice.
        The description can contian a maximum of `256` characters.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment (stage) type.
        The valid values are **development**, **testing**, **acceptance** and **production**.
        If omitted, the microservice will be deployed in an empty environment.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the microservice level.
        The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dedicated microservice.
        The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
        allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The microservice status. The values supports **UP** and **DOWN**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the dedicated microservice.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Microservice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a dedicated microservice resource within HuaweiCloud.

        > When deleting a microservice, all instances under it will also be deleted together.

        ## Example Usage

        ## Import

        Microservices can be imported using related `connect_address` and their `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microservice:Microservice test https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d
        ```

         If you enabled the **RBAC** authorization, you also need to provide the account name and password, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microservice:Microservice test 'https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/root/Test!123'
        ```

         The single quotes can help you solve the problem of special characters reporting errors on bash.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        :param pulumi.Input[str] app_name: Specifies the name of the dedicated microservice application.
               Changing this will create a new microservice.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice.
               The description can contian a maximum of `256` characters.
               Changing this will create a new microservice.
        :param pulumi.Input[str] environment: Specifies the environment (stage) type.
               The valid values are **development**, **testing**, **acceptance** and **production**.
               If omitted, the microservice will be deployed in an empty environment.
               Changing this will create a new microservice.
        :param pulumi.Input[str] level: Specifies the microservice level.
               The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice.
               The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
               allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice.
               Changing this will create a new microservice.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MicroserviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a dedicated microservice resource within HuaweiCloud.

        > When deleting a microservice, all instances under it will also be deleted together.

        ## Example Usage

        ## Import

        Microservices can be imported using related `connect_address` and their `id`, separated by a slash (/), e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microservice:Microservice test https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d
        ```

         If you enabled the **RBAC** authorization, you also need to provide the account name and password, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microservice:Microservice test 'https://124.70.26.32:30100/f14960ba495e03f59f85aacaaafbdef3fbff3f0d/root/Test!123'
        ```

         The single quotes can help you solve the problem of special characters reporting errors on bash.

        :param str resource_name: The name of the resource.
        :param MicroserviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MicroserviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 admin_user: Optional[pulumi.Input[str]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 connect_address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MicroserviceArgs.__new__(MicroserviceArgs)

            __props__.__dict__["admin_pass"] = admin_pass
            __props__.__dict__["admin_user"] = admin_user
            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            if connect_address is None and not opts.urn:
                raise TypeError("Missing required property 'connect_address'")
            __props__.__dict__["connect_address"] = connect_address
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["level"] = level
            __props__.__dict__["name"] = name
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["status"] = None
        super(Microservice, __self__).__init__(
            'huaweicloud:Cse/microservice:Microservice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[str]] = None,
            admin_user: Optional[pulumi.Input[str]] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            connect_address: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            level: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Microservice':
        """
        Get an existing Microservice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] admin_user: Specifies the account name. The initial account name is **root**.
               Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        :param pulumi.Input[str] app_name: Specifies the name of the dedicated microservice application.
               Changing this will create a new microservice.
        :param pulumi.Input[str] connect_address: Specifies the connection address of service registry center for the
               specified dedicated CSE engine. Changing this will create a new microservice.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice.
               The description can contian a maximum of `256` characters.
               Changing this will create a new microservice.
        :param pulumi.Input[str] environment: Specifies the environment (stage) type.
               The valid values are **development**, **testing**, **acceptance** and **production**.
               If omitted, the microservice will be deployed in an empty environment.
               Changing this will create a new microservice.
        :param pulumi.Input[str] level: Specifies the microservice level.
               The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice.
               The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
               allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        :param pulumi.Input[str] status: The microservice status. The values supports **UP** and **DOWN**.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice.
               Changing this will create a new microservice.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MicroserviceState.__new__(_MicroserviceState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["admin_user"] = admin_user
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["level"] = level
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return Microservice(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account password.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account name. The initial account name is **root**.
        Required if the `auth_type` of engine is **RBAC**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "admin_user")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the dedicated microservice application.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[str]:
        """
        Specifies the connection address of service registry center for the
        specified dedicated CSE engine. Changing this will create a new microservice.
        """
        return pulumi.get(self, "connect_address")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the dedicated microservice.
        The description can contian a maximum of `256` characters.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the environment (stage) type.
        The valid values are **development**, **testing**, **acceptance** and **production**.
        If omitted, the microservice will be deployed in an empty environment.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the microservice level.
        The valid values are **FRONT**, **MIDDLE**, and **BACK**. Changing this will create a new microservice.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the dedicated microservice.
        The name can contain `1` to `128` characters, only letters, digits, underscore (_), hyphens (-) and dots (.) are
        allowed. The name must start and end with a letter or digit. Changing this will create a new microservice.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The microservice status. The values supports **UP** and **DOWN**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Specifies the version of the dedicated microservice.
        Changing this will create a new microservice.
        """
        return pulumi.get(self, "version")

