# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[int],
                 benchmark_concurrency: Optional[pulumi.Input[int]] = None,
                 cluster_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input[int] project_id: Specifies the CPTS project ID which the task belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] benchmark_concurrency: Specifies benchmark concurrency of the task, the value range is 0 to
               2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
               `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        :param pulumi.Input[int] cluster_id: Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
               is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        :param pulumi.Input[str] name: Specifies the name of the task, which can contain a maximum of 42 characters.
        :param pulumi.Input[str] operation: Specifies whether to enable the task or stop the task. The options are as follows:
               + **enable**: Starting the pressure test task.
               + **stop**: Stop the pressure test tasks.
        :param pulumi.Input[str] region: Specifies the region in which to create the task resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "project_id", project_id)
        if benchmark_concurrency is not None:
            pulumi.set(__self__, "benchmark_concurrency", benchmark_concurrency)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[int]:
        """
        Specifies the CPTS project ID which the task belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="benchmarkConcurrency")
    def benchmark_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies benchmark concurrency of the task, the value range is 0 to
        2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
        `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        """
        return pulumi.get(self, "benchmark_concurrency")

    @benchmark_concurrency.setter
    def benchmark_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "benchmark_concurrency", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
        is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the task, which can contain a maximum of 42 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable the task or stop the task. The options are as follows:
        + **enable**: Starting the pressure test task.
        + **stop**: Stop the pressure test tasks.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the task resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 benchmark_concurrency: Optional[pulumi.Input[int]] = None,
                 cluster_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[int] benchmark_concurrency: Specifies benchmark concurrency of the task, the value range is 0 to
               2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
               `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        :param pulumi.Input[int] cluster_id: Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
               is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        :param pulumi.Input[str] name: Specifies the name of the task, which can contain a maximum of 42 characters.
        :param pulumi.Input[str] operation: Specifies whether to enable the task or stop the task. The options are as follows:
               + **enable**: Starting the pressure test task.
               + **stop**: Stop the pressure test tasks.
        :param pulumi.Input[int] project_id: Specifies the CPTS project ID which the task belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the task resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: The status of the task. The options are as follows:
               + **0**: The task is running.
               + **2**: The task is idle.
        """
        if benchmark_concurrency is not None:
            pulumi.set(__self__, "benchmark_concurrency", benchmark_concurrency)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="benchmarkConcurrency")
    def benchmark_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies benchmark concurrency of the task, the value range is 0 to
        2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
        `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        """
        return pulumi.get(self, "benchmark_concurrency")

    @benchmark_concurrency.setter
    def benchmark_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "benchmark_concurrency", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
        is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the task, which can contain a maximum of 42 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to enable the task or stop the task. The options are as follows:
        + **enable**: Starting the pressure test task.
        + **stop**: Stop the pressure test tasks.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the CPTS project ID which the task belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the task resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of the task. The options are as follows:
        + **0**: The task is running.
        + **2**: The task is idle.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)


class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 benchmark_concurrency: Optional[pulumi.Input[int]] = None,
                 cluster_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a pressure Test Task resource within HuaweiCloud CPTS.
        The task resource only supports serial execution mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_project = huaweicloud.cpts.Project("testProject")
        test_task = huaweicloud.cpts.Task("testTask", project_id=test_project.id)
        ```

        ## Import

        Tasks can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cpts/task:Task test 1090
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`operation`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cpts_task" "test" {

         ...

         lifecycle {

         ignore_changes = [

         operation,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] benchmark_concurrency: Specifies benchmark concurrency of the task, the value range is 0 to
               2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
               `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        :param pulumi.Input[int] cluster_id: Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
               is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        :param pulumi.Input[str] name: Specifies the name of the task, which can contain a maximum of 42 characters.
        :param pulumi.Input[str] operation: Specifies whether to enable the task or stop the task. The options are as follows:
               + **enable**: Starting the pressure test task.
               + **stop**: Stop the pressure test tasks.
        :param pulumi.Input[int] project_id: Specifies the CPTS project ID which the task belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the task resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a pressure Test Task resource within HuaweiCloud CPTS.
        The task resource only supports serial execution mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test_project = huaweicloud.cpts.Project("testProject")
        test_task = huaweicloud.cpts.Task("testTask", project_id=test_project.id)
        ```

        ## Import

        Tasks can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cpts/task:Task test 1090
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`operation`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cpts_task" "test" {

         ...

         lifecycle {

         ignore_changes = [

         operation,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 benchmark_concurrency: Optional[pulumi.Input[int]] = None,
                 cluster_id: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["benchmark_concurrency"] = benchmark_concurrency
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            __props__.__dict__["operation"] = operation
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = None
        super(Task, __self__).__init__(
            'huaweicloud:Cpts/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            benchmark_concurrency: Optional[pulumi.Input[int]] = None,
            cluster_id: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            operation: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[int]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] benchmark_concurrency: Specifies benchmark concurrency of the task, the value range is 0 to
               2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
               `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        :param pulumi.Input[int] cluster_id: Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
               is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        :param pulumi.Input[str] name: Specifies the name of the task, which can contain a maximum of 42 characters.
        :param pulumi.Input[str] operation: Specifies whether to enable the task or stop the task. The options are as follows:
               + **enable**: Starting the pressure test task.
               + **stop**: Stop the pressure test tasks.
        :param pulumi.Input[int] project_id: Specifies the CPTS project ID which the task belongs to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the task resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: The status of the task. The options are as follows:
               + **0**: The task is running.
               + **2**: The task is idle.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["benchmark_concurrency"] = benchmark_concurrency
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["name"] = name
        __props__.__dict__["operation"] = operation
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return Task(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="benchmarkConcurrency")
    def benchmark_concurrency(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies benchmark concurrency of the task, the value range is 0 to
        2000000. The default value is `100`. Reference for the calculation of the number of concurrent users.
        `Number of concurrent users` = `benchmark concurrency` * `concurrency ratio`.
        """
        return pulumi.get(self, "benchmark_concurrency")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies a cluster ID of the CPTS resource group. If the number of concurrent users
        is less than 1000, you can use a shared resource group for testing and do not have to create a resource group.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the task, which can contain a maximum of 42 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to enable the task or stop the task. The options are as follows:
        + **enable**: Starting the pressure test task.
        + **stop**: Stop the pressure test tasks.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[int]:
        """
        Specifies the CPTS project ID which the task belongs to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the task resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status of the task. The options are as follows:
        + **0**: The task is running.
        + **2**: The task is idle.
        """
        return pulumi.get(self, "status")

