# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 hbase_version: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 storage_type: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 opentsdb_num: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rs_num: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] hbase_version: Specifies the version of HBase datastore.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] storage_type: Specifies the storage type.
               The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] iam_auth_enabled: Specifies whether IAM authorization is enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the cluster name. The name consists of 4 to 64 characters, including
               lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        :param pulumi.Input[int] opentsdb_num: Specifies the TSD nodes number of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] rs_num: Specifies the compute nodes number of the cluster.
               The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "hbase_version", hbase_version)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if iam_auth_enabled is not None:
            pulumi.set(__self__, "iam_auth_enabled", iam_auth_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opentsdb_num is not None:
            pulumi.set(__self__, "opentsdb_num", opentsdb_num)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rs_num is not None:
            pulumi.set(__self__, "rs_num", rs_num)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="hbaseVersion")
    def hbase_version(self) -> pulumi.Input[str]:
        """
        Specifies the version of HBase datastore.
        """
        return pulumi.get(self, "hbase_version")

    @hbase_version.setter
    def hbase_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "hbase_version", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the network to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        Specifies the storage type.
        The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="iamAuthEnabled")
    def iam_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether IAM authorization is enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iam_auth_enabled")

    @iam_auth_enabled.setter
    def iam_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "iam_auth_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster name. The name consists of 4 to 64 characters, including
        lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="opentsdbNum")
    def opentsdb_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the TSD nodes number of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "opentsdb_num")

    @opentsdb_num.setter
    def opentsdb_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "opentsdb_num", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the cluster.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rsNum")
    def rs_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the compute nodes number of the cluster.
        The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "rs_num")

    @rs_num.setter
    def rs_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rs_num", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 hbase_public_endpoint: Optional[pulumi.Input[str]] = None,
                 hbase_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 open_tsdb_link: Optional[pulumi.Input[str]] = None,
                 opentsdb_num: Optional[pulumi.Input[int]] = None,
                 opentsdb_public_endpoint: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rs_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_size: Optional[pulumi.Input[int]] = None,
                 storage_size_used: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zookeeper_link: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] created_at: The time (UTC) when the cluster was created.
        :param pulumi.Input[str] hbase_public_endpoint: The HBase public network endpoint address.
        :param pulumi.Input[str] hbase_version: Specifies the version of HBase datastore.
        :param pulumi.Input[bool] iam_auth_enabled: Specifies whether IAM authorization is enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the cluster name. The name consists of 4 to 64 characters, including
               lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] open_tsdb_link: The intranet OpenTSDB connection access address.
        :param pulumi.Input[int] opentsdb_num: Specifies the TSD nodes number of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] opentsdb_public_endpoint: The OpenTSDB public network endpoint address.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] rs_num: Specifies the compute nodes number of the cluster.
               The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The cluster status.
        :param pulumi.Input[int] storage_size: The storage size, in GB.
        :param pulumi.Input[int] storage_size_used: The currently used storage, in GB.
        :param pulumi.Input[str] storage_type: Specifies the storage type.
               The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] zookeeper_link: The intranet zookeeper connection access address.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if hbase_public_endpoint is not None:
            pulumi.set(__self__, "hbase_public_endpoint", hbase_public_endpoint)
        if hbase_version is not None:
            pulumi.set(__self__, "hbase_version", hbase_version)
        if iam_auth_enabled is not None:
            pulumi.set(__self__, "iam_auth_enabled", iam_auth_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if open_tsdb_link is not None:
            pulumi.set(__self__, "open_tsdb_link", open_tsdb_link)
        if opentsdb_num is not None:
            pulumi.set(__self__, "opentsdb_num", opentsdb_num)
        if opentsdb_public_endpoint is not None:
            pulumi.set(__self__, "opentsdb_public_endpoint", opentsdb_public_endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rs_num is not None:
            pulumi.set(__self__, "rs_num", rs_num)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if storage_size_used is not None:
            pulumi.set(__self__, "storage_size_used", storage_size_used)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zookeeper_link is not None:
            pulumi.set(__self__, "zookeeper_link", zookeeper_link)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The time (UTC) when the cluster was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="hbasePublicEndpoint")
    def hbase_public_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The HBase public network endpoint address.
        """
        return pulumi.get(self, "hbase_public_endpoint")

    @hbase_public_endpoint.setter
    def hbase_public_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hbase_public_endpoint", value)

    @property
    @pulumi.getter(name="hbaseVersion")
    def hbase_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of HBase datastore.
        """
        return pulumi.get(self, "hbase_version")

    @hbase_version.setter
    def hbase_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hbase_version", value)

    @property
    @pulumi.getter(name="iamAuthEnabled")
    def iam_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether IAM authorization is enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iam_auth_enabled")

    @iam_auth_enabled.setter
    def iam_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "iam_auth_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster name. The name consists of 4 to 64 characters, including
        lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the network to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="openTsdbLink")
    def open_tsdb_link(self) -> Optional[pulumi.Input[str]]:
        """
        The intranet OpenTSDB connection access address.
        """
        return pulumi.get(self, "open_tsdb_link")

    @open_tsdb_link.setter
    def open_tsdb_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_tsdb_link", value)

    @property
    @pulumi.getter(name="opentsdbNum")
    def opentsdb_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the TSD nodes number of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "opentsdb_num")

    @opentsdb_num.setter
    def opentsdb_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "opentsdb_num", value)

    @property
    @pulumi.getter(name="opentsdbPublicEndpoint")
    def opentsdb_public_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenTSDB public network endpoint address.
        """
        return pulumi.get(self, "opentsdb_public_endpoint")

    @opentsdb_public_endpoint.setter
    def opentsdb_public_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opentsdb_public_endpoint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the cluster.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rsNum")
    def rs_num(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the compute nodes number of the cluster.
        The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "rs_num")

    @rs_num.setter
    def rs_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rs_num", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[int]]:
        """
        The storage size, in GB.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size", value)

    @property
    @pulumi.getter(name="storageSizeUsed")
    def storage_size_used(self) -> Optional[pulumi.Input[int]]:
        """
        The currently used storage, in GB.
        """
        return pulumi.get(self, "storage_size_used")

    @storage_size_used.setter
    def storage_size_used(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_size_used", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage type.
        The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zookeeperLink")
    def zookeeper_link(self) -> Optional[pulumi.Input[str]]:
        """
        The intranet zookeeper connection access address.
        """
        return pulumi.get(self, "zookeeper_link")

    @zookeeper_link.setter
    def zookeeper_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zookeeper_link", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 hbase_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 opentsdb_num: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rs_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a CloudTable cluster resource within HuaweiCloud.

        ## Import

        Clusters can be imported by their `id`. e.g.

        ```sh
         $ pulumi import huaweicloud:CloudTable/cluster:Cluster test 4c2d38b6-6fb0-480c-8813-5f536b5ba6a4
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`availability_zone`, `network_id`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_cloudtable_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         availability_zone, network_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] hbase_version: Specifies the version of HBase datastore.
        :param pulumi.Input[bool] iam_auth_enabled: Specifies whether IAM authorization is enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the cluster name. The name consists of 4 to 64 characters, including
               lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] opentsdb_num: Specifies the TSD nodes number of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] rs_num: Specifies the compute nodes number of the cluster.
               The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] storage_type: Specifies the storage type.
               The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the cluster belongs.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CloudTable cluster resource within HuaweiCloud.

        ## Import

        Clusters can be imported by their `id`. e.g.

        ```sh
         $ pulumi import huaweicloud:CloudTable/cluster:Cluster test 4c2d38b6-6fb0-480c-8813-5f536b5ba6a4
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`availability_zone`, `network_id`. It is generally recommended running `terraform plan` after importing a cluster. You can then decide if changes should be applied to the cluster, or the resource definition should be updated to align with the cluster. Also you can ignore changes as below. resource "huaweicloud_cloudtable_cluster" "test" {

         ...

         lifecycle {

         ignore_changes = [

         availability_zone, network_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 hbase_version: Optional[pulumi.Input[str]] = None,
                 iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 opentsdb_num: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rs_num: Optional[pulumi.Input[int]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            if hbase_version is None and not opts.urn:
                raise TypeError("Missing required property 'hbase_version'")
            __props__.__dict__["hbase_version"] = hbase_version
            __props__.__dict__["iam_auth_enabled"] = iam_auth_enabled
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["opentsdb_num"] = opentsdb_num
            __props__.__dict__["region"] = region
            __props__.__dict__["rs_num"] = rs_num
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["hbase_public_endpoint"] = None
            __props__.__dict__["open_tsdb_link"] = None
            __props__.__dict__["opentsdb_public_endpoint"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_size"] = None
            __props__.__dict__["storage_size_used"] = None
            __props__.__dict__["zookeeper_link"] = None
        super(Cluster, __self__).__init__(
            'huaweicloud:CloudTable/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            hbase_public_endpoint: Optional[pulumi.Input[str]] = None,
            hbase_version: Optional[pulumi.Input[str]] = None,
            iam_auth_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            open_tsdb_link: Optional[pulumi.Input[str]] = None,
            opentsdb_num: Optional[pulumi.Input[int]] = None,
            opentsdb_public_endpoint: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rs_num: Optional[pulumi.Input[int]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_size: Optional[pulumi.Input[int]] = None,
            storage_size_used: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zookeeper_link: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone in which to create the cluster.
               Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] created_at: The time (UTC) when the cluster was created.
        :param pulumi.Input[str] hbase_public_endpoint: The HBase public network endpoint address.
        :param pulumi.Input[str] hbase_version: Specifies the version of HBase datastore.
        :param pulumi.Input[bool] iam_auth_enabled: Specifies whether IAM authorization is enabled.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the cluster name. The name consists of 4 to 64 characters, including
               lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] open_tsdb_link: The intranet OpenTSDB connection access address.
        :param pulumi.Input[int] opentsdb_num: Specifies the TSD nodes number of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] opentsdb_public_endpoint: The OpenTSDB public network endpoint address.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[int] rs_num: Specifies the compute nodes number of the cluster.
               The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The cluster status.
        :param pulumi.Input[int] storage_size: The storage size, in GB.
        :param pulumi.Input[int] storage_size_used: The currently used storage, in GB.
        :param pulumi.Input[str] storage_type: Specifies the storage type.
               The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the cluster belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] zookeeper_link: The intranet zookeeper connection access address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["hbase_public_endpoint"] = hbase_public_endpoint
        __props__.__dict__["hbase_version"] = hbase_version
        __props__.__dict__["iam_auth_enabled"] = iam_auth_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["open_tsdb_link"] = open_tsdb_link
        __props__.__dict__["opentsdb_num"] = opentsdb_num
        __props__.__dict__["opentsdb_public_endpoint"] = opentsdb_public_endpoint
        __props__.__dict__["region"] = region
        __props__.__dict__["rs_num"] = rs_num
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["storage_size_used"] = storage_size_used
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zookeeper_link"] = zookeeper_link
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone in which to create the cluster.
        Please following [reference](https://developer.huaweicloud.com/en-us/endpoint/?CloudTable) for the values.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time (UTC) when the cluster was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="hbasePublicEndpoint")
    def hbase_public_endpoint(self) -> pulumi.Output[str]:
        """
        The HBase public network endpoint address.
        """
        return pulumi.get(self, "hbase_public_endpoint")

    @property
    @pulumi.getter(name="hbaseVersion")
    def hbase_version(self) -> pulumi.Output[str]:
        """
        Specifies the version of HBase datastore.
        """
        return pulumi.get(self, "hbase_version")

    @property
    @pulumi.getter(name="iamAuthEnabled")
    def iam_auth_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether IAM authorization is enabled.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iam_auth_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the cluster name. The name consists of 4 to 64 characters, including
        lowercase letters, numbers and hyphens (-). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the network to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="openTsdbLink")
    def open_tsdb_link(self) -> pulumi.Output[str]:
        """
        The intranet OpenTSDB connection access address.
        """
        return pulumi.get(self, "open_tsdb_link")

    @property
    @pulumi.getter(name="opentsdbNum")
    def opentsdb_num(self) -> pulumi.Output[int]:
        """
        Specifies the TSD nodes number of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "opentsdb_num")

    @property
    @pulumi.getter(name="opentsdbPublicEndpoint")
    def opentsdb_public_endpoint(self) -> pulumi.Output[str]:
        """
        The OpenTSDB public network endpoint address.
        """
        return pulumi.get(self, "opentsdb_public_endpoint")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the cluster.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rsNum")
    def rs_num(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the compute nodes number of the cluster.
        The valid values must be greater than `2`. Defaults to `2`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "rs_num")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The cluster status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[int]:
        """
        The storage size, in GB.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter(name="storageSizeUsed")
    def storage_size_used(self) -> pulumi.Output[int]:
        """
        The currently used storage, in GB.
        """
        return pulumi.get(self, "storage_size_used")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Specifies the storage type.
        The valid values are **COMMON** and **ULTRAHIGH**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID to which the cluster belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zookeeperLink")
    def zookeeper_link(self) -> pulumi.Output[str]:
        """
        The intranet zookeeper connection access address.
        """
        return pulumi.get(self, "zookeeper_link")

