# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 data_volumes: pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]],
                 flavor_id: pulumi.Input[str],
                 initial_node_count: pulumi.Input[int],
                 root_volume: pulumi.Input['NodePoolRootVolumeArgs'],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[int]] = None,
                 scall_enable: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input['NodePoolRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[str] name: Specifies the node pool name.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "data_volumes", data_volumes)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        pulumi.set(__self__, "root_volume", root_volume)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if scale_down_cooldown_time is not None:
            pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable is not None:
            pulumi.set(__self__, "scall_enable", scall_enable)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Input[int]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Input['NodePoolRootVolumeArgs']:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: pulumi.Input['NodePoolRootVolumeArgs']):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_param", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @scale_down_cooldown_time.setter
    def scale_down_cooldown_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale_down_cooldown_time", value)

    @property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @scall_enable.setter
    def scall_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scall_enable", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 billing_mode: Optional[pulumi.Input[int]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 current_node_count: Optional[pulumi.Input[int]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input['NodePoolRootVolumeArgs']] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[int]] = None,
                 scall_enable: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[int] billing_mode: Billing mode of a node.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] current_node_count: The current number of the nodes.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[str] name: Specifies the node pool name.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input['NodePoolRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[str] status: Node status information.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if current_node_count is not None:
            pulumi.set(__self__, "current_node_count", current_node_count)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if scale_down_cooldown_time is not None:
            pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable is not None:
            pulumi.set(__self__, "scall_enable", scall_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Billing mode of a node.
        """
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The current number of the nodes.
        """
        return pulumi.get(self, "current_node_count")

    @current_node_count.setter
    def current_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_node_count", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_param", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['NodePoolRootVolumeArgs']]:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['NodePoolRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @scale_down_cooldown_time.setter
    def scale_down_cooldown_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale_down_cooldown_time", value)

    @property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @scall_enable.setter
    def scall_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scall_enable", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataVolumeArgs']]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['NodePoolRootVolumeArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[int]] = None,
                 scall_enable: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Add a node pool to a container cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = huaweicloud.cce.NodePool("nodePool",
            cluster_id=cluster_id,
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=var["keypair"],
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume=huaweicloud.cce.NodePoolRootVolumeArgs(
                size=40,
                volumetype="SAS",
            ),
            data_volumes=[huaweicloud.cce.NodePoolDataVolumeArgs(
                size=100,
                volumetype="SAS",
            )])
        ```

        ## Import

        CCE node pool can be imported using the cluster ID and node pool ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/nodePool:NodePool my_node_pool 5c20fdad-7288-11eb-b817-0255ac10158b/e9287dff-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `subnet_id`, `preinstall`, `posteinstall`, `taints` and `initial_node_count`. It is generally recommended running `terraform plan` after importing a node pool. You can then decide if changes should be applied to the node pool, or the resource definition should be updated to align with the node pool. Also you can ignore changes as below. resource "huaweicloud_cce_node_pool" "my_node_pool" {

         ...

         lifecycle {

         ignore_changes = [

         password, subnet_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataVolumeArgs']]]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[str] name: Specifies the node pool name.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[pulumi.InputType['NodePoolRootVolumeArgs']] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Add a node pool to a container cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        key_pair = config.require_object("keyPair")
        availability_zone = config.require_object("availabilityZone")
        node_pool = huaweicloud.cce.NodePool("nodePool",
            cluster_id=cluster_id,
            os="EulerOS 2.5",
            initial_node_count=2,
            flavor_id="s3.large.4",
            availability_zone=availability_zone,
            key_pair=var["keypair"],
            scall_enable=True,
            min_node_count=1,
            max_node_count=10,
            scale_down_cooldown_time=100,
            priority=1,
            type="vm",
            root_volume=huaweicloud.cce.NodePoolRootVolumeArgs(
                size=40,
                volumetype="SAS",
            ),
            data_volumes=[huaweicloud.cce.NodePoolDataVolumeArgs(
                size=100,
                volumetype="SAS",
            )])
        ```

        ## Import

        CCE node pool can be imported using the cluster ID and node pool ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/nodePool:NodePool my_node_pool 5c20fdad-7288-11eb-b817-0255ac10158b/e9287dff-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `subnet_id`, `preinstall`, `posteinstall`, `taints` and `initial_node_count`. It is generally recommended running `terraform plan` after importing a node pool. You can then decide if changes should be applied to the node pool, or the resource definition should be updated to align with the node pool. Also you can ignore changes as below. resource "huaweicloud_cce_node_pool" "my_node_pool" {

         ...

         lifecycle {

         ignore_changes = [

         password, subnet_id,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataVolumeArgs']]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['NodePoolRootVolumeArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 scale_down_cooldown_time: Optional[pulumi.Input[int]] = None,
                 scall_enable: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if data_volumes is None and not opts.urn:
                raise TypeError("Missing required property 'data_volumes'")
            __props__.__dict__["data_volumes"] = data_volumes
            __props__.__dict__["extend_param"] = extend_param
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            if initial_node_count is None and not opts.urn:
                raise TypeError("Missing required property 'initial_node_count'")
            __props__.__dict__["initial_node_count"] = initial_node_count
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_node_count"] = max_node_count
            __props__.__dict__["max_pods"] = max_pods
            __props__.__dict__["min_node_count"] = min_node_count
            __props__.__dict__["name"] = name
            __props__.__dict__["os"] = os
            __props__.__dict__["password"] = password
            __props__.__dict__["postinstall"] = postinstall
            __props__.__dict__["preinstall"] = preinstall
            __props__.__dict__["priority"] = priority
            __props__.__dict__["region"] = region
            if root_volume is None and not opts.urn:
                raise TypeError("Missing required property 'root_volume'")
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["scale_down_cooldown_time"] = scale_down_cooldown_time
            __props__.__dict__["scall_enable"] = scall_enable
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["type"] = type
            __props__.__dict__["billing_mode"] = None
            __props__.__dict__["current_node_count"] = None
            __props__.__dict__["status"] = None
        super(NodePool, __self__).__init__(
            'huaweicloud:Cce/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            billing_mode: Optional[pulumi.Input[int]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            current_node_count: Optional[pulumi.Input[int]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataVolumeArgs']]]]] = None,
            extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            initial_node_count: Optional[pulumi.Input[int]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            max_node_count: Optional[pulumi.Input[int]] = None,
            max_pods: Optional[pulumi.Input[int]] = None,
            min_node_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            postinstall: Optional[pulumi.Input[str]] = None,
            preinstall: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            root_volume: Optional[pulumi.Input[pulumi.InputType['NodePoolRootVolumeArgs']]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            scale_down_cooldown_time: Optional[pulumi.Input[int]] = None,
            scall_enable: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Default value
               is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        :param pulumi.Input[int] billing_mode: Billing mode of a node.
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] current_node_count: The current number of the nodes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolDataVolumeArgs']]]] data_volumes: Specifies the configuration of the data disks.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] initial_node_count: Specifies the initial number of expected nodes in the node pool.
               This parameter can be also used to manually scale the node count afterwards.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
        :param pulumi.Input[int] max_node_count: Specifies the maximum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] min_node_count: Specifies the minimum number of nodes allowed if auto scaling is enabled.
        :param pulumi.Input[str] name: Specifies the node pool name.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[int] priority: Specifies the weight of the node pool.
               A node pool with a higher weight has a higher priority during scaling.
        :param pulumi.Input[str] region: The region in which to create the CCE pool resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node pool resource.
        :param pulumi.Input[pulumi.InputType['NodePoolRootVolumeArgs']] root_volume: Specifies the configuration of the system disk.
               The structure is described below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] scale_down_cooldown_time: Specifies the time interval between two scaling operations, in minutes.
        :param pulumi.Input[bool] scall_enable: Specifies whether to enable auto scaling.
               If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        :param pulumi.Input[str] status: Node status information.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               The structure is described below.
        :param pulumi.Input[str] type: Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["current_node_count"] = current_node_count
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["extend_param"] = extend_param
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["initial_node_count"] = initial_node_count
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_node_count"] = max_node_count
        __props__.__dict__["max_pods"] = max_pods
        __props__.__dict__["min_node_count"] = min_node_count
        __props__.__dict__["name"] = name
        __props__.__dict__["os"] = os
        __props__.__dict__["password"] = password
        __props__.__dict__["postinstall"] = postinstall
        __props__.__dict__["preinstall"] = preinstall
        __props__.__dict__["priority"] = priority
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["scale_down_cooldown_time"] = scale_down_cooldown_time
        __props__.__dict__["scall_enable"] = scall_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["type"] = type
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the name of the available partition (AZ). Default value
        is random to create nodes in a random AZ in the node pool. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[int]:
        """
        Billing mode of a node.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the cluster ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> pulumi.Output[int]:
        """
        The current number of the nodes.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.NodePoolDataVolume']]:
        """
        Specifies the configuration of the data disks.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Output[int]:
        """
        Specifies the initial number of expected nodes in the node pool.
        This parameter can be also used to manually scale the node count afterwards.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> pulumi.Output[int]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the node pool name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def postinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @property
    @pulumi.getter
    def preinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the weight of the node pool.
        A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the CCE pool resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node pool resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.NodePoolRootVolume']:
        """
        Specifies the configuration of the system disk.
        The structure is described below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the time interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable auto scaling.
        If Autoscaler is enabled, install the autoscaler add-on to use the auto scaling feature.
        """
        return pulumi.get(self, "scall_enable")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolTaint']]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        The structure is described below.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the node pool type. Possible values are: **vm** and **ElasticBMS**.
        """
        return pulumi.get(self, "type")

