# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeAttachArgs', 'NodeAttach']

@pulumi.input_type
class NodeAttachArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 os: pulumi.Input[str],
                 server_id: pulumi.Input[str],
                 docker_base_size: Optional[pulumi.Input[int]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lvm_config: Optional[pulumi.Input[str]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nic_multi_queue: Optional[pulumi.Input[str]] = None,
                 nic_threshold: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]] = None):
        """
        The set of arguments for constructing a NodeAttach resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] os: Specifies the operating System of the node. Changing this parameter will reset the node.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        :param pulumi.Input[str] server_id: Specifies the ecs server ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] docker_base_size: Specifies the available disk space of a single docker container on the
               node in device mapper mode. Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will reset the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] lvm_config: Specifies the docker data disk configurations. The following is an
               example:
        :param pulumi.Input[int] max_pods: Specifies the the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the Node Name.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will reset the node.
        :param pulumi.Input[str] postinstall: Specifies the script required after installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script required before installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the CCE node attach resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node attach resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "os", os)
        pulumi.set(__self__, "server_id", server_id)
        if docker_base_size is not None:
            pulumi.set(__self__, "docker_base_size", docker_base_size)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lvm_config is not None:
            pulumi.set(__self__, "lvm_config", lvm_config)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nic_multi_queue is not None:
            pulumi.set(__self__, "nic_multi_queue", nic_multi_queue)
        if nic_threshold is not None:
            pulumi.set(__self__, "nic_threshold", nic_threshold)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the cluster. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def os(self) -> pulumi.Input[str]:
        """
        Specifies the operating System of the node. Changing this parameter will reset the node.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: pulumi.Input[str]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[str]:
        """
        Specifies the ecs server ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter(name="dockerBaseSize")
    def docker_base_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the available disk space of a single docker container on the
        node in device mapper mode. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "docker_base_size")

    @docker_base_size.setter
    def docker_base_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_base_size", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will reset the node.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lvmConfig")
    def lvm_config(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the docker data disk configurations. The following is an
        example:
        """
        return pulumi.get(self, "lvm_config")

    @lvm_config.setter
    def lvm_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lvm_config", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nicMultiQueue")
    def nic_multi_queue(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "nic_multi_queue")

    @nic_multi_queue.setter
    def nic_multi_queue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nic_multi_queue", value)

    @property
    @pulumi.getter(name="nicThreshold")
    def nic_threshold(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "nic_threshold")

    @nic_threshold.setter
    def nic_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nic_threshold", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will reset the node.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script required after installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script required before installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CCE node attach resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node attach resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]]):
        pulumi.set(self, "taints", value)


@pulumi.input_type
class _NodeAttachState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachDataVolumeArgs']]]] = None,
                 docker_base_size: Optional[pulumi.Input[int]] = None,
                 ecs_group_id: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lvm_config: Optional[pulumi.Input[str]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nic_multi_queue: Optional[pulumi.Input[str]] = None,
                 nic_threshold: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachRootVolumeArgs']]]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]] = None):
        """
        Input properties used for looking up and filtering NodeAttach resources.
        :param pulumi.Input[str] availability_zone: The name of the available partition (AZ).
        :param pulumi.Input[str] charging_mode: The charging mode of the CCE node. Valid values are *prePaid* and *postPaid*.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodeAttachDataVolumeArgs']]] data_volumes: The data disks related configuration.
        :param pulumi.Input[int] docker_base_size: Specifies the available disk space of a single docker container on the
               node in device mapper mode. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ecs_group_id: The Ecs group ID.
        :param pulumi.Input[str] flavor_id: The flavor ID of the CCE node.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will reset the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] lvm_config: Specifies the docker data disk configurations. The following is an
               example:
        :param pulumi.Input[int] max_pods: Specifies the the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the Node Name.
        :param pulumi.Input[str] os: Specifies the operating System of the node. Changing this parameter will reset the node.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will reset the node.
        :param pulumi.Input[str] postinstall: Specifies the script required after installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script required before installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] private_ip: Private IP of the CCE node.
        :param pulumi.Input[str] public_ip: Public IP of the CCE node.
        :param pulumi.Input[str] region: The region in which to create the CCE node attach resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node attach resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodeAttachRootVolumeArgs']]] root_volumes: The system disk related configuration.
        :param pulumi.Input[str] runtime: The runtime of the CCE node.
        :param pulumi.Input[str] server_id: Specifies the ecs server ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] status: Node status information.
        :param pulumi.Input[str] subnet_id: The ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if docker_base_size is not None:
            pulumi.set(__self__, "docker_base_size", docker_base_size)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lvm_config is not None:
            pulumi.set(__self__, "lvm_config", lvm_config)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nic_multi_queue is not None:
            pulumi.set(__self__, "nic_multi_queue", nic_multi_queue)
        if nic_threshold is not None:
            pulumi.set(__self__, "nic_threshold", nic_threshold)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volumes is not None:
            pulumi.set(__self__, "root_volumes", root_volumes)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the available partition (AZ).
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The charging mode of the CCE node. Valid values are *prePaid* and *postPaid*.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the cluster. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachDataVolumeArgs']]]]:
        """
        The data disks related configuration.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="dockerBaseSize")
    def docker_base_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the available disk space of a single docker container on the
        node in device mapper mode. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "docker_base_size")

    @docker_base_size.setter
    def docker_base_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_base_size", value)

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Ecs group ID.
        """
        return pulumi.get(self, "ecs_group_id")

    @ecs_group_id.setter
    def ecs_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_group_id", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor ID of the CCE node.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will reset the node.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lvmConfig")
    def lvm_config(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the docker data disk configurations. The following is an
        example:
        """
        return pulumi.get(self, "lvm_config")

    @lvm_config.setter
    def lvm_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lvm_config", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nicMultiQueue")
    def nic_multi_queue(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "nic_multi_queue")

    @nic_multi_queue.setter
    def nic_multi_queue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nic_multi_queue", value)

    @property
    @pulumi.getter(name="nicThreshold")
    def nic_threshold(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "nic_threshold")

    @nic_threshold.setter
    def nic_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nic_threshold", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operating System of the node. Changing this parameter will reset the node.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will reset the node.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script required after installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script required before installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP of the CCE node.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP of the CCE node.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the CCE node attach resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node attach resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachRootVolumeArgs']]]]:
        """
        The system disk related configuration.
        """
        return pulumi.get(self, "root_volumes")

    @root_volumes.setter
    def root_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachRootVolumeArgs']]]]):
        pulumi.set(self, "root_volumes", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime of the CCE node.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ecs server ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeAttachTaintArgs']]]]):
        pulumi.set(self, "taints", value)


class NodeAttach(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 docker_base_size: Optional[pulumi.Input[int]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lvm_config: Optional[pulumi.Input[str]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nic_multi_queue: Optional[pulumi.Input[str]] = None,
                 nic_threshold: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachTaintArgs']]]]] = None,
                 __props__=None):
        """
        Add a node from an existing ecs server to a CCE cluster.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.cce.NodeAttach("test",
            cluster_id=var["cluster_id"],
            server_id=var["server_id"],
            key_pair=var["keypair_name"],
            os="EulerOS 2.5",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] docker_base_size: Specifies the available disk space of a single docker container on the
               node in device mapper mode. Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will reset the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] lvm_config: Specifies the docker data disk configurations. The following is an
               example:
        :param pulumi.Input[int] max_pods: Specifies the the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the Node Name.
        :param pulumi.Input[str] os: Specifies the operating System of the node. Changing this parameter will reset the node.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will reset the node.
        :param pulumi.Input[str] postinstall: Specifies the script required after installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script required before installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the CCE node attach resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node attach resource.
        :param pulumi.Input[str] server_id: Specifies the ecs server ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeAttachArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Add a node from an existing ecs server to a CCE cluster.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.cce.NodeAttach("test",
            cluster_id=var["cluster_id"],
            server_id=var["server_id"],
            key_pair=var["keypair_name"],
            os="EulerOS 2.5",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        :param str resource_name: The name of the resource.
        :param NodeAttachArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeAttachArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 docker_base_size: Optional[pulumi.Input[int]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lvm_config: Optional[pulumi.Input[str]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nic_multi_queue: Optional[pulumi.Input[str]] = None,
                 nic_threshold: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachTaintArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeAttachArgs.__new__(NodeAttachArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["docker_base_size"] = docker_base_size
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lvm_config"] = lvm_config
            __props__.__dict__["max_pods"] = max_pods
            __props__.__dict__["name"] = name
            __props__.__dict__["nic_multi_queue"] = nic_multi_queue
            __props__.__dict__["nic_threshold"] = nic_threshold
            if os is None and not opts.urn:
                raise TypeError("Missing required property 'os'")
            __props__.__dict__["os"] = os
            __props__.__dict__["password"] = password
            __props__.__dict__["postinstall"] = postinstall
            __props__.__dict__["preinstall"] = preinstall
            __props__.__dict__["region"] = region
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["availability_zone"] = None
            __props__.__dict__["charging_mode"] = None
            __props__.__dict__["data_volumes"] = None
            __props__.__dict__["ecs_group_id"] = None
            __props__.__dict__["flavor_id"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["root_volumes"] = None
            __props__.__dict__["runtime"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_id"] = None
        super(NodeAttach, __self__).__init__(
            'huaweicloud:Cce/nodeAttach:NodeAttach',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachDataVolumeArgs']]]]] = None,
            docker_base_size: Optional[pulumi.Input[int]] = None,
            ecs_group_id: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lvm_config: Optional[pulumi.Input[str]] = None,
            max_pods: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nic_multi_queue: Optional[pulumi.Input[str]] = None,
            nic_threshold: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            postinstall: Optional[pulumi.Input[str]] = None,
            preinstall: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            root_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachRootVolumeArgs']]]]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            server_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachTaintArgs']]]]] = None) -> 'NodeAttach':
        """
        Get an existing NodeAttach resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The name of the available partition (AZ).
        :param pulumi.Input[str] charging_mode: The charging mode of the CCE node. Valid values are *prePaid* and *postPaid*.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachDataVolumeArgs']]]] data_volumes: The data disks related configuration.
        :param pulumi.Input[int] docker_base_size: Specifies the available disk space of a single docker container on the
               node in device mapper mode. Changing this parameter will create a new resource.
        :param pulumi.Input[str] ecs_group_id: The Ecs group ID.
        :param pulumi.Input[str] flavor_id: The flavor ID of the CCE node.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will reset the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] lvm_config: Specifies the docker data disk configurations. The following is an
               example:
        :param pulumi.Input[int] max_pods: Specifies the the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the Node Name.
        :param pulumi.Input[str] os: Specifies the operating System of the node. Changing this parameter will reset the node.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will reset the node.
        :param pulumi.Input[str] postinstall: Specifies the script required after installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script required before installation. The input value can be
               a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] private_ip: Private IP of the CCE node.
        :param pulumi.Input[str] public_ip: Public IP of the CCE node.
        :param pulumi.Input[str] region: The region in which to create the CCE node attach resource. If omitted, the
               provider-level region will be used. Changing this creates a new CCE node attach resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachRootVolumeArgs']]]] root_volumes: The system disk related configuration.
        :param pulumi.Input[str] runtime: The runtime of the CCE node.
        :param pulumi.Input[str] server_id: Specifies the ecs server ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] status: Node status information.
        :param pulumi.Input[str] subnet_id: The ID of the subnet to which the NIC belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeAttachTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeAttachState.__new__(_NodeAttachState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["docker_base_size"] = docker_base_size
        __props__.__dict__["ecs_group_id"] = ecs_group_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lvm_config"] = lvm_config
        __props__.__dict__["max_pods"] = max_pods
        __props__.__dict__["name"] = name
        __props__.__dict__["nic_multi_queue"] = nic_multi_queue
        __props__.__dict__["nic_threshold"] = nic_threshold
        __props__.__dict__["os"] = os
        __props__.__dict__["password"] = password
        __props__.__dict__["postinstall"] = postinstall
        __props__.__dict__["preinstall"] = preinstall
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volumes"] = root_volumes
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        return NodeAttach(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The name of the available partition (AZ).
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        The charging mode of the CCE node. Valid values are *prePaid* and *postPaid*.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the cluster. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.NodeAttachDataVolume']]:
        """
        The data disks related configuration.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="dockerBaseSize")
    def docker_base_size(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the available disk space of a single docker container on the
        node in device mapper mode. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "docker_base_size")

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> pulumi.Output[str]:
        """
        The Ecs group ID.
        """
        return pulumi.get(self, "ecs_group_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        The flavor ID of the CCE node.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will reset the node.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lvmConfig")
    def lvm_config(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the docker data disk configurations. The following is an
        example:
        """
        return pulumi.get(self, "lvm_config")

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the Node Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nicMultiQueue")
    def nic_multi_queue(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "nic_multi_queue")

    @property
    @pulumi.getter(name="nicThreshold")
    def nic_threshold(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "nic_threshold")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        Specifies the operating System of the node. Changing this parameter will reset the node.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will reset the node.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def postinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script required after installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @property
    @pulumi.getter
    def preinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script required before installation. The input value can be
        a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP of the CCE node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Public IP of the CCE node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the CCE node attach resource. If omitted, the
        provider-level region will be used. Changing this creates a new CCE node attach resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> pulumi.Output[Sequence['outputs.NodeAttachRootVolume']]:
        """
        The system disk related configuration.
        """
        return pulumi.get(self, "root_volumes")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        The runtime of the CCE node.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[str]:
        """
        Specifies the ecs server ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Node status information.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodeAttachTaint']]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

