# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeArgs', 'Node']

@pulumi.input_type
class NodeArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 cluster_id: pulumi.Input[str],
                 data_volumes: pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]],
                 flavor_id: pulumi.Input[str],
                 root_volume: pulumi.Input['NodeRootVolumeArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 billing_mode: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 ecs_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_performance_type: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extend_param_charging_mode: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 keep_ecs: Optional[pulumi.Input[bool]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input['NodeStorageArgs']] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]] = None):
        """
        The set of arguments for constructing a Node resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]] data_volumes: Specifies the configurations of the data disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input['NodeRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Specifies the bandwidth billing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the bandwidth size.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the CCE node. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of the EIP.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] fixed_ip: Specifies the fixed IP of the NIC.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] iptype: Specifies the elastic IP type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
               + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the CCE node. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the CCE node.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCE node resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        :param pulumi.Input[str] runtime: Specifies the runtime of the CCE node. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[str] sharetype: Specifies the bandwidth sharing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input['NodeStorageArgs'] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "data_volumes", data_volumes)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "root_volume", root_volume)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if billing_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""billing_mode is deprecated: use charging_mode instead""")
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if ecs_performance_type is not None:
            pulumi.set(__self__, "ecs_performance_type", ecs_performance_type)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eip_ids is not None:
            warnings.warn("""use eip_id instead""", DeprecationWarning)
            pulumi.log.warn("""eip_ids is deprecated: use eip_id instead""")
        if eip_ids is not None:
            pulumi.set(__self__, "eip_ids", eip_ids)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_param_charging_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""extend_param_charging_mode is deprecated: use charging_mode instead""")
        if extend_param_charging_mode is not None:
            pulumi.set(__self__, "extend_param_charging_mode", extend_param_charging_mode)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if keep_ecs is not None:
            pulumi.set(__self__, "keep_ecs", keep_ecs)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_id is not None:
            warnings.warn("""will be removed after v1.26.0""", DeprecationWarning)
            pulumi.log.warn("""order_id is deprecated: will be removed after v1.26.0""")
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the name of the available partition (AZ). Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]]:
        """
        Specifies the configurations of the data disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Input['NodeRootVolumeArgs']:
        """
        Specifies the configuration of the system disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: pulumi.Input['NodeRootVolumeArgs']):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth billing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the bandwidth size.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the CCE node. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @ecs_group_id.setter
    def ecs_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_group_id", value)

    @property
    @pulumi.getter(name="ecsPerformanceType")
    def ecs_performance_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ecs_performance_type")

    @ecs_performance_type.setter
    def ecs_performance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_performance_type", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the EIP.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "eip_ids")

    @eip_ids.setter
    def eip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "eip_ids", value)

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_param", value)

    @property
    @pulumi.getter(name="extendParamChargingMode")
    def extend_param_charging_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "extend_param_charging_mode")

    @extend_param_charging_mode.setter
    def extend_param_charging_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extend_param_charging_mode", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the fixed IP of the NIC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the elastic IP type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="keepEcs")
    def keep_ecs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "keep_ecs")

    @keep_ecs.setter
    def keep_ecs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_ecs", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
        and **user** are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_id", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the CCE node. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the CCE node.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCE node resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the runtime of the CCE node. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth sharing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['NodeStorageArgs']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['NodeStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]):
        pulumi.set(self, "taints", value)


@pulumi.input_type
class _NodeState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 billing_mode: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]]] = None,
                 ecs_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_performance_type: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extend_param_charging_mode: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 keep_ecs: Optional[pulumi.Input[bool]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input['NodeRootVolumeArgs']] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input['NodeStorageArgs']] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]] = None):
        """
        Input properties used for looking up and filtering Node resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Specifies the bandwidth billing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the bandwidth size.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the CCE node. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]] data_volumes: Specifies the configurations of the data disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of the EIP.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] fixed_ip: Specifies the fixed IP of the NIC.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] iptype: Specifies the elastic IP type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
               + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the CCE node. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the CCE node.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] private_ip: Private IP of the CCE node.
        :param pulumi.Input[str] public_ip: Public IP of the CCE node.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCE node resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        :param pulumi.Input['NodeRootVolumeArgs'] root_volume: Specifies the configuration of the system disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the runtime of the CCE node. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[str] server_id: ID of the ECS instance associated with the node.
        :param pulumi.Input[str] sharetype: Specifies the bandwidth sharing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input['NodeStorageArgs'] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bandwidth_charge_mode is not None:
            pulumi.set(__self__, "bandwidth_charge_mode", bandwidth_charge_mode)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if billing_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""billing_mode is deprecated: use charging_mode instead""")
        if billing_mode is not None:
            pulumi.set(__self__, "billing_mode", billing_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if ecs_group_id is not None:
            pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if ecs_performance_type is not None:
            pulumi.set(__self__, "ecs_performance_type", ecs_performance_type)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eip_ids is not None:
            warnings.warn("""use eip_id instead""", DeprecationWarning)
            pulumi.log.warn("""eip_ids is deprecated: use eip_id instead""")
        if eip_ids is not None:
            pulumi.set(__self__, "eip_ids", eip_ids)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if extend_param_charging_mode is not None:
            warnings.warn("""use charging_mode instead""", DeprecationWarning)
            pulumi.log.warn("""extend_param_charging_mode is deprecated: use charging_mode instead""")
        if extend_param_charging_mode is not None:
            pulumi.set(__self__, "extend_param_charging_mode", extend_param_charging_mode)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if iptype is not None:
            pulumi.set(__self__, "iptype", iptype)
        if keep_ecs is not None:
            pulumi.set(__self__, "keep_ecs", keep_ecs)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_id is not None:
            warnings.warn("""will be removed after v1.26.0""", DeprecationWarning)
            pulumi.log.warn("""order_id is deprecated: will be removed after v1.26.0""")
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if postinstall is not None:
            pulumi.set(__self__, "postinstall", postinstall)
        if preinstall is not None:
            pulumi.set(__self__, "preinstall", preinstall)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if sharetype is not None:
            pulumi.set(__self__, "sharetype", sharetype)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the available partition (AZ). Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth billing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @bandwidth_charge_mode.setter
    def bandwidth_charge_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_charge_mode", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the bandwidth size.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "billing_mode")

    @billing_mode.setter
    def billing_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "billing_mode", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the CCE node. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]]]:
        """
        Specifies the configurations of the data disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @ecs_group_id.setter
    def ecs_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_group_id", value)

    @property
    @pulumi.getter(name="ecsPerformanceType")
    def ecs_performance_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ecs_performance_type")

    @ecs_performance_type.setter
    def ecs_performance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_performance_type", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the EIP.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "eip_ids")

    @eip_ids.setter
    def eip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "eip_ids", value)

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_param", value)

    @property
    @pulumi.getter(name="extendParamChargingMode")
    def extend_param_charging_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "extend_param_charging_mode")

    @extend_param_charging_mode.setter
    def extend_param_charging_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extend_param_charging_mode", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the fixed IP of the NIC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter
    def iptype(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the elastic IP type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @iptype.setter
    def iptype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iptype", value)

    @property
    @pulumi.getter(name="keepEcs")
    def keep_ecs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "keep_ecs")

    @keep_ecs.setter
    def keep_ecs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_ecs", value)

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
        and **user** are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_id", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the CCE node. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the CCE node.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def postinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @postinstall.setter
    def postinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postinstall", value)

    @property
    @pulumi.getter
    def preinstall(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @preinstall.setter
    def preinstall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preinstall", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP of the CCE node.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP of the CCE node.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the CCE node resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['NodeRootVolumeArgs']]:
        """
        Specifies the configuration of the system disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['NodeRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the runtime of the CCE node. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the ECS instance associated with the node.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter
    def sharetype(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the bandwidth sharing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @sharetype.setter
    def sharetype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sharetype", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['NodeStorageArgs']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['NodeStorageArgs']]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeTaintArgs']]]]):
        pulumi.set(self, "taints", value)


class Node(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 billing_mode: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeDataVolumeArgs']]]]] = None,
                 ecs_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_performance_type: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extend_param_charging_mode: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 keep_ecs: Optional[pulumi.Input[bool]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['NodeRootVolumeArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['NodeStorageArgs']]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeTaintArgs']]]]] = None,
                 __props__=None):
        """
        Add a node to a CCE cluster.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myaz = huaweicloud.get_availability_zones()
        mykp = huaweicloud.ecs.Keypair("mykp", public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDAjpC1hwiOCCmKEWxJ4qzTTsJbKzndLo1BCz5PcwtUnflmU+gHJtWMZKpuEGVi29h0A/+ydKek1O18k10Ff+4tyFjiHDQAT9+OfgWf7+b1yK+qDip3X1C0UPMbwHlTfSGWLGZquwhvEFx9k3h/M+VtMvwR1lJ9LUyTAImnNjWG7TAIPmui30HvM2UiFEmqkr4ijq45MyX2+fLIePLRIFuu1p4whjHAQYufqyno3BS48icQb4p6iVEZPo4AE2o9oIyQvj2mx4dk5Y8CgSETOZTYDOR3rU2fZTRDRgPJDH9FWvQjF5tA0p3d9CoWWd2s6GKKbfoUIi8R/Db1BSPJwkqB jrp-hp-pc")
        mycluster = huaweicloud.cce.Cluster("mycluster",
            cluster_type="VirtualMachine",
            flavor_id="cce.s1.small",
            vpc_id=huaweicloud_vpc["myvpc"]["id"],
            subnet_id=huaweicloud_vpc_subnet["mysubnet"]["id"],
            container_network_type="overlay_l2")
        node = huaweicloud.cce.Node("node",
            cluster_id=mycluster.id,
            flavor_id="s3.large.2",
            availability_zone=myaz.names[0],
            key_pair=mykp.name,
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )])
        ```

        ## Node with Eip

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )],
            iptype="5_bgp",
            bandwidth_charge_mode="traffic",
            sharetype="PER",
            bandwidth_size=100)
        ```

        ## Node with Existing Eip

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myeip = huaweicloud.vpc.Eip("myeip",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=8,
                share_type="PER",
                charge_mode="traffic",
            ))
        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )],
            eip_id=myeip.id)
        ```

        ## Node with storage configuration

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SSD",
            ),
            data_volumes=[
                huaweicloud.cce.NodeDataVolumeArgs(
                    size=100,
                    volumetype="SSD",
                ),
                huaweicloud.cce.NodeDataVolumeArgs(
                    size=100,
                    volumetype="SSD",
                    kms_key_id=huaweicloud_kms_key["mykey"]["id"],
                ),
            ],
            storage=huaweicloud.cce.NodeStorageArgs(
                selectors=[
                    huaweicloud.cce.NodeStorageSelectorArgs(
                        name="cceUse",
                        type="evs",
                        match_label_size="100",
                        match_label_count="1",
                    ),
                    huaweicloud.cce.NodeStorageSelectorArgs(
                        name="user",
                        type="evs",
                        match_label_size="100",
                        match_label_metadata_encrypted="1",
                        match_label_metadata_cmkid=huaweicloud_kms_key["mykey"]["id"],
                        match_label_count="1",
                    ),
                ],
                groups=[
                    huaweicloud.cce.NodeStorageGroupArgs(
                        name="vgpaas",
                        selector_names=["cceUse"],
                        cce_managed=True,
                        virtual_spaces=[
                            huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                                name="kubernetes",
                                size="10%",
                                lvm_lv_type="linear",
                            ),
                            huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                                name="runtime",
                                size="90%",
                                lvm_lv_type="linear",
                            ),
                        ],
                    ),
                    huaweicloud.cce.NodeStorageGroupArgs(
                        name="vguser",
                        selector_names=["user"],
                        virtual_spaces=[huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                            name="user",
                            size="100%",
                            lvm_lv_type="linear",
                            lvm_path="/workspace",
                        )],
                    ),
                ],
            ))
        ```

        ## Import

        CCE node can be imported using the cluster ID and node ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/node:Node my_node 5c20fdad-7288-11eb-b817-0255ac10158b/e9287dff-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `fixed_ip`, `eip_id`, `preinstall`, `postinstall`, `iptype`, `bandwidth_charge_mode`, `bandwidth_size`, `share_type`, `max_pods`, `extend_param`, `labels`, `taints` and arguments for pre-paid. It is generally recommended running `terraform plan` after importing a node. You can then decide if changes should be applied to the node, or the resource definition should be updated to align with the node. Also you can ignore changes as below. resource "huaweicloud_cce_node" "my_node" {

         ...

         lifecycle {

         ignore_changes = [

         extend_param, labels,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Specifies the bandwidth billing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the bandwidth size.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the CCE node. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeDataVolumeArgs']]]] data_volumes: Specifies the configurations of the data disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of the EIP.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] fixed_ip: Specifies the fixed IP of the NIC.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] iptype: Specifies the elastic IP type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
               + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the CCE node. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the CCE node.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCE node resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        :param pulumi.Input[pulumi.InputType['NodeRootVolumeArgs']] root_volume: Specifies the configuration of the system disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the runtime of the CCE node. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[str] sharetype: Specifies the bandwidth sharing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['NodeStorageArgs']] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Add a node to a CCE cluster.

        ## Basic Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myaz = huaweicloud.get_availability_zones()
        mykp = huaweicloud.ecs.Keypair("mykp", public_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDAjpC1hwiOCCmKEWxJ4qzTTsJbKzndLo1BCz5PcwtUnflmU+gHJtWMZKpuEGVi29h0A/+ydKek1O18k10Ff+4tyFjiHDQAT9+OfgWf7+b1yK+qDip3X1C0UPMbwHlTfSGWLGZquwhvEFx9k3h/M+VtMvwR1lJ9LUyTAImnNjWG7TAIPmui30HvM2UiFEmqkr4ijq45MyX2+fLIePLRIFuu1p4whjHAQYufqyno3BS48icQb4p6iVEZPo4AE2o9oIyQvj2mx4dk5Y8CgSETOZTYDOR3rU2fZTRDRgPJDH9FWvQjF5tA0p3d9CoWWd2s6GKKbfoUIi8R/Db1BSPJwkqB jrp-hp-pc")
        mycluster = huaweicloud.cce.Cluster("mycluster",
            cluster_type="VirtualMachine",
            flavor_id="cce.s1.small",
            vpc_id=huaweicloud_vpc["myvpc"]["id"],
            subnet_id=huaweicloud_vpc_subnet["mysubnet"]["id"],
            container_network_type="overlay_l2")
        node = huaweicloud.cce.Node("node",
            cluster_id=mycluster.id,
            flavor_id="s3.large.2",
            availability_zone=myaz.names[0],
            key_pair=mykp.name,
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )])
        ```

        ## Node with Eip

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )],
            iptype="5_bgp",
            bandwidth_charge_mode="traffic",
            sharetype="PER",
            bandwidth_size=100)
        ```

        ## Node with Existing Eip

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        myeip = huaweicloud.vpc.Eip("myeip",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=8,
                share_type="PER",
                charge_mode="traffic",
            ))
        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SATA",
            ),
            data_volumes=[huaweicloud.cce.NodeDataVolumeArgs(
                size=100,
                volumetype="SATA",
            )],
            eip_id=myeip.id)
        ```

        ## Node with storage configuration

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        mynode = huaweicloud.cce.Node("mynode",
            cluster_id=huaweicloud_cce_cluster["mycluster"]["id"],
            flavor_id="s3.large.2",
            availability_zone=data["huaweicloud_availability_zones"]["myaz"]["names"],
            key_pair=huaweicloud_compute_keypair["mykp"]["name"],
            root_volume=huaweicloud.cce.NodeRootVolumeArgs(
                size=40,
                volumetype="SSD",
            ),
            data_volumes=[
                huaweicloud.cce.NodeDataVolumeArgs(
                    size=100,
                    volumetype="SSD",
                ),
                huaweicloud.cce.NodeDataVolumeArgs(
                    size=100,
                    volumetype="SSD",
                    kms_key_id=huaweicloud_kms_key["mykey"]["id"],
                ),
            ],
            storage=huaweicloud.cce.NodeStorageArgs(
                selectors=[
                    huaweicloud.cce.NodeStorageSelectorArgs(
                        name="cceUse",
                        type="evs",
                        match_label_size="100",
                        match_label_count="1",
                    ),
                    huaweicloud.cce.NodeStorageSelectorArgs(
                        name="user",
                        type="evs",
                        match_label_size="100",
                        match_label_metadata_encrypted="1",
                        match_label_metadata_cmkid=huaweicloud_kms_key["mykey"]["id"],
                        match_label_count="1",
                    ),
                ],
                groups=[
                    huaweicloud.cce.NodeStorageGroupArgs(
                        name="vgpaas",
                        selector_names=["cceUse"],
                        cce_managed=True,
                        virtual_spaces=[
                            huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                                name="kubernetes",
                                size="10%",
                                lvm_lv_type="linear",
                            ),
                            huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                                name="runtime",
                                size="90%",
                                lvm_lv_type="linear",
                            ),
                        ],
                    ),
                    huaweicloud.cce.NodeStorageGroupArgs(
                        name="vguser",
                        selector_names=["user"],
                        virtual_spaces=[huaweicloud.cce.NodeStorageGroupVirtualSpaceArgs(
                            name="user",
                            size="100%",
                            lvm_lv_type="linear",
                            lvm_path="/workspace",
                        )],
                    ),
                ],
            ))
        ```

        ## Import

        CCE node can be imported using the cluster ID and node ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Cce/node:Node my_node 5c20fdad-7288-11eb-b817-0255ac10158b/e9287dff-7288-11eb-b817-0255ac10158b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `fixed_ip`, `eip_id`, `preinstall`, `postinstall`, `iptype`, `bandwidth_charge_mode`, `bandwidth_size`, `share_type`, `max_pods`, `extend_param`, `labels`, `taints` and arguments for pre-paid. It is generally recommended running `terraform plan` after importing a node. You can then decide if changes should be applied to the node, or the resource definition should be updated to align with the node. Also you can ignore changes as below. resource "huaweicloud_cce_node" "my_node" {

         ...

         lifecycle {

         ignore_changes = [

         extend_param, labels,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param NodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 billing_mode: Optional[pulumi.Input[int]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeDataVolumeArgs']]]]] = None,
                 ecs_group_id: Optional[pulumi.Input[str]] = None,
                 ecs_performance_type: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extend_param_charging_mode: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 iptype: Optional[pulumi.Input[str]] = None,
                 keep_ecs: Optional[pulumi.Input[bool]] = None,
                 key_pair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 postinstall: Optional[pulumi.Input[str]] = None,
                 preinstall: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['NodeRootVolumeArgs']]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 sharetype: Optional[pulumi.Input[str]] = None,
                 storage: Optional[pulumi.Input[pulumi.InputType['NodeStorageArgs']]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeTaintArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeArgs.__new__(NodeArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            if billing_mode is not None and not opts.urn:
                warnings.warn("""use charging_mode instead""", DeprecationWarning)
                pulumi.log.warn("""billing_mode is deprecated: use charging_mode instead""")
            __props__.__dict__["billing_mode"] = billing_mode
            __props__.__dict__["charging_mode"] = charging_mode
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if data_volumes is None and not opts.urn:
                raise TypeError("Missing required property 'data_volumes'")
            __props__.__dict__["data_volumes"] = data_volumes
            __props__.__dict__["ecs_group_id"] = ecs_group_id
            __props__.__dict__["ecs_performance_type"] = ecs_performance_type
            __props__.__dict__["eip_id"] = eip_id
            if eip_ids is not None and not opts.urn:
                warnings.warn("""use eip_id instead""", DeprecationWarning)
                pulumi.log.warn("""eip_ids is deprecated: use eip_id instead""")
            __props__.__dict__["eip_ids"] = eip_ids
            __props__.__dict__["extend_param"] = extend_param
            if extend_param_charging_mode is not None and not opts.urn:
                warnings.warn("""use charging_mode instead""", DeprecationWarning)
                pulumi.log.warn("""extend_param_charging_mode is deprecated: use charging_mode instead""")
            __props__.__dict__["extend_param_charging_mode"] = extend_param_charging_mode
            __props__.__dict__["fixed_ip"] = fixed_ip
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["iptype"] = iptype
            __props__.__dict__["keep_ecs"] = keep_ecs
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_pods"] = max_pods
            __props__.__dict__["name"] = name
            if order_id is not None and not opts.urn:
                warnings.warn("""will be removed after v1.26.0""", DeprecationWarning)
                pulumi.log.warn("""order_id is deprecated: will be removed after v1.26.0""")
            __props__.__dict__["order_id"] = order_id
            __props__.__dict__["os"] = os
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["postinstall"] = postinstall
            __props__.__dict__["preinstall"] = preinstall
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["region"] = region
            if root_volume is None and not opts.urn:
                raise TypeError("Missing required property 'root_volume'")
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["sharetype"] = sharetype
            __props__.__dict__["storage"] = storage
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["server_id"] = None
            __props__.__dict__["status"] = None
        super(Node, __self__).__init__(
            'huaweicloud:Cce/node:Node',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            bandwidth_charge_mode: Optional[pulumi.Input[str]] = None,
            bandwidth_size: Optional[pulumi.Input[int]] = None,
            billing_mode: Optional[pulumi.Input[int]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeDataVolumeArgs']]]]] = None,
            ecs_group_id: Optional[pulumi.Input[str]] = None,
            ecs_performance_type: Optional[pulumi.Input[str]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            extend_param_charging_mode: Optional[pulumi.Input[int]] = None,
            fixed_ip: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            iptype: Optional[pulumi.Input[str]] = None,
            keep_ecs: Optional[pulumi.Input[bool]] = None,
            key_pair: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            max_pods: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            order_id: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            postinstall: Optional[pulumi.Input[str]] = None,
            preinstall: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            root_volume: Optional[pulumi.Input[pulumi.InputType['NodeRootVolumeArgs']]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            server_id: Optional[pulumi.Input[str]] = None,
            sharetype: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage: Optional[pulumi.Input[pulumi.InputType['NodeStorageArgs']]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeTaintArgs']]]]] = None) -> 'Node':
        """
        Get an existing Node resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the name of the available partition (AZ). Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] bandwidth_charge_mode: Specifies the bandwidth billing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] bandwidth_size: Specifies the bandwidth size.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the CCE node. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[str] cluster_id: Specifies the ID of the cluster.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeDataVolumeArgs']]]] data_volumes: Specifies the configurations of the data disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] ecs_group_id: Specifies the ECS group ID. If specified, the node will be created under
               the cloud server group. Changing this parameter will create a new resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of the EIP.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_param: Specifies the extended parameter.
               Changing this parameter will create a new resource.
               The available keys are as follows:
               + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
               + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
               + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
               + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        :param pulumi.Input[str] fixed_ip: Specifies the fixed IP of the NIC.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] iptype: Specifies the elastic IP type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] key_pair: Specifies the key pair name when logging in to select the key pair mode.
               This parameter and `password` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Specifies the tags of a Kubernetes node, key/value pair format.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] max_pods: Specifies the maximum number of instances a node is allowed to create.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
               and **user** are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] os: Specifies the operating system of the node.
               Changing this parameter will create a new resource.
               + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
               + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        :param pulumi.Input[str] password: Specifies the root password when logging in to select the password mode.
               This parameter can be plain or salted and is alternative to `key_pair`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] period: Specifies the charging period of the CCE node. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the CCE node.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[str] postinstall: Specifies the script to be executed after installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] preinstall: Specifies the script to be executed before installation.
               The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        :param pulumi.Input[str] private_ip: Private IP of the CCE node.
        :param pulumi.Input[str] public_ip: Public IP of the CCE node.
        :param pulumi.Input[str] region: Specifies the region in which to create the CCE node resource.
               If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        :param pulumi.Input[pulumi.InputType['NodeRootVolumeArgs']] root_volume: Specifies the configuration of the system disk.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] runtime: Specifies the runtime of the CCE node. Valid values are *docker* and
               *containerd*. Changing this creates a new resource.
        :param pulumi.Input[str] server_id: ID of the ECS instance associated with the node.
        :param pulumi.Input[str] sharetype: Specifies the bandwidth sharing type.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['NodeStorageArgs']] storage: Specifies the disk initialization management parameter.
               If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
               This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the subnet to which the NIC belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of a VM node, key/value pair format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodeTaintArgs']]]] taints: Specifies the taints configuration of the nodes to set anti-affinity.
               Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeState.__new__(_NodeState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["bandwidth_charge_mode"] = bandwidth_charge_mode
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["billing_mode"] = billing_mode
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["ecs_group_id"] = ecs_group_id
        __props__.__dict__["ecs_performance_type"] = ecs_performance_type
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["eip_ids"] = eip_ids
        __props__.__dict__["extend_param"] = extend_param
        __props__.__dict__["extend_param_charging_mode"] = extend_param_charging_mode
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["iptype"] = iptype
        __props__.__dict__["keep_ecs"] = keep_ecs
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_pods"] = max_pods
        __props__.__dict__["name"] = name
        __props__.__dict__["order_id"] = order_id
        __props__.__dict__["os"] = os
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["postinstall"] = postinstall
        __props__.__dict__["preinstall"] = preinstall
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["sharetype"] = sharetype
        __props__.__dict__["status"] = status
        __props__.__dict__["storage"] = storage
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        return Node(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the name of the available partition (AZ). Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="bandwidthChargeMode")
    def bandwidth_charge_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the bandwidth billing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_charge_mode")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the bandwidth size.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> pulumi.Output[int]:
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the CCE node. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the cluster.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.NodeDataVolume']]:
        """
        Specifies the configurations of the data disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ECS group ID. If specified, the node will be created under
        the cloud server group. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ecs_group_id")

    @property
    @pulumi.getter(name="ecsPerformanceType")
    def ecs_performance_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "ecs_performance_type")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the EIP.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "eip_ids")

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the extended parameter.
        Changing this parameter will create a new resource.
        The available keys are as follows:
        + **agency_name**: The agency name to provide temporary credentials for CCE node to access other cloud services.
        + **alpha.cce/NodeImageID**: The custom image ID used to create the BMS nodes.
        + **dockerBaseSize**: The available disk space of a single docker container on the node in device mapper mode.
        + **DockerLVMConfigOverride**: Specifies the data disk configurations of Docker.
        """
        return pulumi.get(self, "extend_param")

    @property
    @pulumi.getter(name="extendParamChargingMode")
    def extend_param_charging_mode(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "extend_param_charging_mode")

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the fixed IP of the NIC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def iptype(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the elastic IP type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "iptype")

    @property
    @pulumi.getter(name="keepEcs")
    def keep_ecs(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "keep_ecs")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the key pair name when logging in to select the key pair mode.
        This parameter and `password` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a Kubernetes node, key/value pair format.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the maximum number of instances a node is allowed to create.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "max_pods")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the virtual space name. Currently, only **kubernetes**, **runtime**,
        and **user** are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "order_id")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        Specifies the operating system of the node.
        Changing this parameter will create a new resource.
        + For VM nodes, clusters of v1.13 and later support *EulerOS 2.5* and *CentOS 7.6*.
        + For BMS nodes purchased in the yearly/monthly billing mode, only *EulerOS 2.3* is supported.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the root password when logging in to select the password mode.
        This parameter can be plain or salted and is alternative to `key_pair`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the CCE node. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the CCE node.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def postinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script to be executed after installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "postinstall")

    @property
    @pulumi.getter
    def preinstall(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the script to be executed before installation.
        The input value can be a Base64 encoded string or not. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "preinstall")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP of the CCE node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Public IP of the CCE node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the CCE node resource.
        If omitted, the provider-level region will be used. Changing this creates a new CCE node resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.NodeRootVolume']:
        """
        Specifies the configuration of the system disk.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "root_volume")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Specifies the runtime of the CCE node. Valid values are *docker* and
        *containerd*. Changing this creates a new resource.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[str]:
        """
        ID of the ECS instance associated with the node.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def sharetype(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the bandwidth sharing type.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "sharetype")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional['outputs.NodeStorage']]:
        """
        Specifies the disk initialization management parameter.
        If omitted, disks are managed based on the DockerLVMConfigOverride parameter in extendParam.
        This parameter is supported for clusters of v1.15.11 and later. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the subnet to which the NIC belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodeTaint']]]:
        """
        Specifies the taints configuration of the nodes to set anti-affinity.
        Changing this parameter will create a new resource. Each taint contains the following parameters:
        """
        return pulumi.get(self, "taints")

