# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodeResult',
    'AwaitableGetNodeResult',
    'get_node',
    'get_node_output',
]

@pulumi.output_type
class GetNodeResult:
    """
    A collection of values returned by getNode.
    """
    def __init__(__self__, availability_zone=None, billing_mode=None, cluster_id=None, data_volumes=None, ecs_group_id=None, flavor_id=None, id=None, key_pair=None, name=None, node_id=None, os=None, private_ip=None, public_ip=None, region=None, root_volumes=None, server_id=None, status=None, subnet_id=None, tags=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if billing_mode and not isinstance(billing_mode, int):
            raise TypeError("Expected argument 'billing_mode' to be a int")
        pulumi.set(__self__, "billing_mode", billing_mode)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if data_volumes and not isinstance(data_volumes, list):
            raise TypeError("Expected argument 'data_volumes' to be a list")
        pulumi.set(__self__, "data_volumes", data_volumes)
        if ecs_group_id and not isinstance(ecs_group_id, str):
            raise TypeError("Expected argument 'ecs_group_id' to be a str")
        pulumi.set(__self__, "ecs_group_id", ecs_group_id)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_volumes and not isinstance(root_volumes, list):
            raise TypeError("Expected argument 'root_volumes' to be a list")
        pulumi.set(__self__, "root_volumes", root_volumes)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Available partitions where the node is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> int:
        """
        Node's billing mode: The value is 0 (on demand).
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Sequence['outputs.GetNodeDataVolumeResult']:
        """
        Represents the data disk to be created. Structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="ecsGroupId")
    def ecs_group_id(self) -> str:
        """
        The ID of ECS group to which the node belongs.
        """
        return pulumi.get(self, "ecs_group_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> str:
        """
        The flavor ID to be used.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> str:
        """
        Key pair name when logging in to select the key pair mode.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter
    def os(self) -> str:
        """
        Operating System of the node.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Private IP of the node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        Elastic IP parameters of the node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetNodeRootVolumeResult']:
        """
        It corresponds to the system disk related configuration. Structure is documented below.
        """
        return pulumi.get(self, "root_volumes")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        The node's virtual machine ID in ECS.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNodeResult(GetNodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeResult(
            availability_zone=self.availability_zone,
            billing_mode=self.billing_mode,
            cluster_id=self.cluster_id,
            data_volumes=self.data_volumes,
            ecs_group_id=self.ecs_group_id,
            flavor_id=self.flavor_id,
            id=self.id,
            key_pair=self.key_pair,
            name=self.name,
            node_id=self.node_id,
            os=self.os,
            private_ip=self.private_ip,
            public_ip=self.public_ip,
            region=self.region,
            root_volumes=self.root_volumes,
            server_id=self.server_id,
            status=self.status,
            subnet_id=self.subnet_id,
            tags=self.tags)


def get_node(cluster_id: Optional[str] = None,
             name: Optional[str] = None,
             node_id: Optional[str] = None,
             region: Optional[str] = None,
             status: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeResult:
    """
    To get the specified node in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = huaweicloud.Cce.get_node(cluster_id=cluster_id,
        name=node_name)
    ```


    :param str cluster_id: Specifies the ID of container cluster.
    :param str name: Specifies the name of the node.
    :param str node_id: Specifies the ID of the node.
    :param str region: Specifies the region in which to obtain the CCE nodes.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the state of the node.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodeId'] = node_id
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cce/getNode:getNode', __args__, opts=opts, typ=GetNodeResult).value

    return AwaitableGetNodeResult(
        availability_zone=__ret__.availability_zone,
        billing_mode=__ret__.billing_mode,
        cluster_id=__ret__.cluster_id,
        data_volumes=__ret__.data_volumes,
        ecs_group_id=__ret__.ecs_group_id,
        flavor_id=__ret__.flavor_id,
        id=__ret__.id,
        key_pair=__ret__.key_pair,
        name=__ret__.name,
        node_id=__ret__.node_id,
        os=__ret__.os,
        private_ip=__ret__.private_ip,
        public_ip=__ret__.public_ip,
        region=__ret__.region,
        root_volumes=__ret__.root_volumes,
        server_id=__ret__.server_id,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_node)
def get_node_output(cluster_id: Optional[pulumi.Input[str]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    node_id: Optional[pulumi.Input[Optional[str]]] = None,
                    region: Optional[pulumi.Input[Optional[str]]] = None,
                    status: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodeResult]:
    """
    To get the specified node in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_name = config.require_object("nodeName")
    node = huaweicloud.Cce.get_node(cluster_id=cluster_id,
        name=node_name)
    ```


    :param str cluster_id: Specifies the ID of container cluster.
    :param str name: Specifies the name of the node.
    :param str node_id: Specifies the ID of the node.
    :param str region: Specifies the region in which to obtain the CCE nodes.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the state of the node.
    """
    ...
