# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, authentication_mode=None, billing_mode=None, certificate_clusters=None, certificate_users=None, cluster_type=None, cluster_version=None, container_network_cidr=None, container_network_type=None, description=None, endpoints=None, eni_subnet_cidr=None, eni_subnet_id=None, enterprise_project_id=None, flavor_id=None, highway_subnet_id=None, id=None, kube_config_raw=None, masters=None, name=None, region=None, security_group_id=None, service_network_cidr=None, status=None, subnet_id=None, vpc_id=None):
        if authentication_mode and not isinstance(authentication_mode, str):
            raise TypeError("Expected argument 'authentication_mode' to be a str")
        pulumi.set(__self__, "authentication_mode", authentication_mode)
        if billing_mode and not isinstance(billing_mode, int):
            raise TypeError("Expected argument 'billing_mode' to be a int")
        pulumi.set(__self__, "billing_mode", billing_mode)
        if certificate_clusters and not isinstance(certificate_clusters, list):
            raise TypeError("Expected argument 'certificate_clusters' to be a list")
        pulumi.set(__self__, "certificate_clusters", certificate_clusters)
        if certificate_users and not isinstance(certificate_users, list):
            raise TypeError("Expected argument 'certificate_users' to be a list")
        pulumi.set(__self__, "certificate_users", certificate_users)
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if cluster_version and not isinstance(cluster_version, str):
            raise TypeError("Expected argument 'cluster_version' to be a str")
        pulumi.set(__self__, "cluster_version", cluster_version)
        if container_network_cidr and not isinstance(container_network_cidr, str):
            raise TypeError("Expected argument 'container_network_cidr' to be a str")
        pulumi.set(__self__, "container_network_cidr", container_network_cidr)
        if container_network_type and not isinstance(container_network_type, str):
            raise TypeError("Expected argument 'container_network_type' to be a str")
        pulumi.set(__self__, "container_network_type", container_network_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if eni_subnet_cidr and not isinstance(eni_subnet_cidr, str):
            raise TypeError("Expected argument 'eni_subnet_cidr' to be a str")
        pulumi.set(__self__, "eni_subnet_cidr", eni_subnet_cidr)
        if eni_subnet_id and not isinstance(eni_subnet_id, str):
            raise TypeError("Expected argument 'eni_subnet_id' to be a str")
        pulumi.set(__self__, "eni_subnet_id", eni_subnet_id)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if highway_subnet_id and not isinstance(highway_subnet_id, str):
            raise TypeError("Expected argument 'highway_subnet_id' to be a str")
        pulumi.set(__self__, "highway_subnet_id", highway_subnet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kube_config_raw and not isinstance(kube_config_raw, str):
            raise TypeError("Expected argument 'kube_config_raw' to be a str")
        pulumi.set(__self__, "kube_config_raw", kube_config_raw)
        if masters and not isinstance(masters, list):
            raise TypeError("Expected argument 'masters' to be a list")
        pulumi.set(__self__, "masters", masters)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if service_network_cidr and not isinstance(service_network_cidr, str):
            raise TypeError("Expected argument 'service_network_cidr' to be a str")
        pulumi.set(__self__, "service_network_cidr", service_network_cidr)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> str:
        """
        Authentication mode of the cluster, possible values are x509 and rbac. Defaults to **rbac**.
        """
        return pulumi.get(self, "authentication_mode")

    @property
    @pulumi.getter(name="billingMode")
    def billing_mode(self) -> int:
        """
        Charging mode of the cluster.
        """
        return pulumi.get(self, "billing_mode")

    @property
    @pulumi.getter(name="certificateClusters")
    def certificate_clusters(self) -> Sequence['outputs.GetClusterCertificateClusterResult']:
        """
        The certificate clusters. Structure is documented below.
        """
        return pulumi.get(self, "certificate_clusters")

    @property
    @pulumi.getter(name="certificateUsers")
    def certificate_users(self) -> Sequence['outputs.GetClusterCertificateUserResult']:
        """
        The certificate users. Structure is documented below.
        """
        return pulumi.get(self, "certificate_users")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        """
        The version of cluster in string format.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="containerNetworkCidr")
    def container_network_cidr(self) -> str:
        """
        The container network segment.
        """
        return pulumi.get(self, "container_network_cidr")

    @property
    @pulumi.getter(name="containerNetworkType")
    def container_network_type(self) -> str:
        """
        The container network type: **overlay_l2** , **underlay_ipvlan**, **vpc-router** or **eni**.
        """
        return pulumi.get(self, "container_network_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Cluster description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClusterEndpointResult']:
        """
        The access addresses of kube-apiserver in the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="eniSubnetCidr")
    def eni_subnet_cidr(self) -> str:
        """
        ENI network segment. Specified when creating a CCE Turbo cluster.
        """
        return pulumi.get(self, "eni_subnet_cidr")

    @property
    @pulumi.getter(name="eniSubnetId")
    def eni_subnet_id(self) -> str:
        """
        ENI subnet ID. Specified when creating a CCE Turbo cluster.
        """
        return pulumi.get(self, "eni_subnet_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        The enterprise project ID of the CCE cluster.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> str:
        """
        The cluster specification in string format.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="highwaySubnetId")
    def highway_subnet_id(self) -> str:
        """
        The ID of the high speed network used to create bare metal nodes.
        """
        return pulumi.get(self, "highway_subnet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubeConfigRaw")
    def kube_config_raw(self) -> str:
        """
        Raw Kubernetes config to be used by kubectl and other compatible tools.
        """
        return pulumi.get(self, "kube_config_raw")

    @property
    @pulumi.getter
    def masters(self) -> Sequence['outputs.GetClusterMasterResult']:
        """
        Advanced configuration of master nodes. Structure is documented below.
        """
        return pulumi.get(self, "masters")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Security group ID of the cluster.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceNetworkCidr")
    def service_network_cidr(self) -> str:
        """
        The service network segment.
        """
        return pulumi.get(self, "service_network_cidr")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The ID of the subnet used to create the node.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            authentication_mode=self.authentication_mode,
            billing_mode=self.billing_mode,
            certificate_clusters=self.certificate_clusters,
            certificate_users=self.certificate_users,
            cluster_type=self.cluster_type,
            cluster_version=self.cluster_version,
            container_network_cidr=self.container_network_cidr,
            container_network_type=self.container_network_type,
            description=self.description,
            endpoints=self.endpoints,
            eni_subnet_cidr=self.eni_subnet_cidr,
            eni_subnet_id=self.eni_subnet_id,
            enterprise_project_id=self.enterprise_project_id,
            flavor_id=self.flavor_id,
            highway_subnet_id=self.highway_subnet_id,
            id=self.id,
            kube_config_raw=self.kube_config_raw,
            masters=self.masters,
            name=self.name,
            region=self.region,
            security_group_id=self.security_group_id,
            service_network_cidr=self.service_network_cidr,
            status=self.status,
            subnet_id=self.subnet_id,
            vpc_id=self.vpc_id)


def get_cluster(cluster_type: Optional[str] = None,
                id: Optional[str] = None,
                name: Optional[str] = None,
                region: Optional[str] = None,
                status: Optional[str] = None,
                vpc_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Provides details about the cluster and obtains certificate for accessing cluster information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    cluster = huaweicloud.Cce.get_cluster(name=cluster_name,
        status="Available")
    ```


    :param str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **ARM64**.
    :param str id: Specifies the ID of the cluster.
    :param str name: Specifies the name of the cluster.
    :param str region: Specifies the region in which to obtain the CCE cluster. If omitted, the provider-level
           region will be used.
    :param str status: Specifies the status of the cluster.
    :param str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cce/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        authentication_mode=__ret__.authentication_mode,
        billing_mode=__ret__.billing_mode,
        certificate_clusters=__ret__.certificate_clusters,
        certificate_users=__ret__.certificate_users,
        cluster_type=__ret__.cluster_type,
        cluster_version=__ret__.cluster_version,
        container_network_cidr=__ret__.container_network_cidr,
        container_network_type=__ret__.container_network_type,
        description=__ret__.description,
        endpoints=__ret__.endpoints,
        eni_subnet_cidr=__ret__.eni_subnet_cidr,
        eni_subnet_id=__ret__.eni_subnet_id,
        enterprise_project_id=__ret__.enterprise_project_id,
        flavor_id=__ret__.flavor_id,
        highway_subnet_id=__ret__.highway_subnet_id,
        id=__ret__.id,
        kube_config_raw=__ret__.kube_config_raw,
        masters=__ret__.masters,
        name=__ret__.name,
        region=__ret__.region,
        security_group_id=__ret__.security_group_id,
        service_network_cidr=__ret__.service_network_cidr,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_cluster)
def get_cluster_output(cluster_type: Optional[pulumi.Input[Optional[str]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterResult]:
    """
    Provides details about the cluster and obtains certificate for accessing cluster information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_name = config.require_object("clusterName")
    cluster = huaweicloud.Cce.get_cluster(name=cluster_name,
        status="Available")
    ```


    :param str cluster_type: Specifies the type of the cluster. Possible values: **VirtualMachine**, **ARM64**.
    :param str id: Specifies the ID of the cluster.
    :param str name: Specifies the name of the cluster.
    :param str region: Specifies the region in which to obtain the CCE cluster. If omitted, the provider-level
           region will be used.
    :param str status: Specifies the status of the cluster.
    :param str vpc_id: Specifies the VPC ID to which the cluster belongs.
    """
    ...
