# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceBlockInfo',
    'InstanceChannel',
    'InstanceCouchdb',
    'InstanceKafka',
    'InstancePeerOrg',
    'InstancePeerOrgAddress',
    'InstanceSfsTurbo',
]

@pulumi.output_type
class InstanceBlockInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockSize":
            suggest = "block_size"
        elif key == "generationInterval":
            suggest = "generation_interval"
        elif key == "transactionQuantity":
            suggest = "transaction_quantity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBlockInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBlockInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBlockInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_size: Optional[int] = None,
                 generation_interval: Optional[int] = None,
                 transaction_quantity: Optional[int] = None):
        """
        :param int block_size: Specifies the volume of the block, the unit is MB. The default value is 2.
               Changing this creates a new instance.
        :param int generation_interval: Specifies the block generation time, the unit is second. The defalt
               value is 2. Changing this creates a new instance.
        :param int transaction_quantity: Specifies the number of transactions included in the block. The
               defalt value is 500. Changing this creates a new instance.
        """
        if block_size is not None:
            pulumi.set(__self__, "block_size", block_size)
        if generation_interval is not None:
            pulumi.set(__self__, "generation_interval", generation_interval)
        if transaction_quantity is not None:
            pulumi.set(__self__, "transaction_quantity", transaction_quantity)

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[int]:
        """
        Specifies the volume of the block, the unit is MB. The default value is 2.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "block_size")

    @property
    @pulumi.getter(name="generationInterval")
    def generation_interval(self) -> Optional[int]:
        """
        Specifies the block generation time, the unit is second. The defalt
        value is 2. Changing this creates a new instance.
        """
        return pulumi.get(self, "generation_interval")

    @property
    @pulumi.getter(name="transactionQuantity")
    def transaction_quantity(self) -> Optional[int]:
        """
        Specifies the number of transactions included in the block. The
        defalt value is 500. Changing this creates a new instance.
        """
        return pulumi.get(self, "transaction_quantity")


@pulumi.output_type
class InstanceChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orgNames":
            suggest = "org_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 org_names: Optional[Sequence[str]] = None):
        """
        :param str name: Specifies the name of the channel. Changing this creates a new instance.
        """
        pulumi.set(__self__, "name", name)
        if org_names is not None:
            pulumi.set(__self__, "org_names", org_names)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the channel. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orgNames")
    def org_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "org_names")


@pulumi.output_type
class InstanceCouchdb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCouchdb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCouchdb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCouchdb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 user_name: str):
        """
        :param str password: Specifies the password of the couch datebase. The password consists of 8 to
               26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
               charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        :param str user_name: Specifies the user name of the couch datebase. Changing this creates a new
               instance.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Specifies the password of the couch datebase. The password consists of 8 to
        26 characters and must consist at least three of following: uppercase letters, lowercase letters, digits, special
        charactors(!@$%^-_=+[{}]:,./?). Changing this creates a new instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Specifies the user name of the couch datebase. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class InstanceKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "storageSize":
            suggest = "storage_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 flavor: str,
                 storage_size: int,
                 name: Optional[str] = None):
        """
        :param Sequence[str] availability_zones: Specifies the availability zone in which to create the kafka. The
               list must contain one or more than three availability zone. Please
               following [reference](https://developer.huaweicloud.com/en-us/endpoint/?all) for the values. Changing this creates a
               new instance.
        :param str flavor: Specifies the kafka flavor type. Changing this creates a new instance.
               + `c3.mini` : Mini type, the reference bandwidth is 100MB/s.
               + `c3.small.2` : Small type, the reference bandwidth is 300MB/s.
               + `c3.middle.2` : Middle type, the reference bandwidth is 600MB/s.
               + `c3.high.2` : High type, the reference bandwidth is 1200MB/s.
        :param int storage_size: Specifies the kafka storage capacity. The storage capacity must be an
               integral multiple of 100 and the maximum is 90000GB. Changing this creates a new instance.
               + The minimum storage capacity of mini type is 600GB.
               + The minimum storage capacity of small type is 1200GB.
               + The minimum storage capacity of middle type is 2400GB.
               + The minimum storage capacity of high type is 4800GB.
        :param str name: Specifies the name of the channel. Changing this creates a new instance.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "storage_size", storage_size)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        Specifies the availability zone in which to create the kafka. The
        list must contain one or more than three availability zone. Please
        following [reference](https://developer.huaweicloud.com/en-us/endpoint/?all) for the values. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Specifies the kafka flavor type. Changing this creates a new instance.
        + `c3.mini` : Mini type, the reference bandwidth is 100MB/s.
        + `c3.small.2` : Small type, the reference bandwidth is 300MB/s.
        + `c3.middle.2` : Middle type, the reference bandwidth is 600MB/s.
        + `c3.high.2` : High type, the reference bandwidth is 1200MB/s.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> int:
        """
        Specifies the kafka storage capacity. The storage capacity must be an
        integral multiple of 100 and the maximum is 90000GB. Changing this creates a new instance.
        + The minimum storage capacity of mini type is 600GB.
        + The minimum storage capacity of small type is 1200GB.
        + The minimum storage capacity of middle type is 2400GB.
        + The minimum storage capacity of high type is 4800GB.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the name of the channel. Changing this creates a new instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstancePeerOrg(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orgName":
            suggest = "org_name"
        elif key == "pvcName":
            suggest = "pvc_name"
        elif key == "statusDetail":
            suggest = "status_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePeerOrg. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePeerOrg.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePeerOrg.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: int,
                 org_name: str,
                 addresses: Optional[Sequence['outputs.InstancePeerOrgAddress']] = None,
                 pvc_name: Optional[str] = None,
                 status: Optional[str] = None,
                 status_detail: Optional[str] = None):
        """
        :param int count: Specifies the number of peers in organization. Changing this creates a new
               instance.
        :param str org_name: Specifies the name of the peer organization. Changing this creates a new
               instance.
        :param str status: The status of the BCS instance.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "org_name", org_name)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if pvc_name is not None:
            pulumi.set(__self__, "pvc_name", pvc_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_detail is not None:
            pulumi.set(__self__, "status_detail", status_detail)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        Specifies the number of peers in organization. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="orgName")
    def org_name(self) -> str:
        """
        Specifies the name of the peer organization. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "org_name")

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.InstancePeerOrgAddress']]:
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="pvcName")
    def pvc_name(self) -> Optional[str]:
        return pulumi.get(self, "pvc_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the BCS instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetail")
    def status_detail(self) -> Optional[str]:
        return pulumi.get(self, "status_detail")


@pulumi.output_type
class InstancePeerOrgAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainPort":
            suggest = "domain_port"
        elif key == "ipPort":
            suggest = "ip_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePeerOrgAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePeerOrgAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePeerOrgAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_port: str,
                 ip_port: str):
        pulumi.set(__self__, "domain_port", domain_port)
        pulumi.set(__self__, "ip_port", ip_port)

    @property
    @pulumi.getter(name="domainPort")
    def domain_port(self) -> str:
        return pulumi.get(self, "domain_port")

    @property
    @pulumi.getter(name="ipPort")
    def ip_port(self) -> str:
        return pulumi.get(self, "ip_port")


@pulumi.output_type
class InstanceSfsTurbo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "shareType":
            suggest = "share_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSfsTurbo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSfsTurbo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSfsTurbo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 flavor: Optional[str] = None,
                 share_type: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str availability_zone: Specifies the availability zone in which to create the kafka. The
               list must contain one or more than three availability zone. Please
               following [reference](https://developer.huaweicloud.com/en-us/endpoint/?all) for the values. Changing this creates a
               new instance.
        :param str flavor: Specifies the kafka flavor type. Changing this creates a new instance.
               + `c3.mini` : Mini type, the reference bandwidth is 100MB/s.
               + `c3.small.2` : Small type, the reference bandwidth is 300MB/s.
               + `c3.middle.2` : Middle type, the reference bandwidth is 600MB/s.
               + `c3.high.2` : High type, the reference bandwidth is 1200MB/s.
        :param str share_type: Specifies the share type of the SFS turbo. Changing this creates a new
               instance.
        :param str type: Specifies the type of SFS turbo. Changing this creates a new instance.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        Specifies the availability zone in which to create the kafka. The
        list must contain one or more than three availability zone. Please
        following [reference](https://developer.huaweicloud.com/en-us/endpoint/?all) for the values. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def flavor(self) -> Optional[str]:
        """
        Specifies the kafka flavor type. Changing this creates a new instance.
        + `c3.mini` : Mini type, the reference bandwidth is 100MB/s.
        + `c3.small.2` : Small type, the reference bandwidth is 300MB/s.
        + `c3.middle.2` : Middle type, the reference bandwidth is 600MB/s.
        + `c3.high.2` : High type, the reference bandwidth is 1200MB/s.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[str]:
        """
        Specifies the share type of the SFS turbo. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of SFS turbo. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")


