# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dotifi', 'dotifi.configuration', 'dotifi.nifi', 'dotifi.publishing']

package_data = \
{'': ['*']}

install_requires = \
['confuse>=1.1.0,<2.0.0',
 'jsonpickle>=1.4.1,<2.0.0',
 'nipyapi>=0.14.3,<0.15.0',
 'pygraphviz>=1.5,<2.0',
 'pyyaml>=5.3.1,<6.0.0',
 'wheel>=0.34.2,<0.35.0']

entry_points = \
{'console_scripts': ['dotifi = dotifi.dotifi:process']}

setup_kwargs = {
    'name': 'dotifi',
    'version': '0.1.2',
    'description': 'Generate DOT files and images from Apache Nifi Flows',
    'long_description': '# dotifi\n\n![Tests](https://github.com/ottobackwards/dotifi/workflows/Tests/badge.svg)\n\nA utility to generate [DOT](https://graphviz.org/doc/info/lang.html) files and images based on [graphviz](https://graphviz.org/documentation/) from the canvas of an [Apache NiFi](https://nifi.apache.org) instance.\n\ndotifi supports\n- connecting to Apache Nifi using [nipyapi](https://nipyapi.readthedocs.io/en/latest/index.html) in the background and generating a graph from the canvas items\n    - Process Groups\n    - Remote Process Groups\n    - Input and Output Ports\n    - Processors\n    - Connections\n- creating [DOT]() files using [Graphviz](https://graphviz.org) and [pygraphviz](http://pygraphviz.github.io/documentation/pygraphviz-1.5/index.html)\n- creating a graphic file in Graphviz supported formats\n- starting with an existing dot file as opposed to building from a live NiFi instance\n- starting from a specific process group\n- controlling the depth of recursion\n- supplying DOT files as templates for configuring\n    - the root graph ( and all children)\n    - Any process group by ID\n- supplying name value pairs ( in yaml configuration file) to override and set [attributes](https://graphviz.gitlab.io/_pages/doc/info/attrs.html)\n    - Processors by id\n    - Remote Process Groups by id\n\n## Install\n\n```bash\n>pip install dotifi\n```\n> with python 3 as your default\n>\n### Sample output\n\n`DOT`\n```\nstrict digraph "nifi flow" {\n\tgraph [compound=true,\n\t\tlabel="nifi flow",\n\t\toutputorder=edgesfirst,\n\t\trankdir=LR,\n\t\tratio=1.0\n\t];\n\tnode [fixedsize=false,\n\t\tfontsize=8,\n\t\tlabel="\\N",\n\t\tshape=rectangle,\n\t\tstyle=filled\n\t];\n\tedge [color="#1100FF",\n\t\tstyle="setlinewidth(2)"\n\t];\n\tsubgraph cluster_root_1 {\n\t\tgraph [label=root_1];\n\t\tsubgraph cluster_remote_target {\n\t\t\tgraph [label=remote_target];\n\t\t\t"65f5b8db-0172-1000-407f-93e85d1d9f94"\t[label="Input 1\nINPUT_PORT",\n\t\t\t\tpos="-768.000000,-768.000000"];\n\t\t\t"65f629b8-0172-1000-4ced-efa192c35536"\t[label="log_remote_attributes\nLogAttribute",\n\t\t\t\tpos="-344.000000,-344.000000"];\n\t\t\t"65f5b8db-0172-1000-407f-93e85d1d9f94" -> "65f629b8-0172-1000-4ced-efa192c35536"\t[label="Input to Processor"];\n\t\t}\n\t\tsubgraph cluster_root_1_1 {\n\t\t\tgraph [label=root_1_1];\n\t\t\tsubgraph "cluster_NiFi Flow" {\n\t\t\t\tgraph [color=blue,\n\t\t\t\t\tfontcolor=white,\n\t\t\t\t\tlabel="http://localhost:8080/nifi\nRemote Process Group",\n\t\t\t\t\tstyle=filled\n\t\t\t\t];\n\t\t\t\t"37b065f7-232b-30b9-a282-3ea28f75a2a2"\t[label="Input 1\nINPUT_PORT"];\n\t\t\t}\n\t\t\t"b268f335-2a91-44e8-b567-c676c292fd55"\t[label="Reformat Date Column\nReplaceText",\n\t\t\t\tpos="1259.009165,1259.009165"];\n\t\t\t"25b139c3-db89-4272-59c3-774ce58f0973"\t[label="No-Op Termination\nUpdateAttribute",\n\t\t\t\tpos="1265.009165,1265.009165"];\n\t\t\t"b268f335-2a91-44e8-b567-c676c292fd55" -> "25b139c3-db89-4272-59c3-774ce58f0973"\t[label=success];\n\t\t\t"b268f335-2a91-44e8-b567-c676c292fd55" -> "37b065f7-232b-30b9-a282-3ea28f75a2a2"\t[label=success];\n\t\t\t"67626c71-910a-4342-627d-e38cfcbcb924"\t[label="Set CSV Content\nReplaceText",\n\t\t\t\tpos="408.000000,408.000000"];\n\t\t\t"67626c71-910a-4342-627d-e38cfcbcb924" -> "b268f335-2a91-44e8-b567-c676c292fd55"\t[label=success];\n\t\t\t"bc3ad300-c93c-430b-fc94-3a32c3020f53"\t[label="Generate Empty File\nGenerateFlowFile",\n\t\t\t\tpos="356.009165,356.009165"];\n\t\t\t"bc3ad300-c93c-430b-fc94-3a32c3020f53" -> "67626c71-910a-4342-627d-e38cfcbcb924"\t[label=success];\n\t\t}\n\t\t"719d5fb9-cd96-4491-fe7c-e81b3f3bb555"\t[label="q=nifi\nUpdateAttribute",\n\t\t\tpos="1242.304169,1242.304169"];\n\t\t"e829b880-ef17-432a-7c5c-1e3ecdcd690d"\t[label="Search Google\nInvokeHTTP",\n\t\t\tpos="1245.295837,1245.295837"];\n\t\t"719d5fb9-cd96-4491-fe7c-e81b3f3bb555" -> "e829b880-ef17-432a-7c5c-1e3ecdcd690d"\t[label=success];\n\t\t"f96be8b1-78b2-42f2-6ba5-2579f4f6c411"\t[label="Source\nGenerateFlowFile",\n\t\t\tpos="425.000000,425.000000"];\n\t\t"f96be8b1-78b2-42f2-6ba5-2579f4f6c411" -> "719d5fb9-cd96-4491-fe7c-e81b3f3bb555"\t[label=success];\n\t\t"83ca901a-efe0-4d97-dbca-5c557cefbe6f"\t[label="HashContent\nHashContent",\n\t\t\tpos="1264.422387,1264.422387"];\n\t\t"ffcc8819-75f5-4811-e906-434e71a31f26"\t[label="Route On Status Code\nRouteOnAttribute",\n\t\t\tpos="1242.078949,1242.078949"];\n\t\t"ffcc8819-75f5-4811-e906-434e71a31f26" -> "83ca901a-efe0-4d97-dbca-5c557cefbe6f"\t[label=200];\n\t\t"e829b880-ef17-432a-7c5c-1e3ecdcd690d" -> "ffcc8819-75f5-4811-e906-434e71a31f26"\t[label=Original];\n\t\t"e829b880-ef17-432a-7c5c-1e3ecdcd690d" -> "e829b880-ef17-432a-7c5c-1e3ecdcd690d"\t[label=Retry];\n\t}\n}\n\n```\n`PNG`\n![nifi-canvas.png](sample_output/nifi-canvas.png)\n### poetry\n\ndotifi is maintained using [poetry](https://python-poetry.org/docs/) for dependency management and packaging.\n\n### Getting started for development\n- Install [Graphviz](https://graphviz.org)\n- Clone, fork, or download the [source](https://github.com/palindromicity/dotifi)\n- Install [poetry](https://python-poetry.org/docs/)\n- If required setup [pyenv](https://github.com/pyenv/pyenv) or your preference to get a python 3.8 environment, as poetry will use whatever the current python is.\n    - for example setup pyenv local to the project directory\n- In the source route directory run `poetry install`, this will install all the dependencies\n- Run `peotry run pytest -v` to run the tests and ensure things are working\n- Run `poetry build` then `poetry install` then `poetry run dotifi` with any options to run\n\n#### Setting up [Jetbrains PyCharm](https://www.jetbrains.com/pycharm/) with your virtual python environment\n- see [this reddit answer](https://www.reddit.com/r/pycharm/comments/elga2z/using_pycharm_for_poetrybased_projects/fn1ix60?utm_source=share&utm_medium=web2x)\n\n## Configuration\ndotifi uses [confuse](https://confuse.readthedocs.io/en/latest/) for it\'s configuration management.\ndotifi will take most of its configuration:\n\n - from commandline parameters\n - from a yaml configuration file specified with the --with-conf-file parameter\n - some combination of the two\n\nIf a configuration file _is_ present, and some configuration value is set both from the commandline and in the configuration,\nthen the commandline is treated as an override for the configuration file.\n\nString values in the configuration file may be entered as shell environment variables, such as $PATH.  Variables are expanded using\n[os.path.expandvars](https://docs.python.org/3/library/os.path.html#os.path.expandvars).\n\n\n```bash\nusage: dotifi.py [-h] [--with-existing-dot-file WITH_EXISTING_DOT_FILE]\n                 [--with-conf-file WITH_CONF_FILE]\n                 [--output-dot-file OUTPUT_DOT_FILE]\n                 [--output-graphviz-format {canon,cmap,cmapx,cmapx_np,dia,dot,fig,gd,gd2,gif,hpgl,imap,imap_np,ismap,jpe,jpeg,jpg,mif,mp,pcl,pdf,pic,plain,plain-ext,png,ps,ps2,svg,svgz,vml,vmlz,vrml,vtx,wbmp,xdot,xlib}]\n                 [--output-graphviz-program {neato,dot,twopi,circo,fdp,nop}]\n                 [--output-graphviz-file OUTPUT_GRAPHVIZ_FILE]\n                 [--start-at-pg START_AT_PG] [--depth DEPTH]\n                 [--nifi-url NIFI_URL] [--using-ssl USING_SSL]\n                 [--using-user-pw USING_USER_PW] [--ca-file CA_FILE]\n                 [--client-cert-file CLIENT_CERT_FILE]\n                 [--client-key-file CLIENT_KEY_FILE]\n                 [--client-key-password CLIENT_KEY_PASSWORD]\n                 [--nifi-username NIFI_USERNAME]\n                 [--nifi-user-password NIFI_USER_PASSWORD] [--verbose]\n                 [--generate-mock-data] [--mock-data-file MOCK_DATA_FILE]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --with-existing-dot-file WITH_EXISTING_DOT_FILE, -w WITH_EXISTING_DOT_FILE\n                        Output will be based on an existing DOT graph\n                        definition as opposed to being built from NiFi\n  --with-conf-file WITH_CONF_FILE, -c WITH_CONF_FILE\n                        Path to the .yaml file with the configuration. All\n                        options can be set in the configuration, with\n  --output-dot-file OUTPUT_DOT_FILE, -o OUTPUT_DOT_FILE\n                        Path to the dot file to store the dot results to.\n  --output-graphviz-format {canon,cmap,cmapx,cmapx_np,dia,dot,fig,gd,gd2,gif,hpgl,imap,imap_np,ismap,jpe,jpeg,jpg,mif,mp,pcl,pdf,pic,plain,plain-ext,png,ps,ps2,svg,svgz,vml,vmlz,vrml,vtx,wbmp,xdot,xlib}, -f {canon,cmap,cmapx,cmapx_np,dia,dot,fig,gd,gd2,gif,hpgl,imap,imap_np,ismap,jpe,jpeg,jpg,mif,mp,pcl,pdf,pic,plain,plain-ext,png,ps,ps2,svg,svgz,vml,vmlz,vrml,vtx,wbmp,xdot,xlib}\n                        The format of the graphviz generated file. Formats\n                        (not all may be available on every system depending on\n                        how Graphviz was built)\n  --output-graphviz-program {neato,dot,twopi,circo,fdp,nop}\n                        Graphviz layout method to use.\n  --output-graphviz-file OUTPUT_GRAPHVIZ_FILE, -g OUTPUT_GRAPHVIZ_FILE\n                        Path to the dot file to store the graphviz results to.\n                        Results will be saved with the extension of the\n                        --output-graphviz-format option\n  --start-at-pg START_AT_PG, -s START_AT_PG\n                        The id of the process group to start at. This will be\n                        a uuid. When set the output will start with this\n                        process and it\'s descendents based on the depth\n                        setting\n  --depth DEPTH, -d DEPTH\n                        The depth to descend to within nested process groups.\n                        Note that the top level canvas is the root process\n                        group. As such a depth of 0 will only output items in\n                        the root canvas and not any process groups it\n                        contains. A value of -1 means unlimited.\n  --nifi-url NIFI_URL, -n NIFI_URL\n                        The url of the NiFi instance to connect to. This is\n                        used if --with-existing is not set.\n  --using-ssl USING_SSL\n                        Flag, when specified it signals that the NiFi\n                        connection requires SSL\n  --using-user-pw USING_USER_PW\n                        Flag, when specified it signals that the NiFi\n                        connection requires a username and password\n  --ca-file CA_FILE     A PEM file containing certs for the root CA(s) for the\n                        NiFi server\n  --client-cert-file CLIENT_CERT_FILE\n                        A PEM file containing the public certificates for the\n                        user / client identity\n  --client-key-file CLIENT_KEY_FILE\n                        An encrypted (password -protected PEM file containing\n                        the client\'s secret key\n  --client-key-password CLIENT_KEY_PASSWORD\n                        The password to decrypt the client_key_file\n  --nifi-username NIFI_USERNAME\n                        The NiFi user name\n  --nifi-user-password NIFI_USER_PASSWORD\n                        The NiFi user password\n  --verbose, -v         Sets the logging level to verbose\n  --generate-mock-data  Generates mock data\n  --mock-data-file MOCK_DATA_FILE\n                        When --generate-mock-data is specified, it will be\n                        written to this file\n\n```\n\nA sample of the yaml configuration is [here](configurations/sample.yaml)\n\n```yaml\n# All string values in this configuration may be replaced using\n# environmental variables in the form of $VARIABLENAME\n#\n# the version of this configuration\nconfiguration_version : 1\n\n\n#  Flag to set logging to verbose ( debugging level )\nverbose:\n#  Path to an existing DOT graph definition as opposed to being built from NiFi\nwith_existing_dot_file:\n# Path to the dot file to store the dot results to\noutput_dot_file:\n\n#  The format of the graphviz generated file. Formats (not all may be available on every system\n#  depending on how Graphviz was built\n#  "canon", "cmap", "cmapx", "cmapx_np", "dia", "dot", "fig", "gd", "gd2", "gif",\n#  "hpgl", "imap", "imap_np", "ismap", "jpe", "jpeg", "jpg", "mif", "mp", "pcl", "pdf",\n#  "pic", "plain", "plain_ext", "png", "ps", "ps2", "svg", "svgz", "vml", "vmlz", "vrml",\n#  "vtx", "wbmp", "xdot", "xlib"\noutput_graphviz_format:\n\n#  The Graphviz layout to use\n# ‘neato’|’dot’|’twopi’|’circo’|’fdp’|’nop\'\noutput_graphviz_program:\n\n#  Path to the dot file to store the graphviz results to. Results will be saved with the extension\n#  output_graphviz_format option\noutput_graphviz_file:\n\n#  The id of the process group to start at.  This will be a uuid.  When set the output will start\n#  with this process and it\'s decedents based on the depth setting\nstart_at_pg:\n\n#  The depth to descend to within nested process groups.  Note that the top level canvas\n#  is the root process group.  As such a depth of 0 will only output items in the root canvas and\n#  not any process groups it contains.  A value of _1 means unlimited\ndepth:\n\n# The url of the nifi instance to connect to.  This is used if with_existing is not set\nnifi_url:\n\n# Flag, when specified it signals that the NiFi connection requires SSL\nusing_ssl:\n\n# Flag, when specified it signals that the NiFi connection requires a username and password\nusing_user_pw:\n\n# A PEM file containing certs for the root CA(s) for the NiFi serve\nca_file:\n\n# A PEM file containing the public certificates for the user / client identity\nclient_cert_file:\n\n# An encrypted (password _protected PEM file containing the client\'s secret key\nclient_key_file:\n\n# The password to decrypt the client_key_file\nclient_key_password:\n\n# The NiFi user name\nnifi_user_name:\n\n# The NiFi user password\nnifi_user_password:\n\n# Options for the entire graph\ngraph:\n    # Path to a dot file that contains top level graph definition that sets the properties\n    # and attributes at a graph level\n    # see https://graphviz.org/documentation/ for information on the dot language\n    template: bar.dot\n# Options for specific process groups, by id\nprocess_groups:\n    # the uuid id of the process group\n    351b1dbc-0172-1000-056d-ec78a003b493:\n        # Path to a dot file the contains the graph definition that sets the properties\n        # and attributes at a graph level for this process group and it\'s descendents\n        template: foo.dot\n# Options for specific remote process groups, by id\n# these values will override or mix in with the defaults\nremote_process_groups:\n    # the uuid of the remote process group\n    35199793-0172-1000-02ea-52da1888a03d:\n        # NODE attributes\n        # see https://graphviz.gitlab.io/_pages/doc/info/attrs.html\n        color: grey\n# Options for specific processors, by id\nprocessors:\n    # the uuid of the processor\n    351b1dbc-0172-1000-056d-ec78a003b49:\n        # NODE attributes\n        # see https://graphviz.gitlab.io/_pages/doc/info/attrs.html\n        color: blue\n```\n',
    'author': 'Otto Fowler',
    'author_email': 'ottobackwards@gmail.com',
    'maintainer': 'palindromicity',
    'maintainer_email': 'github.palindromicity@gmail.com',
    'url': 'https://github.com/palindromicity/dotifi',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
