# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#

import pprint
import re  # noqa: F401

import six


class WidgetsBundle(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alias': 'str',
        'created_time': 'int',
        'id': 'WidgetsBundleId',
        'image': 'list[str]',
        'tenant_id': 'TenantId',
        'title': 'str'
    }

    attribute_map = {
        'alias': 'alias',
        'created_time': 'createdTime',
        'id': 'id',
        'image': 'image',
        'tenant_id': 'tenantId',
        'title': 'title'
    }

    def __init__(self, alias=None, created_time=None, id=None, image=None, tenant_id=None, title=None):  # noqa: E501
        """WidgetsBundle - a model defined in Swagger"""  # noqa: E501

        self._alias = None
        self._created_time = None
        self._id = None
        self._image = None
        self._tenant_id = None
        self._title = None
        self.discriminator = None

        if alias is not None:
            self.alias = alias
        if created_time is not None:
            self.created_time = created_time
        if id is not None:
            self.id = id
        if image is not None:
            self.image = image
        if tenant_id is not None:
            self.tenant_id = tenant_id
        if title is not None:
            self.title = title

    @property
    def alias(self):
        """Gets the alias of this WidgetsBundle.  # noqa: E501


        :return: The alias of this WidgetsBundle.  # noqa: E501
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this WidgetsBundle.


        :param alias: The alias of this WidgetsBundle.  # noqa: E501
        :type: str
        """

        self._alias = alias

    @property
    def created_time(self):
        """Gets the created_time of this WidgetsBundle.  # noqa: E501


        :return: The created_time of this WidgetsBundle.  # noqa: E501
        :rtype: int
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this WidgetsBundle.


        :param created_time: The created_time of this WidgetsBundle.  # noqa: E501
        :type: int
        """

        self._created_time = created_time

    @property
    def id(self):
        """Gets the id of this WidgetsBundle.  # noqa: E501


        :return: The id of this WidgetsBundle.  # noqa: E501
        :rtype: WidgetsBundleId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WidgetsBundle.


        :param id: The id of this WidgetsBundle.  # noqa: E501
        :type: WidgetsBundleId
        """

        self._id = id

    @property
    def image(self):
        """Gets the image of this WidgetsBundle.  # noqa: E501


        :return: The image of this WidgetsBundle.  # noqa: E501
        :rtype: list[str]
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this WidgetsBundle.


        :param image: The image of this WidgetsBundle.  # noqa: E501
        :type: list[str]
        """

        self._image = image

    @property
    def tenant_id(self):
        """Gets the tenant_id of this WidgetsBundle.  # noqa: E501


        :return: The tenant_id of this WidgetsBundle.  # noqa: E501
        :rtype: TenantId
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this WidgetsBundle.


        :param tenant_id: The tenant_id of this WidgetsBundle.  # noqa: E501
        :type: TenantId
        """

        self._tenant_id = tenant_id

    @property
    def title(self):
        """Gets the title of this WidgetsBundle.  # noqa: E501


        :return: The title of this WidgetsBundle.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this WidgetsBundle.


        :param title: The title of this WidgetsBundle.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WidgetsBundle, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WidgetsBundle):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
