# coding: utf-8
#      Copyright 2020. ThingsBoard
#  #
#      Licensed under the Apache License, Version 2.0 (the "License");
#      you may not use this file except in compliance with the License.
#      You may obtain a copy of the License at
#  #
#          http://www.apache.org/licenses/LICENSE-2.0
#  #
#      Unless required by applicable law or agreed to in writing, software
#      distributed under the License is distributed on an "AS IS" BASIS,
#      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#      See the License for the specific language governing permissions and
#      limitations under the License.
#
#

import pprint
import re  # noqa: F401

import six


class TextPageLink(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id_offset': 'str',
        'limit': 'int',
        'text_offset': 'str',
        'text_search': 'str',
        'text_search_bound': 'str'
    }

    attribute_map = {
        'id_offset': 'idOffset',
        'limit': 'limit',
        'text_offset': 'textOffset',
        'text_search': 'textSearch',
        'text_search_bound': 'textSearchBound'
    }

    def __init__(self, id_offset=None, limit=None, text_offset=None, text_search=None, text_search_bound=None):  # noqa: E501
        """TextPageLink - a model defined in Swagger"""  # noqa: E501

        self._id_offset = None
        self._limit = None
        self._text_offset = None
        self._text_search = None
        self._text_search_bound = None
        self.discriminator = None

        if id_offset is not None:
            self.id_offset = id_offset
        if limit is not None:
            self.limit = limit
        if text_offset is not None:
            self.text_offset = text_offset
        if text_search is not None:
            self.text_search = text_search
        if text_search_bound is not None:
            self.text_search_bound = text_search_bound

    @property
    def id_offset(self):
        """Gets the id_offset of this TextPageLink.  # noqa: E501


        :return: The id_offset of this TextPageLink.  # noqa: E501
        :rtype: str
        """
        return self._id_offset

    @id_offset.setter
    def id_offset(self, id_offset):
        """Sets the id_offset of this TextPageLink.


        :param id_offset: The id_offset of this TextPageLink.  # noqa: E501
        :type: str
        """

        self._id_offset = id_offset

    @property
    def limit(self):
        """Gets the limit of this TextPageLink.  # noqa: E501


        :return: The limit of this TextPageLink.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this TextPageLink.


        :param limit: The limit of this TextPageLink.  # noqa: E501
        :type: int
        """

        self._limit = limit

    @property
    def text_offset(self):
        """Gets the text_offset of this TextPageLink.  # noqa: E501


        :return: The text_offset of this TextPageLink.  # noqa: E501
        :rtype: str
        """
        return self._text_offset

    @text_offset.setter
    def text_offset(self, text_offset):
        """Sets the text_offset of this TextPageLink.


        :param text_offset: The text_offset of this TextPageLink.  # noqa: E501
        :type: str
        """

        self._text_offset = text_offset

    @property
    def text_search(self):
        """Gets the text_search of this TextPageLink.  # noqa: E501


        :return: The text_search of this TextPageLink.  # noqa: E501
        :rtype: str
        """
        return self._text_search

    @text_search.setter
    def text_search(self, text_search):
        """Sets the text_search of this TextPageLink.


        :param text_search: The text_search of this TextPageLink.  # noqa: E501
        :type: str
        """

        self._text_search = text_search

    @property
    def text_search_bound(self):
        """Gets the text_search_bound of this TextPageLink.  # noqa: E501


        :return: The text_search_bound of this TextPageLink.  # noqa: E501
        :rtype: str
        """
        return self._text_search_bound

    @text_search_bound.setter
    def text_search_bound(self, text_search_bound):
        """Sets the text_search_bound of this TextPageLink.


        :param text_search_bound: The text_search_bound of this TextPageLink.  # noqa: E501
        :type: str
        """

        self._text_search_bound = text_search_bound

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TextPageLink, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TextPageLink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
