# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class ThingParkIntegrationControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def process_request_tpe_using_delete(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_delete(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_delete_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_delete_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_delete_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_delete_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_delete`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_delete`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_delete`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_get(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_get(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_get_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_get_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_get_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_get_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_get`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_get`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_get`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_head(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_head(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_head_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_head_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_head_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_head_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_head`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_head`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_head`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_head`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_options(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_options(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_options_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_options_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_options_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_options_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_options`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_options`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_options`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_options`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'OPTIONS',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_patch(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_patch(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_patch_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_patch_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_patch_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_patch_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_patch`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_patch`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_patch`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_post(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_post(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_post_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_post_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_post_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_post_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_post`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_post`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_post`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_tpe_using_put(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_put(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_tpe_using_put_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_tpe_using_put_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_tpe_using_put_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequestTPE  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_tpe_using_put_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_tpe_using_put`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_tpe_using_put`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_tpe_using_put`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_tpe_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/tpe/{routingKey}{?allRequestParams}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_delete3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_delete3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_delete3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_delete3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_delete3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_delete3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_delete3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_delete3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_delete3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_delete3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_get3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_get3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_get3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_get3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_get3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_get3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_get3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_get3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_get3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_get3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_head3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_head3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_head3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_head3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_head3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_head3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_head3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_head3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_head3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_head3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_options3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_options3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_options3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_options3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_options3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_options3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_options3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_options3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_options3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_options3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'OPTIONS',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_patch3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_patch3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_patch3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_patch3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_patch3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_patch3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_patch3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_patch3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_patch3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_patch3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_post9(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_post9(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_post9_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_post9_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_post9_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_post9_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_post9`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_post9`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_post9`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_post9`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_request_using_put3(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_put3(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_request_using_put3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
        else:
            (data) = self.process_request_using_put3_with_http_info(routing_key, all_request_params, msg, request_headers, **kwargs)  # noqa: E501
            return data

    def process_request_using_put3_with_http_info(self, routing_key, all_request_params, msg, request_headers, **kwargs):  # noqa: E501
        """processRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_request_using_put3_with_http_info(routing_key, all_request_params, msg, request_headers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str routing_key: routingKey (required)
        :param object all_request_params: allRequestParams (required)
        :param str msg: msg (required)
        :param object request_headers: requestHeaders (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['routing_key', 'all_request_params', 'msg', 'request_headers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'routing_key' is set
        if ('routing_key' not in params or
                params['routing_key'] is None):
            raise ValueError("Missing the required parameter `routing_key` when calling `process_request_using_put3`")  # noqa: E501
        # verify the required parameter 'all_request_params' is set
        if ('all_request_params' not in params or
                params['all_request_params'] is None):
            raise ValueError("Missing the required parameter `all_request_params` when calling `process_request_using_put3`")  # noqa: E501
        # verify the required parameter 'msg' is set
        if ('msg' not in params or
                params['msg'] is None):
            raise ValueError("Missing the required parameter `msg` when calling `process_request_using_put3`")  # noqa: E501
        # verify the required parameter 'request_headers' is set
        if ('request_headers' not in params or
                params['request_headers'] is None):
            raise ValueError("Missing the required parameter `request_headers` when calling `process_request_using_put3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'routing_key' in params:
            path_params['routingKey'] = params['routing_key']  # noqa: E501

        query_params = []
        if 'all_request_params' in params:
            query_params.append(('allRequestParams', params['all_request_params']))  # noqa: E501

        header_params = {}
        if 'request_headers' in params:
            header_params['requestHeaders'] = params['request_headers']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'msg' in params:
            body_params = params['msg']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/integrations/thingpark/{routingKey}{?allRequestParams}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
