# coding: utf-8

"""
    ThingsBoard REST API

    For instructions how to authorize requests please visit <a href='http://thingsboard.io/docs/reference/rest-api/'>REST API documentation page</a>.  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: info@thingsboard.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tb_rest_client32.api_client import ApiClient


class RpcControllerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def handle_one_way_device_rpc_request_using_post(self, device_id, request_body, **kwargs):  # noqa: E501
        """handleOneWayDeviceRPCRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_one_way_device_rpc_request_using_post(device_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_id: deviceId (required)
        :param str request_body: requestBody (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_one_way_device_rpc_request_using_post_with_http_info(device_id, request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_one_way_device_rpc_request_using_post_with_http_info(device_id, request_body, **kwargs)  # noqa: E501
            return data

    def handle_one_way_device_rpc_request_using_post_with_http_info(self, device_id, request_body, **kwargs):  # noqa: E501
        """handleOneWayDeviceRPCRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_one_way_device_rpc_request_using_post_with_http_info(device_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_id: deviceId (required)
        :param str request_body: requestBody (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'request_body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `handle_one_way_device_rpc_request_using_post`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if ('request_body' not in params or
                params['request_body'] is None):
            raise ValueError("Missing the required parameter `request_body` when calling `handle_one_way_device_rpc_request_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in params:
            body_params = params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/rpc/oneway/{deviceId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_two_way_device_rpc_request_using_post(self, device_id, request_body, **kwargs):  # noqa: E501
        """handleTwoWayDeviceRPCRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_two_way_device_rpc_request_using_post(device_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_id: deviceId (required)
        :param str request_body: requestBody (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_two_way_device_rpc_request_using_post_with_http_info(device_id, request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_two_way_device_rpc_request_using_post_with_http_info(device_id, request_body, **kwargs)  # noqa: E501
            return data

    def handle_two_way_device_rpc_request_using_post_with_http_info(self, device_id, request_body, **kwargs):  # noqa: E501
        """handleTwoWayDeviceRPCRequest  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_two_way_device_rpc_request_using_post_with_http_info(device_id, request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str device_id: deviceId (required)
        :param str request_body: requestBody (required)
        :return: DeferredResultResponseEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'request_body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `handle_two_way_device_rpc_request_using_post`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if ('request_body' not in params or
                params['request_body'] is None):
            raise ValueError("Missing the required parameter `request_body` when calling `handle_two_way_device_rpc_request_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in params:
            body_params = params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/rpc/twoway/{deviceId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeferredResultResponseEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
