# Generated by Django 3.1.2 on 2020-10-09 14:37

import django.contrib.sites.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('bigbluebutton', '0001_initial'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='bigbluebuttongroup',
            options={'permissions': [('add_servers', 'Can add servers to this group'), ('add_apitokens', 'Can add API tokens valid for this group'), ('add_meetings', 'Can add meetings on servers in this group')]},
        ),
        migrations.AlterModelOptions(
            name='meeting',
            options={'permissions': [('join_as_attendee', 'Can join this meeting with viewer role'), ('join_as_moderator', 'Can join this meeting with moderator role'), ('grant_attendee', 'Can grant attendee privileges to others'), ('grant_moderator', 'Can grant moderator privileges to others'), ('enforce_conference_pin', 'Can enforce a static conference PIN'), ('add_urls', 'Can add new URLs for this meeting')]},
        ),
        migrations.RemoveField(
            model_name='meeting',
            name='api',
        ),
        migrations.AddField(
            model_name='meeting',
            name='allow_mods_to_unmute_users',
            field=models.BooleanField(default=False, help_text='Allow moderators to unmute other users (this is a privacy risk)', verbose_name='Allow moderators to unmute'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='allow_start_stop_recording',
            field=models.BooleanField(default=True, help_text='Allows users to manually start and stop recording. If recording is set to auto-start, this forces the whole meeting to be recorded. If auto-start is disabled, this causes the recording to be discarded.', verbose_name='Allow starting and stopping recording'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='api_group',
            field=models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name='meetings', to='bigbluebutton.bigbluebuttongroup'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='meeting',
            name='auto_start_recording',
            field=models.BooleanField(default=False, verbose_name='Auto-start recording on first join'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='conference_pin',
            field=models.CharField(blank=True, help_text='PIN for phone dial-in (if available)', max_length=10, null=True, unique=True, validators=[django.core.validators.RegexValidator('[0-9]*', 'The PIN must be numerical')], verbose_name='Conference PIN'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='duration',
            field=models.PositiveIntegerField(null=True, verbose_name='Maximum duration (in minutes)'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='enable_cam',
            field=models.BooleanField(default=True, verbose_name='Allow sharing webcam'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='enable_mic',
            field=models.BooleanField(default=True, verbose_name='Allow sharing microphone'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='enable_note',
            field=models.BooleanField(default=True, verbose_name='Allow editing shared notes'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='enable_private_chat',
            field=models.BooleanField(default=True, verbose_name='Allow private chat'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='enable_public_chat',
            field=models.BooleanField(default=True, verbose_name='Allow public chat'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='mute_on_start',
            field=models.BooleanField(default=False, help_text='Participants are muted when they join the meeting', verbose_name='Mute on start'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='record',
            field=models.BooleanField(default=False, verbose_name='Record media and events'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='webcams_only_for_moderator',
            field=models.BooleanField(default=False, help_text='Webcam streams of participants are only visible for moderators, not for other participants.', verbose_name='Webcams only for moderators'),
        ),
        migrations.AlterField(
            model_name='bigbluebuttongroup',
            name='site',
            field=models.ForeignKey(default=django.contrib.sites.models.SiteManager.get_current, on_delete=django.db.models.deletion.CASCADE, to='sites.site'),
        ),
        migrations.AlterField(
            model_name='meeting',
            name='max_participants',
            field=models.PositiveSmallIntegerField(null=True, verbose_name='Maximum number of participants'),
        ),
    ]
