# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['manim_slides']

package_data = \
{'': ['*'], 'manim_slides': ['data/*']}

install_requires = \
['click-default-group>=1.2',
 'click>=8.0',
 'numpy>=1.19',
 'opencv-python>=4.6',
 'pydantic>=1.9',
 'pyside6>=6',
 'requests>=2.26',
 'tqdm>=4.62']

entry_points = \
{'console_scripts': ['manim-slides = manim_slides.__main__:cli']}

setup_kwargs = {
    'name': 'manim-slides',
    'version': '4.7.1',
    'description': 'Tool for live presentations using manim',
    'long_description': '![Manim Slides Logo](https://raw.githubusercontent.com/jeertmans/manim-slides/main/static/logo.png)\n\n[![Latest Release][pypi-version-badge]][pypi-version-url]\n[![Python version][pypi-python-version-badge]][pypi-version-url]\n![PyPI - Downloads](https://img.shields.io/pypi/dm/manim-slides)\n# Manim Slides\n\nTool for live presentations using either [Manim (community edition)](https://www.manim.community/) or [ManimGL](https://3b1b.github.io/manim/). Manim Slides will *automatically* detect the one you are using!\n\n> **_NOTE:_**  This project extends the work of [`manim-presentation`](https://github.com/galatolofederico/manim-presentation), with a lot more features!\n\n- [Installation](#installation)\n  * [Dependencies](#dependencies)\n  * [Pip install](#pip-install)\n  * [Install From Repository](#install-from-repository)\n- [Usage](#usage)\n  * [Basic Example](#basic-example)\n  * [Key Bindings](#key-bindings)\n  * [Other Examples](#other-examples)\n- [Features and Comparison with Original manim-presentation](#features-and-comparison-with-original-manim-presentation)\n- [F.A.Q](#faq)\n  * [How to increase quality on Windows](#how-to-increase-quality-on-windows)\n- [Contributing](#contributing)\n\n## Installation\n\nWhile installing Manim Slides and its dependencies on your global Python is fine, I recommend using a virtual environment (e.g., [venv](https://docs.python.org/3/tutorial/venv.html)) for a local installation.\n\n### Dependencies\n\nManim Slides requires either Manim or ManimGL to be installed. Having both packages installed is fine too.\n\nIf none of those packages are installed, please refer to their specific installation guidelines:\n- [Manim](https://docs.manim.community/en/stable/installation.html)\n- [ManimGL](https://3b1b.github.io/manim/getting_started/installation.html)\n\n### Pip Install\n\nThe recommended way to install the latest release is to use pip:\n\n```bash\npip install manim-slides\n```\n\n### Install From Repository\n\nAn alternative way to install Manim Slides is to clone the git repository, and install from there:\n\n```bash\ngit clone https://github.com/jeertmans/manim-slides\npip install -e .\n```\n\n> *Note:* the `-e` flag allows you to edit the files, and observe the changes directly when using Manim Slides\n\n## Usage\n\nUsing Manim Slides is a two-step process:\n1. Render animations using `Slide` (resp. `ThreeDSlide`) as a base class instead of `Scene` (resp. `ThreeDScene`), and add calls to `self.pause()` everytime you want to create a new slide.\n2. Run `manim-slides` on rendered animations and display them like a *Power Point* presentation.\n\nThe command-line documentation is available [online](https://eertmans.be/manim-slides/).\n\n### Basic Example\n\n\nWrap a series of animations between `self.start_loop()` and `self.stop_loop()` when you want to loop them (until input to continue):\n\n```python\n# example.py\n\nfrom manim import *\n# or: from manimlib import *\nfrom manim_slides import Slide\n\nclass Example(Slide):\n    def construct(self):\n        circle = Circle(radius=3, color=BLUE)\n        dot = Dot()\n\n        self.play(GrowFromCenter(circle))\n        self.pause()  # Waits user to press continue to go to the next slide\n\n        self.start_loop()  # Start loop\n        self.play(MoveAlongPath(dot, circle), run_time=2, rate_func=linear)\n        self.end_loop()  # This will loop until user inputs a key\n\n        self.play(dot.animate.move_to(ORIGIN))\n        self.pause()  # Waits user to press continue to go to the next slide\n\n        self.wait()\n```\n\nYou **must** end your `Slide` with a `self.play(...)` or a `self.wait(...)`.\n\nFirst, render the animation files:\n\n```bash\nmanim example.py\n# or\nmanimgl example.py\n```\n\nTo start the presentation using `Scene1`, `Scene2` and so on simply run:\n\n```bash\nmanim-slides [OPTIONS] Scene1 Scene2...\n```\n\nOr in this example:\n\n```bash\nmanim-slides Example\n```\n\n##  Key Bindings\n\nThe default key bindings to control the presentation are:\n\n![manim-wizard](https://user-images.githubusercontent.com/27275099/197468787-19c83a81-d757-47b9-8f68-218427d30298.png)\n\n\nYou can run the **configuration wizard** to change those key bindings:\n\n```bash\nmanim-slides wizard\n```\n\nA default file can be created with:\n\n```bash\nmanim-slides init\n```\n\n> **_NOTE:_**  `manim-slides` uses key codes, which are platform dependent. Using the configuration wizard is therefore highly recommended.\n\n## Other Examples\n\nOther examples are available in the [`example.py`](https://github.com/jeertmans/manim-slides/blob/main/example.py) file, if you downloaded the git repository.\n\nBelow is a small recording of me playing with the slides back and forth.\n\n![](https://raw.githubusercontent.com/jeertmans/manim-slides/main/static/example.gif)\n\n\n## Features and Comparison with original manim-presentation\n\nBelow is a non-exhaustive list of features:\n\n| Feature | `manim-slides` | `manim-presentation` |\n|:--------|:--------------:|:--------------------:|\n| Support for Manim | :heavy_check_mark: | :heavy_check_mark: |\n| Support for ManimGL | :heavy_check_mark: | :heavy_multiplication_x: |\n| Configurable key bindings | :heavy_check_mark: | :heavy_check_mark: |\n| Configurable paths | :heavy_check_mark: | :heavy_multiplication_x: |\n| Play / Pause slides | :heavy_check_mark: | :heavy_check_mark: |\n| Next / Previous slide | :heavy_check_mark: | :heavy_check_mark: |\n| Replay slide | :heavy_check_mark: | :heavy_check_mark: |\n| Reverse slide | :heavy_check_mark: | :heavy_multiplication_x: |\n| Multiple key per actions | :heavy_check_mark: | :heavy_multiplication_x: |\n| One command line tool | :heavy_check_mark: | :heavy_multiplication_x: |\n| Robust config file parsing | :heavy_check_mark: | :heavy_multiplication_x: |\n| Support for 3D Scenes | :heavy_check_mark: | :heavy_multiplication_x: |\n| Documented code | :heavy_check_mark: | :heavy_multiplication_x: |\n| Tested on Unix, macOS, and Windows | :heavy_check_mark: | :heavy_multiplication_x: |\n| Hide mouse cursor | :heavy_check_mark: | :heavy_multiplication_x: |\n\n## F.A.Q\n\n### How to increase quality on Windows\n\nOn Windows platform, one may encounter a lower image resolution than expected. Usually, this is observed because Windows rescales every application to fit the screen.\nAs found by [@arashash](https://github.com/arashash), in [#20](https://github.com/jeertmans/manim-slides/issues/20), the problem can be addressed by changing the scaling factor to 100%:\n\n![Windows Fix Scaling](static/windows_quality_fix.png)\n\nin *Settings*->*Display*.\n\n## Contributing\n\nContributions are more than welcome!\n\n[pypi-version-badge]: https://img.shields.io/pypi/v/manim-slides?label=manim-slides\n[pypi-version-url]: https://pypi.org/project/manim-slides/\n[pypi-python-version-badge]: https://img.shields.io/pypi/pyversions/manim-slides\n',
    'author': 'Jérome Eertmans',
    'author_email': 'jeertmans@icloud.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/jeertmans/manim-slides',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
