# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 repository: pulumi.Input[str],
                 steps: pulumi.Input[str],
                 branch_configuration: Optional[pulumi.Input[str]] = None,
                 cancel_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 cancel_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_settings: Optional[pulumi.Input['PipelineProviderSettingsArgs']] = None,
                 skip_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 skip_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[str] repository: The git URL of the repository.
        :param pulumi.Input[str] steps: The string YAML steps to run the pipeline.
        :param pulumi.Input[str] branch_configuration: Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        :param pulumi.Input[bool] cancel_intermediate_builds: A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        :param pulumi.Input[str] cancel_intermediate_builds_branch_filter: Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        :param pulumi.Input[str] cluster_id: The GraphQL ID of the cluster you want to use for the pipeline.
        :param pulumi.Input[str] default_branch: The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        :param pulumi.Input[str] description: A description of the pipeline.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input['PipelineProviderSettingsArgs'] provider_settings: Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        :param pulumi.Input[bool] skip_intermediate_builds: A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        :param pulumi.Input[str] skip_intermediate_builds_branch_filter: Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]] teams: Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        """
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "steps", steps)
        if branch_configuration is not None:
            pulumi.set(__self__, "branch_configuration", branch_configuration)
        if cancel_intermediate_builds is not None:
            pulumi.set(__self__, "cancel_intermediate_builds", cancel_intermediate_builds)
        if cancel_intermediate_builds_branch_filter is not None:
            pulumi.set(__self__, "cancel_intermediate_builds_branch_filter", cancel_intermediate_builds_branch_filter)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_settings is not None:
            pulumi.set(__self__, "provider_settings", provider_settings)
        if skip_intermediate_builds is not None:
            pulumi.set(__self__, "skip_intermediate_builds", skip_intermediate_builds)
        if skip_intermediate_builds_branch_filter is not None:
            pulumi.set(__self__, "skip_intermediate_builds_branch_filter", skip_intermediate_builds_branch_filter)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The git URL of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[str]:
        """
        The string YAML steps to run the pipeline.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[str]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter(name="branchConfiguration")
    def branch_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        """
        return pulumi.get(self, "branch_configuration")

    @branch_configuration.setter
    def branch_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_configuration", value)

    @property
    @pulumi.getter(name="cancelIntermediateBuilds")
    def cancel_intermediate_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "cancel_intermediate_builds")

    @cancel_intermediate_builds.setter
    def cancel_intermediate_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cancel_intermediate_builds", value)

    @property
    @pulumi.getter(name="cancelIntermediateBuildsBranchFilter")
    def cancel_intermediate_builds_branch_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        """
        return pulumi.get(self, "cancel_intermediate_builds_branch_filter")

    @cancel_intermediate_builds_branch_filter.setter
    def cancel_intermediate_builds_branch_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cancel_intermediate_builds_branch_filter", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GraphQL ID of the cluster you want to use for the pipeline.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="providerSettings")
    def provider_settings(self) -> Optional[pulumi.Input['PipelineProviderSettingsArgs']]:
        """
        Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        """
        return pulumi.get(self, "provider_settings")

    @provider_settings.setter
    def provider_settings(self, value: Optional[pulumi.Input['PipelineProviderSettingsArgs']]):
        pulumi.set(self, "provider_settings", value)

    @property
    @pulumi.getter(name="skipIntermediateBuilds")
    def skip_intermediate_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "skip_intermediate_builds")

    @skip_intermediate_builds.setter
    def skip_intermediate_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_intermediate_builds", value)

    @property
    @pulumi.getter(name="skipIntermediateBuildsBranchFilter")
    def skip_intermediate_builds_branch_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        """
        return pulumi.get(self, "skip_intermediate_builds_branch_filter")

    @skip_intermediate_builds_branch_filter.setter
    def skip_intermediate_builds_branch_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_intermediate_builds_branch_filter", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]]:
        """
        Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 badge_url: Optional[pulumi.Input[str]] = None,
                 branch_configuration: Optional[pulumi.Input[str]] = None,
                 cancel_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 cancel_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_settings: Optional[pulumi.Input['PipelineProviderSettingsArgs']] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 skip_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 skip_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]] = None,
                 webhook_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[str] badge_url: The pipeline's last build status so you can display build status badge.
        :param pulumi.Input[str] branch_configuration: Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        :param pulumi.Input[bool] cancel_intermediate_builds: A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        :param pulumi.Input[str] cancel_intermediate_builds_branch_filter: Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        :param pulumi.Input[str] cluster_id: The GraphQL ID of the cluster you want to use for the pipeline.
        :param pulumi.Input[str] default_branch: The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        :param pulumi.Input[str] description: A description of the pipeline.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input['PipelineProviderSettingsArgs'] provider_settings: Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        :param pulumi.Input[str] repository: The git URL of the repository.
        :param pulumi.Input[bool] skip_intermediate_builds: A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        :param pulumi.Input[str] skip_intermediate_builds_branch_filter: Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        :param pulumi.Input[str] slug: The buildkite slug of the team.
        :param pulumi.Input[str] steps: The string YAML steps to run the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]] teams: Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        :param pulumi.Input[str] webhook_url: The Buildkite webhook URL to configure on the repository to trigger builds on this pipeline.
        """
        if badge_url is not None:
            pulumi.set(__self__, "badge_url", badge_url)
        if branch_configuration is not None:
            pulumi.set(__self__, "branch_configuration", branch_configuration)
        if cancel_intermediate_builds is not None:
            pulumi.set(__self__, "cancel_intermediate_builds", cancel_intermediate_builds)
        if cancel_intermediate_builds_branch_filter is not None:
            pulumi.set(__self__, "cancel_intermediate_builds_branch_filter", cancel_intermediate_builds_branch_filter)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_settings is not None:
            pulumi.set(__self__, "provider_settings", provider_settings)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if skip_intermediate_builds is not None:
            pulumi.set(__self__, "skip_intermediate_builds", skip_intermediate_builds)
        if skip_intermediate_builds_branch_filter is not None:
            pulumi.set(__self__, "skip_intermediate_builds_branch_filter", skip_intermediate_builds_branch_filter)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)
        if webhook_url is not None:
            pulumi.set(__self__, "webhook_url", webhook_url)

    @property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> Optional[pulumi.Input[str]]:
        """
        The pipeline's last build status so you can display build status badge.
        """
        return pulumi.get(self, "badge_url")

    @badge_url.setter
    def badge_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "badge_url", value)

    @property
    @pulumi.getter(name="branchConfiguration")
    def branch_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        """
        return pulumi.get(self, "branch_configuration")

    @branch_configuration.setter
    def branch_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_configuration", value)

    @property
    @pulumi.getter(name="cancelIntermediateBuilds")
    def cancel_intermediate_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "cancel_intermediate_builds")

    @cancel_intermediate_builds.setter
    def cancel_intermediate_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cancel_intermediate_builds", value)

    @property
    @pulumi.getter(name="cancelIntermediateBuildsBranchFilter")
    def cancel_intermediate_builds_branch_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        """
        return pulumi.get(self, "cancel_intermediate_builds_branch_filter")

    @cancel_intermediate_builds_branch_filter.setter
    def cancel_intermediate_builds_branch_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cancel_intermediate_builds_branch_filter", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The GraphQL ID of the cluster you want to use for the pipeline.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="providerSettings")
    def provider_settings(self) -> Optional[pulumi.Input['PipelineProviderSettingsArgs']]:
        """
        Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        """
        return pulumi.get(self, "provider_settings")

    @provider_settings.setter
    def provider_settings(self, value: Optional[pulumi.Input['PipelineProviderSettingsArgs']]):
        pulumi.set(self, "provider_settings", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[str]]:
        """
        The git URL of the repository.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter(name="skipIntermediateBuilds")
    def skip_intermediate_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "skip_intermediate_builds")

    @skip_intermediate_builds.setter
    def skip_intermediate_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_intermediate_builds", value)

    @property
    @pulumi.getter(name="skipIntermediateBuildsBranchFilter")
    def skip_intermediate_builds_branch_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        """
        return pulumi.get(self, "skip_intermediate_builds_branch_filter")

    @skip_intermediate_builds_branch_filter.setter
    def skip_intermediate_builds_branch_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_intermediate_builds_branch_filter", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The buildkite slug of the team.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[str]]:
        """
        The string YAML steps to run the pipeline.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]]:
        """
        Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineTeamArgs']]]]):
        pulumi.set(self, "teams", value)

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Buildkite webhook URL to configure on the repository to trigger builds on this pipeline.
        """
        return pulumi.get(self, "webhook_url")

    @webhook_url.setter
    def webhook_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_url", value)


class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_configuration: Optional[pulumi.Input[str]] = None,
                 cancel_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 cancel_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_settings: Optional[pulumi.Input[pulumi.InputType['PipelineProviderSettingsArgs']]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 skip_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 skip_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineTeamArgs']]]]] = None,
                 __props__=None):
        """
        ## # Resource: pipeline

        This resource allows you to create and manage pipelines for repositories.

        Buildkite Documentation: https://buildkite.com/docs/pipelines

        ## Example Usage

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        # in ./steps.yml:
        # steps:
        #   - label: ':pipeline:'
        #     command: buildkite-agent pipeline upload
        repo2 = buildkite.Pipeline("repo2",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./steps.yml"),
            teams=[buildkite.PipelineTeamArgs(
                slug="everyone",
                access_level="READ_ONLY",
            )])
        ```
        ### With GitHub Provider Settings

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        # Pipeline that should not be triggered from a GitHub webhook
        repo2_deploy = buildkite.Pipeline("repo2-deploy",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./deploy-steps.yml"),
            provider_settings=buildkite.PipelineProviderSettingsArgs(
                trigger_mode="none",
            ))
        # Release pipeline (triggered only when tags are pushed)
        repo2_release = buildkite.Pipeline("repo2-release",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./release-steps.yml"),
            provider_settings=buildkite.PipelineProviderSettingsArgs(
                build_branches=False,
                build_tags=True,
                build_pull_requests=False,
                trigger_mode="code",
            ))
        ```

        ## Import

        Pipelines can be imported using the `GraphQL ID` (not UUID), e.g.

        ```sh
         $ pulumi import buildkite:index/pipeline:Pipeline fleet UGlwZWxpbmUtLS00MzVjYWQ1OC1lODFkLTQ1YWYtODYzNy1iMWNmODA3MDIzOGQ=
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch_configuration: Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        :param pulumi.Input[bool] cancel_intermediate_builds: A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        :param pulumi.Input[str] cancel_intermediate_builds_branch_filter: Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        :param pulumi.Input[str] cluster_id: The GraphQL ID of the cluster you want to use for the pipeline.
        :param pulumi.Input[str] default_branch: The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        :param pulumi.Input[str] description: A description of the pipeline.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input[pulumi.InputType['PipelineProviderSettingsArgs']] provider_settings: Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        :param pulumi.Input[str] repository: The git URL of the repository.
        :param pulumi.Input[bool] skip_intermediate_builds: A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        :param pulumi.Input[str] skip_intermediate_builds_branch_filter: Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        :param pulumi.Input[str] steps: The string YAML steps to run the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineTeamArgs']]]] teams: Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: pipeline

        This resource allows you to create and manage pipelines for repositories.

        Buildkite Documentation: https://buildkite.com/docs/pipelines

        ## Example Usage

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        # in ./steps.yml:
        # steps:
        #   - label: ':pipeline:'
        #     command: buildkite-agent pipeline upload
        repo2 = buildkite.Pipeline("repo2",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./steps.yml"),
            teams=[buildkite.PipelineTeamArgs(
                slug="everyone",
                access_level="READ_ONLY",
            )])
        ```
        ### With GitHub Provider Settings

        ```python
        import pulumi
        import pulumi_buildkite as buildkite

        # Pipeline that should not be triggered from a GitHub webhook
        repo2_deploy = buildkite.Pipeline("repo2-deploy",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./deploy-steps.yml"),
            provider_settings=buildkite.PipelineProviderSettingsArgs(
                trigger_mode="none",
            ))
        # Release pipeline (triggered only when tags are pushed)
        repo2_release = buildkite.Pipeline("repo2-release",
            repository="git@github.com:org/repo2",
            steps=(lambda path: open(path).read())("./release-steps.yml"),
            provider_settings=buildkite.PipelineProviderSettingsArgs(
                build_branches=False,
                build_tags=True,
                build_pull_requests=False,
                trigger_mode="code",
            ))
        ```

        ## Import

        Pipelines can be imported using the `GraphQL ID` (not UUID), e.g.

        ```sh
         $ pulumi import buildkite:index/pipeline:Pipeline fleet UGlwZWxpbmUtLS00MzVjYWQ1OC1lODFkLTQ1YWYtODYzNy1iMWNmODA3MDIzOGQ=
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_configuration: Optional[pulumi.Input[str]] = None,
                 cancel_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 cancel_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_settings: Optional[pulumi.Input[pulumi.InputType['PipelineProviderSettingsArgs']]] = None,
                 repository: Optional[pulumi.Input[str]] = None,
                 skip_intermediate_builds: Optional[pulumi.Input[bool]] = None,
                 skip_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[str]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineTeamArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["branch_configuration"] = branch_configuration
            __props__.__dict__["cancel_intermediate_builds"] = cancel_intermediate_builds
            __props__.__dict__["cancel_intermediate_builds_branch_filter"] = cancel_intermediate_builds_branch_filter
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["provider_settings"] = provider_settings
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
            __props__.__dict__["skip_intermediate_builds"] = skip_intermediate_builds
            __props__.__dict__["skip_intermediate_builds_branch_filter"] = skip_intermediate_builds_branch_filter
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
            __props__.__dict__["teams"] = teams
            __props__.__dict__["badge_url"] = None
            __props__.__dict__["slug"] = None
            __props__.__dict__["webhook_url"] = None
        super(Pipeline, __self__).__init__(
            'buildkite:index/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            badge_url: Optional[pulumi.Input[str]] = None,
            branch_configuration: Optional[pulumi.Input[str]] = None,
            cancel_intermediate_builds: Optional[pulumi.Input[bool]] = None,
            cancel_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            default_branch: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            provider_settings: Optional[pulumi.Input[pulumi.InputType['PipelineProviderSettingsArgs']]] = None,
            repository: Optional[pulumi.Input[str]] = None,
            skip_intermediate_builds: Optional[pulumi.Input[bool]] = None,
            skip_intermediate_builds_branch_filter: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None,
            steps: Optional[pulumi.Input[str]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineTeamArgs']]]]] = None,
            webhook_url: Optional[pulumi.Input[str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] badge_url: The pipeline's last build status so you can display build status badge.
        :param pulumi.Input[str] branch_configuration: Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        :param pulumi.Input[bool] cancel_intermediate_builds: A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        :param pulumi.Input[str] cancel_intermediate_builds_branch_filter: Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        :param pulumi.Input[str] cluster_id: The GraphQL ID of the cluster you want to use for the pipeline.
        :param pulumi.Input[str] default_branch: The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        :param pulumi.Input[str] description: A description of the pipeline.
        :param pulumi.Input[str] name: The name of the pipeline.
        :param pulumi.Input[pulumi.InputType['PipelineProviderSettingsArgs']] provider_settings: Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        :param pulumi.Input[str] repository: The git URL of the repository.
        :param pulumi.Input[bool] skip_intermediate_builds: A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        :param pulumi.Input[str] skip_intermediate_builds_branch_filter: Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        :param pulumi.Input[str] slug: The buildkite slug of the team.
        :param pulumi.Input[str] steps: The string YAML steps to run the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineTeamArgs']]]] teams: Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        :param pulumi.Input[str] webhook_url: The Buildkite webhook URL to configure on the repository to trigger builds on this pipeline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["badge_url"] = badge_url
        __props__.__dict__["branch_configuration"] = branch_configuration
        __props__.__dict__["cancel_intermediate_builds"] = cancel_intermediate_builds
        __props__.__dict__["cancel_intermediate_builds_branch_filter"] = cancel_intermediate_builds_branch_filter
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["provider_settings"] = provider_settings
        __props__.__dict__["repository"] = repository
        __props__.__dict__["skip_intermediate_builds"] = skip_intermediate_builds
        __props__.__dict__["skip_intermediate_builds_branch_filter"] = skip_intermediate_builds_branch_filter
        __props__.__dict__["slug"] = slug
        __props__.__dict__["steps"] = steps
        __props__.__dict__["teams"] = teams
        __props__.__dict__["webhook_url"] = webhook_url
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> pulumi.Output[str]:
        """
        The pipeline's last build status so you can display build status badge.
        """
        return pulumi.get(self, "badge_url")

    @property
    @pulumi.getter(name="branchConfiguration")
    def branch_configuration(self) -> pulumi.Output[str]:
        """
        Limit which branches and tags cause new builds to be created, either via a code push or via the Builds REST API.
        """
        return pulumi.get(self, "branch_configuration")

    @property
    @pulumi.getter(name="cancelIntermediateBuilds")
    def cancel_intermediate_builds(self) -> pulumi.Output[bool]:
        """
        A boolean to enable automatically cancelling any running builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "cancel_intermediate_builds")

    @property
    @pulumi.getter(name="cancelIntermediateBuildsBranchFilter")
    def cancel_intermediate_builds_branch_filter(self) -> pulumi.Output[str]:
        """
        Limit which branches build cancelling applies to, for example !master will ensure that the master branch won't have it's builds automatically cancelled.
        """
        return pulumi.get(self, "cancel_intermediate_builds_branch_filter")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The GraphQL ID of the cluster you want to use for the pipeline.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[str]:
        """
        The default branch to prefill when new builds are created or triggered, usually main or master but can be anything.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerSettings")
    def provider_settings(self) -> pulumi.Output['outputs.PipelineProviderSettings']:
        """
        Source control provider settings for the pipeline. See Provider Settings Configuration below for details.
        """
        return pulumi.get(self, "provider_settings")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[str]:
        """
        The git URL of the repository.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="skipIntermediateBuilds")
    def skip_intermediate_builds(self) -> pulumi.Output[bool]:
        """
        A boolean to enable automatically skipping any unstarted builds on the same branch when a new build is created.
        """
        return pulumi.get(self, "skip_intermediate_builds")

    @property
    @pulumi.getter(name="skipIntermediateBuildsBranchFilter")
    def skip_intermediate_builds_branch_filter(self) -> pulumi.Output[str]:
        """
        Limit which branches build skipping applies to, for example `!master` will ensure that the master branch won't have it's builds automatically skipped.
        """
        return pulumi.get(self, "skip_intermediate_builds_branch_filter")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        The buildkite slug of the team.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[str]:
        """
        The string YAML steps to run the pipeline.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineTeam']]]:
        """
        Set team access for the pipeline. Can be specified multiple times for each team. See Teams Configuration below for details.
        """
        return pulumi.get(self, "teams")

    @property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> pulumi.Output[str]:
        """
        The Buildkite webhook URL to configure on the repository to trigger builds on this pipeline.
        """
        return pulumi.get(self, "webhook_url")

