# gitlab-ci-generator
This project builds a dynamic gitlab ci file that is intended to be used for monorepos.  The concept is to simplify the amount of work that is needed to manage the monorepo.

## Installation
You can download and run directly with python or install using:
```
pip install gitlab-ci-generator
```

## Usage
The project takes the following parameters:
|Name|Parameter|Description|Required|
|-----|--------|-----------|--------|
|Input File|--inputfile/-f|The yaml file that will be used to render the gitlab ci file.|Yes|
|Output File|--outputfile/-o|The yaml file that is rendered using the jinja2 template with data from the input yaml file.|Yes|
|Template File|--templatefile/-t|A jinja2 file that can be used to override default templating|No|
|Help|-h|Displays help info|No|

This program will load the input yaml file into two distinct dictionaries that are available to the template:
* pipeline_info
* jobs

### pipeline_info
This section is gets loaded as is into a dictionary so you can easily extend it for your needs.  The built-in template uses the following:
```
pipeline_info:
  shared_includes:  <<- Used by the template to build the include: section of the gitlab ci file.
    - name: rules <<- List of includes and can be of type local or project.  The rules example here is used in the template in concert with the share_reference_rules: section to define dynamic rules for jobs.
      local: "example/example-config/rules.yml" 
  shared_reference_rules: <<- Used by the template to build the rules: section of the gitlab ci under each job.
    - rule_name: standard-rule-if <<- The rule_source and rule_name will create a !reference[rule_source, rule_name] value under the rules section of each job.
      rule_source: .job_changes_rules
      only_changes: true
```

### jobs
This section is used to define the hierarchy for the gitlab jobs.  This section is not extensible and should be structured as follows:
```
jobs: <<-- List of jobs and dependencies that will build the appropriate changes/needs logic in the generated gitlab ci file.
  - name: example-1 <<-- name: will be the job name in the generated gitlab file and is required. 
    folder: example/example-folder-1 <<-- folder: The subfolder in the gitlab repo that will be monitored for changes and contains the sub-repo in the monorepo.
    gitlab_yml_file: .gitlab-example.yml <<--  gitlab_yml_file: is the pipeline file that will be triggered in the folder: that is specified
    dependent_jobs: <<-- dependent_jobs: is a list of dependent jobs and can have dependent_jobs on its jobs.  In other words, this can go multiple levels deep with dependencies.  
      - name: example-2
        folder: example/example-folder-2
        gitlab_yml_file: .gitlab-example.yml
```

### Sample Output
Using the jinja template [here](src/templates/gitlab-template.jinja) and the data from [example/example-config/job-dependency.yml](example/example-config/job-dependency.yml)
```
include:
    - local: 'example/example-config/rules.yml'

stages:
  - build

example-1:
  stage: build
  rules:
    - if: !reference [.job_changes_rules,standard-rule-if]
      changes:
        - example/example-folder-1/**/*
    - if: !reference [.job_changes_rules,manual-rule-if]
      when: manual
      changes:
        - example/example-folder-1/**/*
    - if: !reference [.job_changes_rules,schedule-rule-if]
  trigger:
    include: example/example-folder-1/.gitlab-example.yml    
    strategy: depend
 

example-2:
  stage: build
  rules:
    - if: !reference [.job_changes_rules,standard-rule-if]
      changes:
        - example/example-folder-2/**/*
        - example/example-folder-1/**/*
    - if: !reference [.job_changes_rules,manual-rule-if]
      when: manual
      changes:
        - example/example-folder-2/**/*
        - example/example-folder-1/**/*
    - if: !reference [.job_changes_rules,schedule-rule-if]
  needs: 
    - job: example-1
      optional: true 
  trigger:
    include: example/example-folder-2/.gitlab-example.yml    
    strategy: depend
```

## License
MIT License