# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tbxforms', 'tbxforms.layout', 'tbxforms.templatetags']

package_data = \
{'': ['*'],
 'tbxforms': ['static/js/tbxforms.js',
              'static/sass/abstracts/*',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_checkboxes.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_conditional.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_date-input.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-message.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_error-summary.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_fieldset.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_file-upload.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_form-group.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_hint.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_input.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_label.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_radios.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_select.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/components/_textarea.scss',
              'static/sass/helpers/_clearfix.scss',
              'static/sass/helpers/_clearfix.scss',
              'static/sass/helpers/_visually-hidden.scss',
              'static/sass/helpers/_visually-hidden.scss',
              'static/sass/tbxforms.scss',
              'static/sass/utilities/_clearfix.scss',
              'static/sass/utilities/_clearfix.scss',
              'static/sass/utilities/_visually-hidden.scss',
              'static/sass/utilities/_visually-hidden.scss',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/display_form.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/errors.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/field.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/inputs.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/baseinput.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/button.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/checkboxes.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/div.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/field_errors.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/fieldset.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/help_text_and_errors.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/multifield.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/layout/radios.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_form.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/uni_formset.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_form.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/whole_uni_formset.html',
              'templates/tbx/widgets/*']}

install_requires = \
['Django>=2.2,<4.0', 'django-crispy-forms==1.13.0']

setup_kwargs = {
    'name': 'tbxforms',
    'version': '1.0.3',
    'description': 'A Torchbox-flavoured template pack for django-crispy-forms, adapted from crispy-forms-gds',
    'long_description': '[![PyPI](https://img.shields.io/pypi/v/tbxforms.svg)](https://pypi.org/project/tbxforms/)\n[![npm](https://img.shields.io/npm/v/tbxforms.svg)](https://www.npmjs.com/package/tbxforms) [![PyPI downloads](https://img.shields.io/pypi/dm/tbxforms.svg)](https://pypi.org/project/tbxforms/)\n[![Build status](https://github.com/kbayliss/tbxforms/workflows/CI/badge.svg)](https://github.com/kbayliss/tbxforms/actions)\n[![Coverage Status](https://coveralls.io/repos/github/kbayliss/tbxforms/badge.svg?branch=main)](https://coveralls.io/github/kbayliss/tbxforms?branch=main)\n[![Total alerts](https://img.shields.io/lgtm/alerts/g/kbayliss/tbxforms.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/kbayliss/tbxforms/alerts/)\n\n# Torchbox Forms\n\nA Torchbox-flavoured template pack for [django-crispy-forms](https://github.com/django-crispy-forms/django-crispy-forms), adapted from [crispy-forms-gds](https://github.com/wildfish/crispy-forms-gds).\n\nOut of the box, forms created with `tbxforms` will look like the\n[GOV.UK Design System](https://design-system.service.gov.uk/), though many\nvariables can be customised.\n\n## Contents\n\n-   [Torchbox Forms](#torchbox-forms)\n    -   [Installation](#installation)\n        -   [Install the Python package](#install-the-python-package)\n        -   [Install the NPM package](#install-the-npm-package)\n    -   [Usage](#usage)\n        -   [Create a Django form](#creating-a-django-form)\n        -   [Create a Wagtail form](#creating-a-wagtail-form)\n            -   [Add a `helper` property to the Wagtail form](#add-a--helper--property-to-the-wagtail-form)\n            -   [Instruct a Wagtail Page model to use the newly created form](#instruct-a-wagtail-page-model-to-use-the-newly-created-form)\n        -   [Render a form](#render-a-form)\n        -   [Customise a form\'s attributes (via the `helper` property)](#customising-a-form-s-attributes--via-the--helper--property-)\n            -   [Possible values for the `label_size` and `legend_size`:](#possible-values-for-the--label-size--and--legend-size--)\n        -   [Conditionally-required fields](#conditionally-required-fields)\n-   [Further reading](#further-reading)\n\n## Installation\n\nYou must install both a Python package and an NPM package.\n\n### Install the Python package\n\nInstall using pip:\n\n```bash\npip install tbxforms\n```\n\nAdd `django-crispy-forms` and `tbxforms` to your installed apps:\n\n```python\nINSTALLED_APPS = [\n  ...\n  \'crispy_forms\',  # django-crispy-forms\n  \'tbxforms\',\n]\n```\n\nNow add the following settings to tell `django-crispy-forms` to use this theme:\n\n```python\nCRISPY_ALLOWED_TEMPLATE_PACKS = ["tbx"]\nCRISPY_TEMPLATE_PACK = "tbx"\n```\n\n### Install the NPM package\n\nInstall using NPM:\n\n```bash\nnpm install tbxforms\n```\n\nInstantiate your forms:\n\n```javascript\nimport TbxForms from \'tbxforms\';\n\ndocument.addEventListener(\'DOMContentLoaded\', () => {\n    for (const form of document.querySelectorAll(TbxForms.selector())) {\n        new TbxForms(form);\n    }\n});\n```\n\nImport the styles into your project, either as CSS:\n\n```scss\n// Either as CSS without any customisations:\n@use \'node_modules/tbxforms/style.css\';\n```\n\nOr as Sass, to customise variables:\n\n```scss\n// Or as Sass, with variables to customise:\n@use \'node_modules/tbxforms/tbxforms.scss\' with (\n    $tbxforms-error-colour: #f00,\n    $tbxforms-text-colour: #000,\n);\n```\n\nVariables can also be defined in a centralised variables SCSS file, too.\n\nSee [tbxforms/static/sass/abstracts/\\_variables.scss](https://github.com/kbayliss/tbxforms/blob/main/tbxforms/static/sass/abstracts/_variables.scss) for customisable variables.\n\n## Usage\n\n### Create a Django form\n\n```python\nfrom tbxforms.forms import BaseForm as TbxFormsBaseForm\n\nclass ExampleForm(TbxFormsBaseForm, forms.Form):\n    # < Your field definitions >\n\n\nclass ExampleModelForm(TbxFormsBaseForm, forms.ModelForm):\n    # < Your field definitions and ModelForm config >\n\n```\n\n### Create a Wagtail form\n\nTwo parts are required for this to work:\n\n1. Add a `helper` property to the Wagtail form\n2. Instruct a Wagtail Page model to use the newly created form\n\n#### Add a `helper` property to the Wagtail form\n\n```python\nfrom wagtail.contrib.forms.forms import BaseForm as WagtailBaseForm\nfrom tbxforms.forms import BaseForm as TbxFormsBaseForm\n\nclass ExampleWagtailForm(TbxFormsBaseForm, WagtailBaseForm):\n\n    # Extend the `TbxFormsBaseForm.helper()` to add a submit button.\n    @property\n    def helper(self):\n        fh = super().helper\n        fh.add_input(\n            Button.primary(\n                name="submit",\n                type="submit",\n                value=_("Submit"),\n            )\n        )\n        return fh\n```\n\n#### Instruct a Wagtail Page model to use the newly created form\n\n```python\n# -----------------------------------------------------------------------------\n# in your forms definitions (e.g. forms.py)\n\nfrom tbxforms.forms import BaseWagtailFormBuilder as TbxFormsBaseWagtailFormBuilder\nfrom path.to.your.forms import ExampleWagtailForm\n\nclass WagtailFormBuilder(TbxFormsBaseWagtailFormBuilder):\n    def get_form_class(self):\n        return type(str("WagtailForm"), (ExampleWagtailForm,), self.formfields)\n\n# -----------------------------------------------------------------------------\n# in your page models (e.g. models.py)\n\nfrom path.to.your.forms import WagtailFormBuilder\n\nclass ExampleFormPage(...):\n    ...\n    form_builder = WagtailFormBuilder\n    ...\n```\n\n### Render a form\n\nJust like Django Crispy Forms, you need to pass your form object to the\n`{% crispy ... %}` template tag, e.g.:\n\n```\n{% load crispy_forms_tags %}\n{% crispy your_form %}\n```\n\n### Customise a form\'s attributes (via the `helper` property)\n\nBy default, every form that inherits from `TbxFormsBaseForm` will have the following\nattributes set:\n\n-   `html5_required = True`\n-   `label_size = Size.MEDIUM`\n-   `legend_size = Size.MEDIUM`\n-   `form_error_title = _("There is a problem with your submission")`\n-   Plus everything from [django-crispy-forms\' default attributes](https://django-crispy-forms.readthedocs.io/en/latest/form_helper.html).\n\nThese can be overridden (and/or additional attributes from the above list defined)\njust like you would do with any other inherited class, e.g.:\n\n```python\n\nclass YourSexyForm(TbxFormsBaseForm, forms.Form):\n\n    @property\n    def helper(self):\n        fh = super().helper\n        fh.html5_required = False\n        fh.label_size = Size.SMALL\n        fh.form_error_title = _("Something\'s wrong, yo.")\n        return fh\n\n```\n\n#### Possible values for the `label_size` and `legend_size`:\n\n1. `SMALL`\n2. `MEDIUM` (default)\n3. `LARGE`\n4. `EXTRA_LARGE`\n\n### Conditionally-required fields\n\n`tbxforms` supports hiding/showing of fields and/or `div`/`fieldset` elements\nbased on the values of a given input field.\n\n**Field example:**\n\n```python\nclass ExampleForm(TbxFormsBaseForm, forms.Form):\n    NEWSLETTER_CHOICES = (\n        Choice("yes", "Yes please", hint="Receive occasional email newsletters."),\n        Choice("no", "No thanks"),\n    )\n\n    newsletter_signup = forms.ChoiceField(\n        choices=NEWSLETTER_CHOICES\n    )\n\n    email = forms.EmailField(\n        widget=forms.EmailInput(required=False)\n    )\n\n    @staticmethod\n    def conditional_fields_to_show_as_required() -> [str]:\n        return [\n            "email", # Include any fields that should show as required to the user.\n        ]\n\n    @property\n    def helper(self):\n        fh = super().helper\n\n        # Override what is rendered for this form.\n        fh.layout = Layout(\n\n            # Add our newsletter sign-up field.\n            Field("newsletter_signup"),\n\n            # Add our email field, and define the conditional \'show\' logic.\n            Field(\n                "email",\n                data_conditional={\n                    "field_name": "newsletter_signup", # Field to inspect.\n                    "values": ["yes"], # Value(s) to cause this field to show.\n                },\n            ),\n\n        )\n\n        return fh\n\n\n    def clean(self):\n        cleaned_data = super().clean()\n        newsletter_signup = cleaned_data.get("newsletter_signup")\n        email = cleaned_data.get("email")\n\n        # Assuming `form.helper.html5_required == True`, tbxforms will toggle the\n        # html5 \'required\' attribute when a conditionally-required field is shown,\n        # though it is recommended to also check the value in your clean() method.\n        if newsletter_signup == "yes" and not email:\n            raise ValidationError(\n                {\n                    "email": _("This field is required."),\n                }\n            )\n        # The tbxforms JS will attempt to clear any redundant data upon submission,\n        # though it is recommended to also handle this in your clean() method.\n        elif newsletter_signup == "no" and email:\n            del cleaned_data[\'email\']\n\n        return cleaned_data\n\n```\n\n**Container example:**\n\nWhen you have multiple fields/elements that you want to show/hide together, you\ncan use the exact same `data_conditional` definition as above but on a `div` or\n`fieldset` element, e.g.:\n\n```python\nDiv(\n    HTML("<p>Some relevant text.</p>"),\n    Field("some_other_field"),\n    Field("email"),\n    data_conditional={\n        "field_name": "newsletter_signup",\n        "values": ["yes"],\n    },\n),\n\n```\n\n# Further reading\n\n-   Download the [PyPi package](http://pypi.python.org/pypi/tbxforms)\n-   Download the [NPM package](https://www.npmjs.com/package/tbxforms)\n-   Learn more about [Django Crispy Forms](https://django-crispy-forms.readthedocs.io/en/latest/)\n-   Learn more about [Crispy Forms GDS](https://github.com/wildfish/crispy-forms-gds)\n-   Learn more about [GOV.UK Design System](https://design-system.service.gov.uk/)\n',
    'author': 'Kyle Bayliss',
    'author_email': 'kyle.bayliss@torchbox.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kbayliss/tbxforms/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
