"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_redshift_1 = require("aws-cdk-lib/aws-redshift");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends aws_cdk_lib_1.Resource {
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Redshift::ClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ClusterParameterGroup);
            }
            throw error;
        }
        const resource = new aws_redshift_1.CfnClusterParameterGroup(this, 'Resource', {
            description: props.description || 'Cluster parameter group for family redshift-1.0',
            parameterGroupFamily: 'redshift-1.0',
            parameters: Object.entries(props.parameters).map(([name, value]) => {
                return { parameterName: name, parameterValue: value };
            }),
        });
        this.clusterParameterGroupName = resource.ref;
    }
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.ClusterParameterGroup", version: "2.37.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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