/**
 * Connection endpoint of a redshift cluster
 *
 * Consists of a combination of hostname and port.
 */
export declare class Endpoint {
    /**
     * The hostname of the endpoint
     */
    readonly hostname: string;
    /**
     * The port of the endpoint
     */
    readonly port: number;
    /**
     * The combination of "HOSTNAME:PORT" for this endpoint
     */
    readonly socketAddress: string;
    constructor(address: string, port: number);
}
