# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class JobClientOperations(object):
    """JobClientOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: The API version to use for the request. Constant value: "2020-05-31-preview".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config
        self.api_version = "2020-05-31-preview"

    def create_import_export_job(
        self, job_properties, custom_headers=None, raw=False, **operation_config
    ):
        """Create a new import/export job on an IoT hub.

        Create a new import/export job on an IoT hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param job_properties: Specifies the job specification.
        :type job_properties: ~protocol.models.JobProperties
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobProperties or ClientRawResponse if raw=true
        :rtype: ~protocol.models.JobProperties or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_import_export_job.metadata["url"]

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(job_properties, "JobProperties")

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("JobProperties", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    create_import_export_job.metadata = {"url": "/jobs/create"}

    def get_import_export_jobs(self, custom_headers=None, raw=False, **operation_config):
        """Gets the status of all import/export jobs in an iot hub.

        Gets the status of all import/export jobs in an iot hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~protocol.models.JobProperties] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_import_export_jobs.metadata["url"]

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("[JobProperties]", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    get_import_export_jobs.metadata = {"url": "/jobs"}

    def get_import_export_job(self, id, custom_headers=None, raw=False, **operation_config):
        """Gets the status of an import or export job in an iot hub.

        Gets the status of an import or export job in an iot hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Job ID.
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobProperties or ClientRawResponse if raw=true
        :rtype: ~protocol.models.JobProperties or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_import_export_job.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("JobProperties", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    get_import_export_job.metadata = {"url": "/jobs/{id}"}

    def cancel_import_export_job(self, id, custom_headers=None, raw=False, **operation_config):
        """Cancels an import or export job in an IoT hub.

        Cancels an import or export job in an IoT hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Job ID.
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.cancel_import_export_job.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("object", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    cancel_import_export_job.metadata = {"url": "/jobs/{id}"}

    def get_job(self, id, custom_headers=None, raw=False, **operation_config):
        """Retrieves details of a scheduled job from an IoT hub.

        Retrieves details of a scheduled job from an IoT hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Job ID.
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobResponse or ClientRawResponse if raw=true
        :rtype: ~protocol.models.JobResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_job.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("JobResponse", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    get_job.metadata = {"url": "/jobs/v2/{id}"}

    def create_job(self, id, job_request, custom_headers=None, raw=False, **operation_config):
        """Creates a new job to schedule update twins or device direct methods on
        an IoT hub at a scheduled time.

        Creates a new job to schedule update twins or device direct methods on
        an IoT hub at a scheduled time. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Job ID.
        :type id: str
        :param job_request:
        :type job_request: ~protocol.models.JobRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobResponse or ClientRawResponse if raw=true
        :rtype: ~protocol.models.JobResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_job.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(job_request, "JobRequest")

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("JobResponse", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    create_job.metadata = {"url": "/jobs/v2/{id}"}

    def cancel_job(self, id, custom_headers=None, raw=False, **operation_config):
        """Cancels a scheduled job on an IoT hub.

        Cancels a scheduled job on an IoT hub. See
        https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs
        for more information. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Job ID.
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JobResponse or ClientRawResponse if raw=true
        :rtype: ~protocol.models.JobResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.cancel_job.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("JobResponse", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    cancel_job.metadata = {"url": "/jobs/v2/{id}/cancel"}

    def query_jobs(
        self, job_type=None, job_status=None, custom_headers=None, raw=False, **operation_config
    ):
        """Query an IoT hub to retrieve information regarding jobs using the IoT
        Hub query language.

        Query an IoT hub to retrieve information regarding jobs using the IoT
        Hub query language. See
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        for more information. Pagination of results is supported. This returns
        information about jobs only. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param job_type: Job Type.
        :type job_type: str
        :param job_status: Job Status.
        :type job_status: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: QueryResult or ClientRawResponse if raw=true
        :rtype: ~protocol.models.QueryResult or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.query_jobs.metadata["url"]

        # Construct parameters
        query_parameters = {}
        if job_type is not None:
            query_parameters["jobType"] = self._serialize.query("job_type", job_type, "str")
        if job_status is not None:
            query_parameters["jobStatus"] = self._serialize.query("job_status", job_status, "str")
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("QueryResult", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    query_jobs.metadata = {"url": "/jobs/v2/query"}
