# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class ConfigurationOperations(object):
    """ConfigurationOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: The API version to use for the request. Constant value: "2020-05-31-preview".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config
        self.api_version = "2020-05-31-preview"

    def get(self, id, custom_headers=None, raw=False, **operation_config):
        """Retrieve a configuration for Iot Hub devices and modules by it
        identifier.

        For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Configuration or ClientRawResponse if raw=true
        :rtype: ~protocol.models.Configuration or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("Configuration", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    get.metadata = {"url": "/configurations/{id}"}

    def create_or_update(
        self, id, configuration, if_match=None, custom_headers=None, raw=False, **operation_config
    ):
        """Create or update the configuration for devices or modules of an IoT
        hub. An ETag must not be specified for the create operation. An ETag
        must be specified for the update operation. Note that configuration Id
        and Content cannot be updated by the user.

        For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id:
        :type id: str
        :param configuration:
        :type configuration: ~protocol.models.Configuration
        :param if_match:
        :type if_match: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Configuration or ClientRawResponse if raw=true
        :rtype: ~protocol.models.Configuration or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_or_update.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)
        if if_match is not None:
            header_parameters["If-Match"] = self._serialize.header("if_match", if_match, "str")

        # Construct body
        body_content = self._serialize.body(configuration, "Configuration")

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 201]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("Configuration", response)
        if response.status_code == 201:
            deserialized = self._deserialize("Configuration", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    create_or_update.metadata = {"url": "/configurations/{id}"}

    def delete(self, id, if_match=None, custom_headers=None, raw=False, **operation_config):
        """Delete the configuration for devices or modules of an IoT hub. This
        request requires the If-Match header. The client may specify the ETag
        for the device identity on the request in order to compare to the ETag
        maintained by the service for the purpose of optimistic concurrency.
        The delete operation is performed only if the ETag sent by the client
        matches the value maintained by the server, indicating that the device
        identity has not been modified since it was retrieved by the client. To
        force an unconditional delete, set If-Match to the wildcard character
        (*).

        For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id:
        :type id: str
        :param if_match:
        :type if_match: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)
        if if_match is not None:
            header_parameters["If-Match"] = self._serialize.header("if_match", if_match, "str")

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    delete.metadata = {"url": "/configurations/{id}"}

    def get_configurations(self, top=None, custom_headers=None, raw=False, **operation_config):
        """Get multiple configurations for devices or modules of an IoT Hub.
        Returns the specified number of configurations for Iot Hub. Pagination
        is not supported.

        For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param top:
        :type top: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~protocol.models.Configuration] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_configurations.metadata["url"]

        # Construct parameters
        query_parameters = {}
        if top is not None:
            query_parameters["top"] = self._serialize.query("top", top, "int")
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("[Configuration]", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    get_configurations.metadata = {"url": "/configurations"}

    def test_queries(self, input, custom_headers=None, raw=False, **operation_config):
        """Validates the target condition query and custom metric queries for a
        configuration.

        Validates the target condition query and custom metric queries for a
        configuration. For IoT Hub VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param input:
        :type input: ~protocol.models.ConfigurationQueriesTestInput
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ConfigurationQueriesTestResponse or ClientRawResponse if
         raw=true
        :rtype: ~protocol.models.ConfigurationQueriesTestResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.test_queries.metadata["url"]

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(input, "ConfigurationQueriesTestInput")

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("ConfigurationQueriesTestResponse", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    test_queries.metadata = {"url": "/configurations/testQueries"}

    def apply_on_edge_device(self, id, content, custom_headers=None, raw=False, **operation_config):
        """Applies the provided configuration content to the specified edge
        device.

        Applies the provided configuration content to the specified edge
        device. Configuration content must have modules content For IoT Hub
        VNET related
        features(https://docs.microsoft.com/en-us/azure/iot-hub/virtual-network-support)
        please use API version '2020-03-13'.These features are currently in
        general availability in the East US, West US 2, and Southcentral US
        regions only. We are actively working to expand the availability of
        these features to all regions by end of month May. For rest of the APIs
        please continue using API version '2019-10-01'.

        :param id: Device ID.
        :type id: str
        :param content: Configuration Content.
        :type content: ~protocol.models.ConfigurationContent
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.apply_on_edge_device.metadata["url"]
        path_format_arguments = {"id": self._serialize.url("id", id, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        header_parameters["Accept"] = "application/json"
        header_parameters["Content-Type"] = "application/json; charset=utf-8"
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(content, "ConfigurationContent")

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize("object", response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    apply_on_edge_device.metadata = {"url": "/devices/{id}/applyConfigurationContent"}
