# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobRequest(Model):
    """JobRequest.

    :param job_id: Job identifier
    :type job_id: str
    :param type: Required.
     The type of job to execute. Possible values include: 'unknown', 'export',
     'import', 'backup', 'readDeviceProperties', 'writeDeviceProperties',
     'updateDeviceConfiguration', 'rebootDevice', 'factoryResetDevice',
     'firmwareUpdate', 'scheduleDeviceMethod', 'scheduleUpdateTwin',
     'restoreFromBackup', 'failoverDataCopy'
    :type type: str or ~protocol.models.enum
    :param cloud_to_device_method: Required if jobType is cloudToDeviceMethod.
     The method type and parameters.
    :type cloud_to_device_method: ~protocol.models.CloudToDeviceMethod
    :param update_twin:
    :type update_twin: ~protocol.models.Twin
    :param query_condition: Required if jobType is updateTwin or
     cloudToDeviceMethod.
     Condition for device query to get devices to execute the job on
    :type query_condition: str
    :param start_time: ISO 8601 date time to start the job
    :type start_time: datetime
    :param max_execution_time_in_seconds: Max execution time in secounds (ttl
     duration)
    :type max_execution_time_in_seconds: long
    """

    _attribute_map = {
        "job_id": {"key": "jobId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cloud_to_device_method": {"key": "cloudToDeviceMethod", "type": "CloudToDeviceMethod"},
        "update_twin": {"key": "updateTwin", "type": "Twin"},
        "query_condition": {"key": "queryCondition", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "max_execution_time_in_seconds": {"key": "maxExecutionTimeInSeconds", "type": "long"},
    }

    def __init__(self, **kwargs):
        super(JobRequest, self).__init__(**kwargs)
        self.job_id = kwargs.get("job_id", None)
        self.type = kwargs.get("type", None)
        self.cloud_to_device_method = kwargs.get("cloud_to_device_method", None)
        self.update_twin = kwargs.get("update_twin", None)
        self.query_condition = kwargs.get("query_condition", None)
        self.start_time = kwargs.get("start_time", None)
        self.max_execution_time_in_seconds = kwargs.get("max_execution_time_in_seconds", None)
